<!-- received="Fri Jul 21 18:49:57 2000 EET DST" -->
<!-- sent="Fri, 21 Jul 2000 16:46:05 +0100 (BST)" -->
<!-- name="Matthew Kirkwood" -->
<!-- email="weejock@ferret.lmh.ox.ac.uk" -->
<!-- subject="Re: transproxy and linux-2.4" -->
<!-- id="" -->
<!-- inreplyto="20000719030500.A2018@long.yar.ru" -->
<title>Linux-kernel mailing list archive 2000-29,: Re: transproxy and linux-2.4</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: transproxy and linux-2.4</h1>
<b>Matthew Kirkwood</b> (<a href="mailto:weejock@ferret.lmh.ox.ac.uk"><i>weejock@ferret.lmh.ox.ac.uk</i></a>)<br>
<i>Fri, 21 Jul 2000 16:46:05 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#786">[ date ]</a><a href="index.html#786">[ thread ]</a><a href="subject.html#786">[ subject ]</a><a href="author.html#786">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0787.html">Oliver Xymoron: "RE: Cache coherency... and locking"</a>
<li> <b>Previous message:</b> <a href="0785.html">Christopher Thompson: "MediaGX/Xpress Audio sound?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Wed, 19 Jul 2000, Alexander V. Lukyanov wrote:<br>
<p>
<i>&gt; iptables --table nat -A PREROUTING -p tcp -d 0.0.0.0/0 --dport 80 -j REDIRECT --to-port 81</i><br>
<i>&gt; iptables --table nat -A OUTPUT     -p tcp -d 0.0.0.0/0 --dport 80 -j REDIRECT --to-port 81</i><br>
<p>
<i>&gt; Everything works if the HTTP request includes Host: field with port</i><br>
<i>&gt; number. But if it is absent, the request goes to correct host but to</i><br>
<i>&gt; port 81, this is where tproxy listens. This happens when connection</i><br>
<i>&gt; originates at localhost, I have not tried it with forwarding yet.</i><br>
<i>&gt;</i><br>
<i>&gt; I guess this is either a bug in kernel (which returns wrong port in</i><br>
<i>&gt; getsockname), or there is some other method for retrieving original</i><br>
<i>&gt; port number. I hope somebody knows it.</i><br>
<p>
The getsockname() "hack" is dead in 2.4.<br>
<p>
See below...<br>
<p>
Matthew.<br>
<p>
<p>
Date: Thu, 23 Mar 2000 15:46:02 +1100<br>
From: Rusty Russell &lt;<a href="mailto:rusty@linuxcare.com.au">rusty@linuxcare.com.au</a>&gt;<br>
To: Multiple recipients of list NETFILTER &lt;<a href="mailto:netfilter@samba.org">netfilter@samba.org</a>&gt;<br>
Subject: Re: get*name() hack? <br>
<p>
In message &lt;Pine.LNX.4.21.0003221701570.24739-100000@ferret.lmh.ox.ac.uk&gt; you w<br>
rite:<br>
<i>&gt; Hi,</i><br>
<i>&gt; </i><br>
<i>&gt; A few questions from one mostly scared of the networking</i><br>
<i>&gt; code:</i><br>
<i>&gt; </i><br>
<i>&gt; Does the transproxy getsockname() hack still work under the</i><br>
<i>&gt; new regime?  If not, what do we do these days?</i><br>
<i>&gt; </i><br>
<i>&gt; What did the getpeername() hack do?</i><br>
<p>
I meant getsockname(), sorry (where did you read this, so I can fix<br>
it?)  Transproxy hacks gone.  Yay!  See below for example of new<br>
stuff (thanks to Patrick Schaaf).<br>
<p>
<i>&gt; What's the new stuff called?  Is it just called Netfilter, or</i><br>
<i>&gt; is it called "iptables, which happens to use the Netfilter</i><br>
<i>&gt; infrastructure"?  Or something else?</i><br>
<p>
`iptables, which happens to use the Netfilter infrastructure'.<br>
<p>
Rusty.<br>
================<br>
/* nf_getsockname() - netfilter SO_ORIGINAL_DST variant of getsockopt()<br>
 *<br>
 * Within the new Linux netfilter framework, NAT functionality is cleanly<br>
 * separated from the TCP/IP core processing. In old days, you could easily<br>
 * retrieve the original destination (IP address and port) of a transparently<br>
 * proxied connection by calling the normal getsockname() syscall.<br>
 * With netfilter, getsockname() returns the real local IP address and port.<br>
 * However, the netfilter code gives all TCP sockets a new socket option,<br>
 * SO_ORIGINAL_DST, for retrieval of the original IP/port combination.<br>
 *<br>
 * This file implements a function nf_getsockname(), with the same calling<br>
 * convention as getsockname() itself; it uses SO_ORIGINAL_DST, and if that<br>
 * fails, falls back to using getsockname() itself.<br>
 *<br>
 * Public domain by Patrick Schaaf &lt;<a href="mailto:bof@bof.de">bof@bof.de</a>&gt;<br>
 */<br>
<p>
#include &lt;errno.h&gt;<br>
#include &lt;netinet/in.h&gt;<br>
#include &lt;sys/socket.h&gt;<br>
#include &lt;linux/netfilter_ipv4.h&gt;<br>
<p>
int nf_getsockname(int fd, struct sockaddr *sa, int *salen)<br>
{<br>
	if (*salen != sizeof(struct sockaddr_in)) {<br>
		errno = EINVAL;<br>
		return -1;<br>
	}<br>
#ifdef SO_ORIGINAL_DST<br>
	if (0 == getsockopt(fd, SOL_IP, SO_ORIGINAL_DST, sa, salen)) {<br>
		return 0;<br>
	}<br>
#endif<br>
	return getsockname(fd, sa, salen);<br>
}<br>
================<br>
<pre>
--
Hacking time.
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0787.html">Oliver Xymoron: "RE: Cache coherency... and locking"</a>
<li> <b>Previous message:</b> <a href="0785.html">Christopher Thompson: "MediaGX/Xpress Audio sound?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
