<!-- received="Sat Jul 22 11:54:27 2000 EET DST" -->
<!-- sent="Sat, 22 Jul 2000 03:48:37 -0500 (EST)" -->
<!-- name="Alan Curry" -->
<!-- email="pacman-kernel@cqc.com" -->
<!-- subject="Re: MediaGX sound freezes 2.3.99-pre" -->
<!-- id="" -->
<!-- inreplyto="yam8236.362.145381152@mail.galactica.it" -->
<title>Linux-kernel mailing list archive 2000-29,: Re: MediaGX sound freezes 2.3.99-pre</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: MediaGX sound freezes 2.3.99-pre</h1>
<b>Alan Curry</b> (<a href="mailto:pacman-kernel@cqc.com"><i>pacman-kernel@cqc.com</i></a>)<br>
<i>Sat, 22 Jul 2000 03:48:37 -0500 (EST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1014">[ date ]</a><a href="index.html#1014">[ thread ]</a><a href="subject.html#1014">[ subject ]</a><a href="author.html#1014">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1015.html">Stephen Harris: "Re: Disk Destroyer, Cpu Reflashing, Root Security in General"</a>
<li> <b>Previous message:</b> <a href="1013.html">Shane Shrybman: "Re: Console blanking problem with X11 + 2.4.x"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Alessandro Zummo writes the following:<br>
<i>&gt;sorry, not so much time to work on it. have you tried to snoop out</i><br>
<i>&gt;the differences between .12 and .13 that could cause the </i><br>
<i>&gt;system to hang?</i><br>
<p>
OK, I've narrowed it down to a few small fragments of the patch, most of<br>
which deal with the addition of a "struct resource". Getting rid of that<br>
struct seems to be the key to making my sound work. I've configured out all<br>
drivers except IDE (my root partition) and SB, to avoid having to track this<br>
struct resource change in a hundred places.<br>
<p>
Here's the diff that breaks my sound. I don't know what to make of it,<br>
considering it doesn't touch drivers/sound at all. It's getting to the point<br>
that I can't break it down much further without getting compile errors. I<br>
hope it's small enough that someone can look it over and come up with a<br>
theory on why it would cause lockups. This diff applies cleanly to 2.3.13 if<br>
applied -R (reverse).<br>
<p>
I'm open to the possibility that it's a hardware flaw, but if it is a<br>
hardware flaw, all the 2.0 and 2.2 kernels dealt with a lot better...<br>
<p>
diff -ruN linux/arch/i386/kernel/bios32.c linuxcp/arch/i386/kernel/bios32.c<br>
--- linux/arch/i386/kernel/bios32.c	Sat Jul 22 02:09:55 2000<br>
+++ linuxcp/arch/i386/kernel/bios32.c	Sat Jul 22 02:07:02 2000<br>
@@ -907,12 +907,17 @@<br>
 		if ((try &amp; PCI_BASE_ADDRESS_IO_MASK) != addr) {<br>
 			addr = 0;<br>
 			printk("PCI: Address setup failed, got %04x\n", try);<br>
-		} else<br>
-			dev-&gt;base_address[idx] = try;<br>
+		} else {<br>
+			struct resource *res = dev-&gt;resource + idx;<br>
+			res-&gt;start = addr;<br>
+			res-&gt;end = addr + size - 1;<br>
+			res-&gt;flags |= PCI_BASE_ADDRESS_IO_MASK;<br>
+		}<br>
 	}<br>
 	if (!addr) {<br>
 		pcibios_write_config_dword(bus, devfn, reg, 0);<br>
-		dev-&gt;base_address[idx] = 0;<br>
+		dev-&gt;resource[idx].start = 0;<br>
+		dev-&gt;resource[idx].flags = 0;<br>
 	}<br>
 	pcibios_write_config_word(bus, devfn, PCI_COMMAND, cmd);<br>
 }<br>
@@ -939,7 +944,7 @@<br>
 			    e-&gt;vendor == d-&gt;vendor &amp;&amp;<br>
 			    e-&gt;device == d-&gt;device &amp;&amp;<br>
 			    e-&gt;class == d-&gt;class &amp;&amp;<br>
-			    !memcmp(e-&gt;base_address, d-&gt;base_address, sizeof(e-&gt;base_address)))<br>
+			    !memcmp(e-&gt;resource, d-&gt;resource, sizeof(e-&gt;resource)))<br>
 				break;<br>
 		if (!e)<br>
 			return;<br>
@@ -1060,7 +1065,7 @@<br>
 	int i;<br>
 <br>
 	for(i=0; i&lt;4; i++)<br>
-		d-&gt;base_address[i] |= PCI_BASE_ADDRESS_SPACE_IO;<br>
+		d-&gt;resource[i].flags |= PCI_BASE_ADDRESS_SPACE_IO;<br>
 }<br>
 <br>
 struct dev_ex {<br>
@@ -1112,11 +1117,12 @@<br>
 		 */<br>
 		has_io = has_mem = 0;<br>
 		for(i=0; i&lt;6; i++) {<br>
-			unsigned long a = dev-&gt;base_address[i];<br>
+			struct resource *res = dev-&gt;resource + i;<br>
+			unsigned long a = res-&gt;flags;<br>
 			if (a &amp; PCI_BASE_ADDRESS_SPACE_IO) {<br>
+				unsigned long addr = res-&gt;start;<br>
 				has_io = 1;<br>
-				a &amp;= PCI_BASE_ADDRESS_IO_MASK;<br>
-				if (!a || a == PCI_BASE_ADDRESS_IO_MASK)<br>
+				if (!addr || addr == PCI_BASE_ADDRESS_IO_MASK)<br>
 					pcibios_fixup_io_addr(dev, i);<br>
 			} else if (a &amp; PCI_BASE_ADDRESS_MEM_MASK)<br>
 				has_mem = 1;<br>
diff -ruN linux/drivers/block/ide-pci.c linuxcp/drivers/block/ide-pci.c<br>
--- linux/drivers/block/ide-pci.c	Sat Jul 22 02:14:06 2000<br>
+++ linuxcp/drivers/block/ide-pci.c	Sat Jul 22 02:07:02 2000<br>
@@ -257,20 +257,29 @@<br>
 	switch(dev-&gt;device) {<br>
 		case PCI_DEVICE_ID_TTI_HPT343:<br>
 			{<br>
-				int i;<br>
 				unsigned short pcicmd = 0;<br>
-				unsigned long hpt34xIoBase = dev-&gt;base_address[4] &amp; PCI_BASE_ADDRESS_IO_MASK;<br>
 <br>
 				pci_write_config_byte(dev, 0x80, 0x00);<br>
-				dev-&gt;base_address[0] = (hpt34xIoBase + 0x20);<br>
-				dev-&gt;base_address[1] = (hpt34xIoBase + 0x34);<br>
-				dev-&gt;base_address[2] = (hpt34xIoBase + 0x28);<br>
-				dev-&gt;base_address[3] = (hpt34xIoBase + 0x3c);<br>
-				for(i=0; i&lt;4; i++)<br>
-					dev-&gt;base_address[i] |= PCI_BASE_ADDRESS_SPACE_IO;<br>
-<br>
 				pci_read_config_word(dev, PCI_COMMAND, &amp;pcicmd);<br>
 				if (!(pcicmd &amp; PCI_COMMAND_MEMORY)) {<br>
+					/*<br>
+					 * FIXME - this is too ugly, and looks senseless.<br>
+					 * Why not just use resource[4]?<br>
+					 *<br>
+					 * This was a cleaner/quicker way to get the ioports<br>
+					 * that the are not decode do to a flaw in the chipset<br>
+					 * design.<br>
+					 */<br>
+<br>
+					int i;<br>
+					unsigned long hpt34xIoBase = dev-&gt;resource[4].start;<br>
+<br>
+					dev-&gt;resource[0].start = (hpt34xIoBase + 0x20);<br>
+					dev-&gt;resource[1].start = (hpt34xIoBase + 0x34);<br>
+					dev-&gt;resource[2].start = (hpt34xIoBase + 0x28);<br>
+					dev-&gt;resource[3].start = (hpt34xIoBase + 0x3c);<br>
+					for(i=0; i&lt;4; i++)<br>
+						dev-&gt;resource[i].flags |= PCI_BASE_ADDRESS_SPACE_IO;<br>
 					pci_write_config_byte(dev, PCI_LATENCY_TIMER, 0x20);<br>
 				} else {<br>
 					pci_write_config_byte(dev, PCI_LATENCY_TIMER, 0xF0);<br>
@@ -375,11 +384,15 @@<br>
 	/*<br>
 	 * Setup base registers for IDE command/control spaces for each interface:<br>
 	 */<br>
-	for (reg = 0; reg &lt; 4; reg++)<br>
-		if (!dev-&gt;base_address[reg]) {<br>
+	for (reg = 0; reg &lt; 4; reg++) {<br>
+		struct resource *res = dev-&gt;resource + reg;<br>
+		if (!(res-&gt;flags &amp; PCI_BASE_ADDRESS_SPACE_IO))<br>
+			continue;<br>
+		if (!res-&gt;start) {<br>
 			printk("%s: Missing I/O address #%d\n", name, reg);<br>
 			return 1;<br>
 		}<br>
+	}<br>
 	return 0;<br>
 }<br>
 <br>
@@ -478,8 +491,9 @@<br>
 		if (IDE_PCI_DEVID_EQ(d-&gt;devid, DEVID_HPT366) &amp;&amp; (port))<br>
 			return;<br>
 		if ((dev-&gt;class &gt;&gt; 8) != PCI_CLASS_STORAGE_IDE || (dev-&gt;class &amp; (port ? 4 : 1)) != 0) {<br>
-			ctl  = dev-&gt;base_address[(2*port)+1] &amp; PCI_BASE_ADDRESS_IO_MASK;<br>
-			base = dev-&gt;base_address[2*port] &amp; ~7;<br>
+			/* FIXME! This really should check that it really gets the IO/MEM part right! */<br>
+			ctl  = dev-&gt;resource[(2*port)+1].start;<br>
+			base = dev-&gt;resource[2*port].start;<br>
 		}<br>
 		if ((ctl &amp;&amp; !base) || (base &amp;&amp; !ctl)) {<br>
 			printk("%s: inconsistent baseregs (BIOS) for port %d, skipping\n", d-&gt;name, port);<br>
diff -ruN linux/drivers/pci/pci.c linuxcp/drivers/pci/pci.c<br>
--- linux/drivers/pci/pci.c	Sat Jul 22 02:17:14 2000<br>
+++ linuxcp/drivers/pci/pci.c	Sat Jul 22 02:07:02 2000<br>
@@ -29,8 +29,9 @@<br>
 <br>
 struct pci_bus pci_root;<br>
 struct pci_dev *pci_devices = NULL;<br>
+int pci_reverse __initdata = 0;<br>
+<br>
 static struct pci_dev **pci_last_dev_p = &amp;pci_devices;<br>
-static int pci_reverse __initdata = 0;<br>
 <br>
 struct pci_dev *<br>
 pci_find_slot(unsigned int bus, unsigned int devfn)<br>
@@ -143,25 +144,56 @@<br>
 	unsigned int reg;<br>
 	u32 l;<br>
 <br>
-	for(reg=0; reg&lt;howmany; reg++) {<br>
+	for(reg=0; reg &lt; howmany; reg++) {<br>
+		struct resource *res = dev-&gt;resource + reg;<br>
+		unsigned int mask, newval, size;<br>
+<br>
+		res-&gt;name = dev-&gt;name;<br>
 		pci_read_config_dword(dev, PCI_BASE_ADDRESS_0 + (reg &lt;&lt; 2), &amp;l);<br>
 		if (l == 0xffffffff)<br>
 			continue;<br>
-		dev-&gt;base_address[reg] = l;<br>
+<br>
+		pci_write_config_dword(dev, PCI_BASE_ADDRESS_0 + (reg &lt;&lt; 2), 0xffffffff);<br>
+		pci_read_config_dword(dev, PCI_BASE_ADDRESS_0 + (reg &lt;&lt; 2), &amp;newval);<br>
+		pci_write_config_dword(dev, PCI_BASE_ADDRESS_0 + (reg &lt;&lt; 2), l);<br>
+<br>
+		mask = PCI_BASE_ADDRESS_MEM_MASK;<br>
+		if (l &amp; PCI_BASE_ADDRESS_SPACE_IO)<br>
+			mask = PCI_BASE_ADDRESS_IO_MASK;<br>
+<br>
+		newval &amp;= mask;<br>
+		if (!newval)<br>
+			continue;<br>
+<br>
+		res-&gt;start = l &amp; mask;<br>
+		res-&gt;flags = l &amp; ~mask;<br>
+<br>
+		size = 1;<br>
+		do {<br>
+			size &lt;&lt;= 1;<br>
+		} while (!(size &amp; newval));<br>
+<br>
+		/* 64-bit memory? */<br>
 		if ((l &amp; (PCI_BASE_ADDRESS_SPACE | PCI_BASE_ADDRESS_MEM_TYPE_MASK))<br>
 		    == (PCI_BASE_ADDRESS_SPACE_MEMORY | PCI_BASE_ADDRESS_MEM_TYPE_64)) {<br>
+		    	unsigned int high;<br>
 			reg++;<br>
-			pci_read_config_dword(dev, PCI_BASE_ADDRESS_0 + (reg &lt;&lt; 2), &amp;l);<br>
-			if (l) {<br>
+			pci_read_config_dword(dev, PCI_BASE_ADDRESS_0 + (reg &lt;&lt; 2), &amp;high);<br>
+			if (high) {<br>
 #if BITS_PER_LONG == 64<br>
-				dev-&gt;base_address[reg-1] |= ((unsigned long) l) &lt;&lt; 32;<br>
+				res-&gt;start |= ((unsigned long) high) &lt;&lt; 32;<br>
 #else<br>
 				printk("PCI: Unable to handle 64-bit address for device %02x:%02x\n",<br>
 					dev-&gt;bus-&gt;number, dev-&gt;devfn);<br>
-				dev-&gt;base_address[reg-1] = 0;<br>
+				res-&gt;flags = 0;<br>
+				res-&gt;start = 0;<br>
+				res-&gt;end = 0;<br>
+				continue;<br>
 #endif<br>
 			}<br>
 		}<br>
+		res-&gt;end = res-&gt;start + size - 1;<br>
+		request_resource((l &amp; PCI_BASE_ADDRESS_SPACE_IO) ? &amp;ioport_resource : &amp;iomem_resource, res);<br>
 	}<br>
 }<br>
 <br>
diff -ruN linux/drivers/pci/proc.c linuxcp/drivers/pci/proc.c<br>
--- linux/drivers/pci/proc.c	Sat Jul 22 02:18:42 2000<br>
+++ linuxcp/drivers/pci/proc.c	Sat Jul 22 02:07:02 2000<br>
@@ -11,6 +11,7 @@<br>
 #include &lt;linux/pci.h&gt;<br>
 #include &lt;linux/proc_fs.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
+<br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;asm/byteorder.h&gt;<br>
 <br>
@@ -246,14 +247,15 @@<br>
 			dev-&gt;vendor,<br>
 			dev-&gt;device,<br>
 			dev-&gt;irq);<br>
-		for(i=0; i&lt;6; i++)<br>
+		for(i=0; i&lt;6; i++) {<br>
 			len += sprintf(buf+len,<br>
 #if BITS_PER_LONG == 32<br>
 						"\t%08lx",<br>
 #else<br>
 						"\t%016lx",<br>
 #endif<br>
-					dev-&gt;base_address[i]);<br>
+					dev-&gt;resource[i].start | (dev-&gt;resource[i].flags &amp; 0xf));<br>
+		}<br>
 		len += sprintf(buf+len,<br>
 #if BITS_PER_LONG == 32<br>
 					"\t%08lx",<br>
diff -ruN linux/include/linux/pci.h linuxcp/include/linux/pci.h<br>
--- linux/include/linux/pci.h	Sat Jul 22 02:19:19 2000<br>
+++ linuxcp/include/linux/pci.h	Sat Jul 22 02:07:02 2000<br>
@@ -1245,7 +1245,7 @@<br>
 	/* Base registers for this device, can be adjusted by<br>
 	 * pcibios_fixup() as necessary.<br>
 	 */<br>
-	unsigned long	base_address[6];<br>
+	struct resource resource[6];<br>
 	unsigned long	rom_address;<br>
 };<br>
 <br>
diff -ruN linux/kernel/resource.c linuxcp/kernel/resource.c<br>
--- linux/kernel/resource.c	Sat Jul 22 02:24:00 2000<br>
+++ linuxcp/kernel/resource.c	Sat Jul 22 02:07:02 2000<br>
@@ -12,9 +12,13 @@<br>
 #include &lt;linux/init.h&gt;<br>
 #include &lt;linux/malloc.h&gt;<br>
 <br>
+#include &lt;asm/spinlock.h&gt;<br>
+<br>
 struct resource ioport_resource = { "PCI IO", 0x0000, 0xFFFF };<br>
 struct resource iomem_resource = { "PCI mem", 0x00000000, 0xFFFFFFFF };<br>
 <br>
+static rwlock_t resource_lock = RW_LOCK_UNLOCKED;<br>
+<br>
 /*<br>
  * This generates reports for /proc/ioports and /proc/memory<br>
  */<br>
@@ -47,25 +51,30 @@<br>
 int get_resource_list(struct resource *root, char *buf, int size)<br>
 {<br>
 	char *fmt;<br>
+	int retval;<br>
 <br>
 	fmt = "        %08lx-%08lx : %s\n";<br>
 	if (root == &amp;ioport_resource)<br>
 		fmt = "        %04lx-%04lx : %s\n";<br>
-	return do_resource_list(root-&gt;child, fmt, 8, buf, buf + size) - buf;<br>
+	read_lock(&amp;resource_lock);<br>
+	retval = do_resource_list(root-&gt;child, fmt, 8, buf, buf + size) - buf;<br>
+	read_unlock(&amp;resource_lock);<br>
+	return retval;<br>
 }	<br>
 <br>
-int request_resource(struct resource *root, struct resource *new)<br>
+/* Return the conflict entry if you can't request it */<br>
+static struct resource * __request_resource(struct resource *root, struct resource *new)<br>
 {<br>
 	unsigned long start = new-&gt;start;<br>
 	unsigned long end = new-&gt;end;<br>
 	struct resource *tmp, **p;<br>
 <br>
 	if (end &lt; start)<br>
-		return -EINVAL;<br>
+		return root;<br>
 	if (start &lt; root-&gt;start)<br>
-		return -EINVAL;<br>
+		return root;<br>
 	if (end &gt; root-&gt;end)<br>
-		return -EINVAL;<br>
+		return root;<br>
 	p = &amp;root-&gt;child;<br>
 	for (;;) {<br>
 		tmp = *p;<br>
@@ -73,15 +82,25 @@<br>
 			new-&gt;sibling = tmp;<br>
 			*p = new;<br>
 			new-&gt;parent = root;<br>
-			return 0;<br>
+			return NULL;<br>
 		}<br>
 		p = &amp;tmp-&gt;sibling;<br>
 		if (tmp-&gt;end &lt; start)<br>
 			continue;<br>
-		return -EBUSY;<br>
+		return tmp;<br>
 	}<br>
 }<br>
 <br>
+int request_resource(struct resource *root, struct resource *new)<br>
+{<br>
+	struct resource *conflict;<br>
+<br>
+	write_lock(&amp;resource_lock);<br>
+	conflict = __request_resource(root, new);<br>
+	write_unlock(&amp;resource_lock);<br>
+	return conflict ? -EBUSY : 0;<br>
+}<br>
+<br>
 int release_resource(struct resource *old)<br>
 {<br>
 	struct resource *tmp, **p;<br>
@@ -101,6 +120,18 @@<br>
 	return -EINVAL;<br>
 }<br>
 <br>
+/*<br>
+ * This is compatibility stuff for IO resources.<br>
+ *<br>
+ * Note how this, unlike the above, knows about<br>
+ * the IO flag meanings (busy etc).<br>
+ *<br>
+ * Request-region creates a new busy region.<br>
+ *<br>
+ * Check-region returns non-zero if the area is already busy<br>
+ *<br>
+ * Release-region releases a matching busy region.<br>
+ */<br>
 struct resource * __request_region(struct resource *parent, unsigned long start, unsigned long n, const char *name)<br>
 {<br>
 	struct resource *res = kmalloc(sizeof(*res), GFP_KERNEL);<br>
@@ -110,21 +141,33 @@<br>
 		res-&gt;name = name;<br>
 		res-&gt;start = start;<br>
 		res-&gt;end = start + n - 1;<br>
-		if (request_resource(parent, res) != 0) {<br>
+		res-&gt;flags = IORESOURCE_BUSY;<br>
+<br>
+		write_lock(&amp;resource_lock);<br>
+<br>
+		for (;;) {<br>
+			struct resource *conflict;<br>
+<br>
+			conflict = __request_resource(parent, res);<br>
+			if (!conflict)<br>
+				break;<br>
+			if (conflict != parent) {<br>
+				parent = conflict;<br>
+				if (!(conflict-&gt;flags &amp; IORESOURCE_BUSY))<br>
+					continue;<br>
+			}<br>
+<br>
+			/* Uhhuh, that didn't work out.. */<br>
 			kfree(res);<br>
 			res = NULL;<br>
+			break;<br>
 		}<br>
+		write_unlock(&amp;resource_lock);<br>
 	}<br>
 	return res;<br>
 }<br>
 <br>
 /*<br>
- * Compatibility cruft.<br>
- *<br>
- * Check-region returns non-zero if something already exists.<br>
- *<br>
- * Release-region releases an anonymous region that matches<br>
- * the IO port range.<br>
  */<br>
 int __check_region(struct resource *parent, unsigned long start, unsigned long n)<br>
 {<br>
@@ -152,7 +195,13 @@<br>
 <br>
 		if (!res)<br>
 			break;<br>
-		if (res-&gt;start == start &amp;&amp; res-&gt;end == end) {<br>
+		if (res-&gt;start &lt;= start &amp;&amp; res-&gt;end &gt;= end) {<br>
+			if (!(res-&gt;flags &amp; IORESOURCE_BUSY)) {<br>
+				p = &amp;res-&gt;child;<br>
+				continue;<br>
+			}<br>
+			if (res-&gt;start != start || res-&gt;end != end)<br>
+				break;<br>
 			*p = res-&gt;sibling;<br>
 			kfree(res);<br>
 			return;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1015.html">Stephen Harris: "Re: Disk Destroyer, Cpu Reflashing, Root Security in General"</a>
<li> <b>Previous message:</b> <a href="1013.html">Shane Shrybman: "Re: Console blanking problem with X11 + 2.4.x"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
