/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.IntegralImage;
import com.stromberglabs.jopensurf.ResponseLayer;
import com.stromberglabs.jopensurf.SURFInterestPoint;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;

public class FastHessian
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int[][] filter_map = new int[][]{{0, 1, 2, 3}, {1, 3, 4, 5}, {3, 5, 6, 7}, {5, 7, 8, 9}, {7, 9, 10, 11}};
    private IntegralImage mIntegralImage;
    private List<SURFInterestPoint> mInterestPoints;
    private int mOctaves;
    private int mInitSample;
    private float mThreshold;
    private int mHeight;
    private int mWidth;
    private boolean mRecalculateInterestPoints = true;
    List<ResponseLayer> mLayers;

    public FastHessian(IntegralImage integralImage, int n, int n2, float f, float f2) {
        this.mIntegralImage = integralImage;
        this.mOctaves = n;
        this.mInitSample = n2;
        this.mThreshold = f;
        this.mWidth = integralImage.getWidth();
        this.mHeight = integralImage.getHeight();
    }

    public List<SURFInterestPoint> getIPoints() {
        if (this.mInterestPoints == null || this.mRecalculateInterestPoints) {
            this.mInterestPoints = new LinkedList<SURFInterestPoint>();
            this.buildResponseMap();
            for (int i = 0; i < this.mOctaves; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    ResponseLayer responseLayer = this.mLayers.get(filter_map[i][j]);
                    ResponseLayer responseLayer2 = this.mLayers.get(filter_map[i][j + 1]);
                    ResponseLayer responseLayer3 = this.mLayers.get(filter_map[i][j + 2]);
                    for (int k = 0; k < responseLayer3.getHeight(); ++k) {
                        for (int i2 = 0; i2 < responseLayer3.getWidth(); ++i2) {
                            SURFInterestPoint sURFInterestPoint;
                            if (!this.isExtremum(k, i2, responseLayer3, responseLayer2, responseLayer) || (sURFInterestPoint = this.interpolateExtremum(k, i2, responseLayer3, responseLayer2, responseLayer)) == null) continue;
                            this.mInterestPoints.add(sURFInterestPoint);
                        }
                    }
                }
            }
        }
        return this.mInterestPoints;
    }

    private void buildResponseMap() {
        this.mLayers = new LinkedList<ResponseLayer>();
        int n = this.mWidth / this.mInitSample;
        int n2 = this.mHeight / this.mInitSample;
        int n3 = this.mInitSample;
        if (this.mOctaves >= 1) {
            this.mLayers.add(new ResponseLayer(n, n2, n3, 9, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(n, n2, n3, 15, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(n, n2, n3, 21, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(n, n2, n3, 27, this.mIntegralImage));
        }
        if (this.mOctaves >= 2) {
            this.mLayers.add(new ResponseLayer(n / 2, n2 / 2, n3 * 2, 39, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(n / 2, n2 / 2, n3 * 2, 51, this.mIntegralImage));
        }
        if (this.mOctaves >= 3) {
            this.mLayers.add(new ResponseLayer(n / 4, n2 / 4, n3 * 4, 75, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(n / 4, n2 / 4, n3 * 4, 99, this.mIntegralImage));
        }
        if (this.mOctaves >= 4) {
            this.mLayers.add(new ResponseLayer(n / 8, n2 / 8, n3 * 8, 147, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(n / 8, n2 / 8, n3 * 8, 195, this.mIntegralImage));
        }
        if (this.mOctaves >= 5) {
            this.mLayers.add(new ResponseLayer(n / 16, n2 / 16, n3 * 16, 291, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(n / 16, n2 / 16, n3 * 16, 387, this.mIntegralImage));
        }
    }

    private boolean isExtremum(int n, int n2, ResponseLayer responseLayer, ResponseLayer responseLayer2, ResponseLayer responseLayer3) {
        int n3 = (responseLayer.getFilter() + 1) / (2 * responseLayer.getStep());
        if (n <= n3 || n >= responseLayer.getHeight() - n3 || n2 <= n3 || n2 >= responseLayer.getWidth() - n3) {
            return false;
        }
        double d = responseLayer2.getResponse(n, n2, responseLayer);
        if (d < (double)this.mThreshold) {
            return false;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (!(responseLayer.getResponse(n + i, n2 + j) >= d) && (i == 0 && j == 0 || !(responseLayer2.getResponse(n + i, n2 + j, responseLayer) >= d)) && !(responseLayer3.getResponse(n + i, n2 + j, responseLayer) >= d)) continue;
                return false;
            }
        }
        return true;
    }

    private SURFInterestPoint interpolateExtremum(int n, int n2, ResponseLayer responseLayer, ResponseLayer responseLayer2, ResponseLayer responseLayer3) {
        int n3 = responseLayer2.getFilter() - responseLayer3.getFilter();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = this.interpolateStep(n, n2, responseLayer, responseLayer2, responseLayer3);
        d = dArray[0];
        d2 = dArray[1];
        d3 = dArray[2];
        if (Math.abs(d) < 0.5 & Math.abs(d2) < 0.5 && Math.abs(d3) < 0.5) {
            float f = (float)((double)n2 + d3) * (float)responseLayer.getStep();
            float f2 = (float)((double)n + d2) * (float)responseLayer.getStep();
            float f3 = (float)((double)0.1333f * ((double)responseLayer2.getFilter() + d * (double)n3));
            int n4 = (int)responseLayer2.getLaplacian(n, n2, responseLayer);
            return new SURFInterestPoint(f, f2, f3, n4);
        }
        return null;
    }

    private double[] interpolateStep(int n, int n2, ResponseLayer responseLayer, ResponseLayer responseLayer2, ResponseLayer responseLayer3) {
        double[] dArray = new double[3];
        RealMatrix realMatrix = this.getPartialDerivativeMatrix(n, n2, responseLayer, responseLayer2, responseLayer3);
        RealMatrix realMatrix2 = this.getHessian3DMatrix(n, n2, responseLayer, responseLayer2, responseLayer3);
        RealMatrix realMatrix3 = realMatrix2.inverse().multiply(realMatrix);
        dArray[0] = realMatrix3.getEntry(2, 0);
        dArray[1] = realMatrix3.getEntry(1, 0);
        dArray[2] = realMatrix3.getEntry(0, 0);
        return dArray;
    }

    private RealMatrix getPartialDerivativeMatrix(int n, int n2, ResponseLayer responseLayer, ResponseLayer responseLayer2, ResponseLayer responseLayer3) {
        double[][] dArray = new double[3][1];
        dArray[0][0] = (responseLayer2.getResponse(n, n2 + 1, responseLayer) - responseLayer2.getResponse(n, n2 - 1, responseLayer)) / 2.0;
        dArray[1][0] = (responseLayer2.getResponse(n + 1, n2, responseLayer) - responseLayer2.getResponse(n - 1, n2, responseLayer)) / 2.0;
        dArray[2][0] = (responseLayer.getResponse(n, n2) - responseLayer3.getResponse(n, n2, responseLayer)) / 2.0;
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl(dArray);
        return realMatrixImpl;
    }

    private RealMatrix getHessian3DMatrix(int n, int n2, ResponseLayer responseLayer, ResponseLayer responseLayer2, ResponseLayer responseLayer3) {
        double[][] dArray = new double[3][3];
        double d = responseLayer2.getResponse(n, n2, responseLayer);
        dArray[0][0] = responseLayer2.getResponse(n, n2 + 1, responseLayer) + responseLayer2.getResponse(n, n2 - 1, responseLayer) - 2.0 * d;
        dArray[1][1] = responseLayer2.getResponse(n + 1, n2, responseLayer) + responseLayer2.getResponse(n - 1, n2, responseLayer) - 2.0 * d;
        dArray[2][2] = responseLayer.getResponse(n, n2) + responseLayer3.getResponse(n, n2, responseLayer) - 2.0 * d;
        double d2 = (responseLayer2.getResponse(n + 1, n2 + 1, responseLayer) - responseLayer2.getResponse(n + 1, n2 - 1, responseLayer) - responseLayer2.getResponse(n - 1, n2 + 1, responseLayer) + responseLayer2.getResponse(n - 1, n2 - 1, responseLayer)) / 4.0;
        dArray[1][0] = d2;
        dArray[0][1] = d2;
        double d3 = (responseLayer.getResponse(n, n2 + 1) - responseLayer.getResponse(n, n2 - 1) - responseLayer3.getResponse(n, n2 + 1, responseLayer) + responseLayer3.getResponse(n, n2 - 1, responseLayer)) / 4.0;
        dArray[2][0] = d3;
        dArray[0][2] = d3;
        double d4 = (responseLayer.getResponse(n + 1, n2) - responseLayer.getResponse(n - 1, n2) - responseLayer3.getResponse(n + 1, n2, responseLayer) + responseLayer3.getResponse(n - 1, n2, responseLayer)) / 4.0;
        dArray[2][1] = d4;
        dArray[1][2] = d4;
        return new RealMatrixImpl(dArray);
    }

    public static void main(String[] stringArray) {
        try {
            IntegralImage integralImage = new IntegralImage(ImageIO.read(new File("C:\\workspace\\opensurf\\OpenSURF\\Images\\sf.jpg")));
            FastHessian fastHessian = new FastHessian(integralImage, 5, 2, 0.004f, 0.81f);
            fastHessian.getIPoints();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

