/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.IntegralImage;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;

public class ImageTransformUtils {
    public static BufferedImage convertToGrayscale(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        colorConvertOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static float BoxIntegral(IntegralImage integralImage, int n, int n2, int n3, int n4) {
        int n5 = integralImage.getHeight();
        int n6 = integralImage.getWidth();
        int n7 = Math.min(n, n5) - 1;
        int n8 = Math.min(n2, n6) - 1;
        int n9 = Math.min(n + n3, n5) - 1;
        int n10 = Math.min(n2 + n4, n6) - 1;
        float f = n7 >= 0 && n8 >= 0 ? integralImage.getValue(n8, n7) : 0.0f;
        float f2 = n7 >= 0 && n10 >= 0 ? integralImage.getValue(n10, n7) : 0.0f;
        float f3 = n9 >= 0 && n8 >= 0 ? integralImage.getValue(n8, n9) : 0.0f;
        float f4 = n9 >= 0 && n10 >= 0 ? integralImage.getValue(n10, n9) : 0.0f;
        return Math.max(0.0f, f - f2 - f3 + f4);
    }

    public static BufferedImage getTransformedImage(BufferedImage bufferedImage, double d, double d2, double d3, double d4) {
        AffineTransform affineTransform = new AffineTransform();
        if (d > 0.0 && d2 > 0.0) {
            affineTransform.scale(d, d2);
        }
        if (d3 > 0.0 && d4 > 0.0) {
            affineTransform.shear(d3, d4);
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static void main(String[] stringArray) {
    }
}

