/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;

public class IntegralImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float[][] mIntImage;
    private int mWidth = -1;
    private int mHeight = -1;

    public float[][] getValues() {
        return this.mIntImage;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public float getValue(int n, int n2) {
        return this.mIntImage[n][n2];
    }

    public IntegralImage(BufferedImage bufferedImage) {
        this.mIntImage = new float[bufferedImage.getWidth()][bufferedImage.getHeight()];
        this.mWidth = this.mIntImage.length;
        this.mHeight = this.mIntImage[0].length;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < n2; ++i) {
            float f = 0.0f;
            for (int j = 0; j < n; ++j) {
                writableRaster.getPixel(j, i, nArray);
                float f2 = (float)Math.round(0.299 * (double)nArray[0] + 0.587 * (double)nArray[1] + 0.114 * (double)nArray[2]) / 255.0f;
                this.mIntImage[j][i] = i == 0 ? f : (f += f2) + this.mIntImage[j][i - 1];
            }
        }
    }
}

