/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.ImageTransformUtils;
import com.stromberglabs.jopensurf.IntegralImage;
import java.io.Serializable;

public class ResponseLayer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int mWidth;
    private int mHeight;
    private int mStep;
    private int mFilter;
    private char[][] mLaplacian;
    private double[][] mResponses;

    ResponseLayer(int n, int n2, int n3, int n4, IntegralImage integralImage) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mStep = n3;
        this.mFilter = n4;
        this.mLaplacian = new char[this.mWidth][this.mHeight];
        this.mResponses = new double[this.mWidth][this.mHeight];
        this.buildResponseLayer(integralImage);
    }

    private void buildResponseLayer(IntegralImage integralImage) {
        int n = (this.mFilter - 1) / 2 + 1;
        int n2 = this.mFilter / 3;
        int n3 = this.mFilter;
        double d = 1.0 / (double)(n3 * n3);
        int n4 = 0;
        for (int i = 0; i < this.mHeight; ++i) {
            int n5 = 0;
            while (n5 < this.mWidth) {
                int n6 = i * this.mStep;
                int n7 = n5 * this.mStep;
                double d2 = ImageTransformUtils.BoxIntegral(integralImage, n6 - n2 + 1, n7 - n, 2 * n2 - 1, n3) - ImageTransformUtils.BoxIntegral(integralImage, n6 - n2 + 1, n7 - n2 / 2, 2 * n2 - 1, n2) * 3.0f;
                double d3 = ImageTransformUtils.BoxIntegral(integralImage, n6 - n, n7 - n2 + 1, n3, 2 * n2 - 1) - ImageTransformUtils.BoxIntegral(integralImage, n6 - n2 / 2, n7 - n2 + 1, n2, 2 * n2 - 1) * 3.0f;
                double d4 = ImageTransformUtils.BoxIntegral(integralImage, n6 - n2, n7 + 1, n2, n2) + ImageTransformUtils.BoxIntegral(integralImage, n6 + 1, n7 - n2, n2, n2) - ImageTransformUtils.BoxIntegral(integralImage, n6 - n2, n7 - n2, n2, n2) - ImageTransformUtils.BoxIntegral(integralImage, n6 + 1, n7 + 1, n2, n2);
                this.mResponses[n5][i] = (d2 *= d) * (d3 *= d) - (double)0.81f * (d4 *= d) * d4;
                this.mLaplacian[n5][i] = (char)(d2 + d3 >= 0.0 ? 1 : 0);
                ++n5;
                ++n4;
            }
        }
    }

    public double getResponse(int n, int n2) {
        return this.mResponses[n2][n];
    }

    public char getLaplacian(int n, int n2) {
        return this.mLaplacian[n2][n];
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getFilter() {
        return this.mFilter;
    }

    public int getStep() {
        return this.mStep;
    }

    public double getResponse(int n, int n2, ResponseLayer responseLayer) {
        int n3 = this.getWidth() / responseLayer.getWidth();
        return this.getResponse(n * n3, n2 * n3);
    }

    public float getLaplacian(int n, int n2, ResponseLayer responseLayer) {
        int n3 = this.getWidth() / responseLayer.getWidth();
        return this.getLaplacian(n * n3, n2 * n3);
    }
}

