/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.InterestPoint;
import java.io.Serializable;
import java.util.Arrays;

public class SURFInterestPoint
implements Serializable,
Cloneable,
InterestPoint {
    private static final long serialVersionUID = 1L;
    private float mX;
    private float mY;
    private float mScale;
    private float mOrientation;
    private int mLaplacian;
    private float[] mDescriptor;
    private float mDx;
    private float mDy;
    private int mClusterIndex;

    public SURFInterestPoint(float f, float f2, float f3, int n) {
        this.mX = f;
        this.mY = f2;
        this.mScale = f3;
        this.mLaplacian = n;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getScale() {
        return this.mScale;
    }

    public float getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(float f) {
        this.mOrientation = f;
    }

    public int getLaplacian() {
        return this.mLaplacian;
    }

    public float[] getDescriptor() {
        return this.mDescriptor;
    }

    public float[] getLocation() {
        return this.mDescriptor;
    }

    public void setDescriptor(float[] fArray) {
        this.mDescriptor = fArray;
    }

    public float getDx() {
        return this.mDx;
    }

    public void setDx(float f) {
        this.mDx = f;
    }

    public float getDy() {
        return this.mDy;
    }

    public void setDy(float f) {
        this.mDy = f;
    }

    public int getClusterIndex() {
        return this.mClusterIndex;
    }

    public void setClusterIndex(int n) {
        this.mClusterIndex = n;
    }

    @Override
    public double getDistance(InterestPoint interestPoint) {
        double d = 0.0;
        if (interestPoint.getLocation() == null || this.mDescriptor == null) {
            return 3.4028234663852886E38;
        }
        for (int i = 0; i < this.mDescriptor.length; ++i) {
            double d2 = this.mDescriptor[i] - interestPoint.getLocation()[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public Float getCoord(int n) {
        return Float.valueOf(this.mDescriptor[n]);
    }

    public int getDimensions() {
        return this.mDescriptor.length;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEquivalentTo(SURFInterestPoint sURFInterestPoint) {
        boolean bl = true;
        bl &= this.mX == sURFInterestPoint.getX();
        bl &= this.mY == sURFInterestPoint.getY();
        bl &= this.mDx == sURFInterestPoint.getDx();
        bl &= this.mDy == sURFInterestPoint.getDy();
        bl &= this.mOrientation == sURFInterestPoint.getOrientation();
        bl &= this.mScale == sURFInterestPoint.getScale();
        bl &= this.mLaplacian == sURFInterestPoint.getLaplacian();
        return bl &= Arrays.equals(this.mDescriptor, sURFInterestPoint.getDescriptor());
    }
}

