/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.FastHessian;
import com.stromberglabs.jopensurf.GaussianConstants;
import com.stromberglabs.jopensurf.ImageTransformUtils;
import com.stromberglabs.jopensurf.IntegralImage;
import com.stromberglabs.jopensurf.SURFInterestPoint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class Surf
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int HESSIAN_OCTAVES = 5;
    private static final int HESSIAN_INIT_SAMPLE = 2;
    private static final float HESSIAN_THRESHOLD = 4.0E-4f;
    private static final float HESSIAN_BALANCE_VALUE = 0.81f;
    private transient BufferedImage mOriginalImage;
    private FastHessian mHessian;
    private List<SURFInterestPoint> mFreeOrientedPoints;
    private List<SURFInterestPoint> mUprightPoints;
    private List<SURFInterestPoint> mDescriptorFreeInterestPoints;
    private int mNumOctaves = 5;
    private float mThreshold = 4.0E-4f;
    private float mBalanceValue = 0.81f;
    private IntegralImage mIntegralImage;

    public Surf(BufferedImage bufferedImage) {
        this.mOriginalImage = bufferedImage;
    }

    public Surf(BufferedImage bufferedImage, float f, float f2, int n) {
        this.mOriginalImage = bufferedImage;
        this.mNumOctaves = n;
        this.mBalanceValue = f;
        this.mThreshold = f2;
    }

    public List<SURFInterestPoint> getUprightInterestPoints() {
        return this.getPoints(true);
    }

    public List<SURFInterestPoint> getFreeOrientedInterestPoints() {
        return this.getPoints(false);
    }

    private List<SURFInterestPoint> getPoints(boolean bl) {
        List<SURFInterestPoint> list;
        List<SURFInterestPoint> list2 = list = bl ? this.mFreeOrientedPoints : this.mUprightPoints;
        if (list == null) {
            list = this.getDescriptorFreeInterestPoints();
            for (SURFInterestPoint sURFInterestPoint : list) {
                this.getOrientation(sURFInterestPoint);
                this.getMDescriptor(sURFInterestPoint, bl);
            }
        }
        return list;
    }

    private List<SURFInterestPoint> getDescriptorFreeInterestPoints() {
        if (this.mDescriptorFreeInterestPoints == null) {
            this.mDescriptorFreeInterestPoints = this.getHessian().getIPoints();
        }
        ArrayList<SURFInterestPoint> arrayList = new ArrayList<SURFInterestPoint>(this.mDescriptorFreeInterestPoints.size());
        for (SURFInterestPoint sURFInterestPoint : this.mDescriptorFreeInterestPoints) {
            try {
                arrayList.add((SURFInterestPoint)sURFInterestPoint.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return arrayList;
    }

    private FastHessian getHessian() {
        if (this.mHessian == null) {
            this.mHessian = new FastHessian(this.getIntegralImage(), this.mNumOctaves, 2, this.mThreshold, this.mBalanceValue);
        }
        return this.mHessian;
    }

    private IntegralImage getIntegralImage() {
        if (this.mIntegralImage == null) {
            this.mIntegralImage = new IntegralImage(this.mOriginalImage);
        }
        return this.mIntegralImage;
    }

    private float haarX(int n, int n2, int n3) {
        return ImageTransformUtils.BoxIntegral(this.mIntegralImage, n - n3 / 2, n2, n3, n3 / 2) - 1.0f * ImageTransformUtils.BoxIntegral(this.mIntegralImage, n - n3 / 2, n2 - n3 / 2, n3, n3 / 2);
    }

    private float haarY(int n, int n2, int n3) {
        return ImageTransformUtils.BoxIntegral(this.mIntegralImage, n, n2 - n3 / 2, n3 / 2, n3) - 1.0f * ImageTransformUtils.BoxIntegral(this.mIntegralImage, n - n3 / 2, n2 - n3 / 2, n3 / 2, n3);
    }

    private void getOrientation(SURFInterestPoint sURFInterestPoint) {
        float f = sURFInterestPoint.getScale();
        int n = Math.round(f);
        int n2 = Math.round(sURFInterestPoint.getY());
        int n3 = Math.round(sURFInterestPoint.getX());
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (int i = -6; i <= 6; ++i) {
            for (int j = -6; j <= 6; ++j) {
                if (i * i + j * j >= 36) continue;
                double d = GaussianConstants.Gauss25[Math.abs(i)][Math.abs(j)];
                double d2 = d * (double)this.haarX(n2 + j * n, n3 + i * n, 4 * n);
                double d3 = d * (double)this.haarY(n2 + j * n, n3 + i * n, 4 * n);
                arrayList.add(d2);
                arrayList2.add(d3);
                arrayList3.add(this.getAngle(d2, d3));
            }
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        while ((double)f6 < Math.PI * 2) {
            float f7 = (float)((double)f6 + 1.0471975511965976 > Math.PI * 2 ? (double)f6 - 5.235987755982989 : (double)f6 + 1.0471975511965976);
            f3 = 0.0f;
            f2 = 0.0f;
            for (int i = 0; i < arrayList3.size(); ++i) {
                float f8 = ((Double)arrayList3.get(i)).floatValue();
                if (f6 < f7 && f6 < f8 && f8 < f7) {
                    f2 += ((Double)arrayList.get(i)).floatValue();
                    f3 += ((Double)arrayList2.get(i)).floatValue();
                    continue;
                }
                if (!(f7 < f6) || !(f8 > 0.0f && f8 < f7) && (!(f8 > f6) || !((double)f8 < Math.PI * 2))) continue;
                f2 += ((Double)arrayList.get(i)).floatValue();
                f3 += ((Double)arrayList2.get(i)).floatValue();
            }
            if (f2 * f2 + f3 * f3 > f4) {
                f4 = f2 * f2 + f3 * f3;
                f5 = (float)this.getAngle(f2, f3);
            }
            f6 += 0.15f;
        }
        sURFInterestPoint.setOrientation(f5);
    }

    private void getMDescriptor(SURFInterestPoint sURFInterestPoint, boolean bl) {
        int n = 0;
        double d = 1.0;
        double d2 = 0.0;
        float[] fArray = new float[64];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        float f = -0.5f;
        float f2 = 0.0f;
        double d12 = sURFInterestPoint.getScale();
        int n6 = Math.round(sURFInterestPoint.getX());
        int n7 = Math.round(sURFInterestPoint.getY());
        if (!bl) {
            d = Math.cos(sURFInterestPoint.getOrientation());
            d2 = Math.sin(sURFInterestPoint.getOrientation());
        }
        for (n2 = -8; n2 < 12; n2 += 9) {
            n2 -= 4;
            f += 1.0f;
            f2 = -0.5f;
            for (n4 = -8; n4 < 12; n4 += 9) {
                double d13 = 0.0;
                double d14 = 0.0;
                double d15 = 0.0;
                double d16 = 0.0;
                f2 += 1.0f;
                n3 = n2 + 5;
                n5 = (n4 -= 4) + 5;
                d5 = Math.round((double)n6 + ((double)(-n5) * d12 * d2 + (double)n3 * d12 * d));
                d6 = Math.round((double)n7 + ((double)n5 * d12 * d + (double)n3 * d12 * d2));
                for (int i = n2; i < n2 + 9; ++i) {
                    for (int j = n4; j < n4 + 9; ++j) {
                        int n8 = (int)Math.round((double)n6 + (-1.0 * (double)j * d12 * d2 + (double)i * d12 * d));
                        int n9 = (int)Math.round((double)n7 + ((double)j * d12 * d + (double)i * d12 * d2));
                        d3 = this.gaussian(d5 - (double)n8, d6 - (double)n9, 2.5 * d12);
                        d7 = this.haarX(n9, n8, (int)(2L * Math.round(d12)));
                        d8 = this.haarY(n9, n8, (int)(2L * Math.round(d12)));
                        d9 = d3 * (-d7 * d2 + d8 * d);
                        d10 = d3 * (d7 * d + d8 * d2);
                        d16 += d9;
                        d15 += d10;
                        d14 += Math.abs(d9);
                        d13 += Math.abs(d10);
                    }
                }
                d4 = this.gaussian(f - 2.0f, f2 - 2.0f, 1.5);
                fArray[n++] = (float)(d16 * d4);
                fArray[n++] = (float)(d15 * d4);
                fArray[n++] = (float)(d14 * d4);
                fArray[n++] = (float)(d13 * d4);
                d11 += (d16 * d16 + d15 * d15 + d14 * d14 + d13 * d13) * (d4 * d4);
            }
        }
        d11 = Math.sqrt(d11);
        n2 = 0;
        while (n2 < 64) {
            int n10 = n2++;
            fArray[n10] = (float)((double)fArray[n10] / d11);
        }
        sURFInterestPoint.setDescriptor(fArray);
    }

    private double getAngle(double d, double d2) {
        if (d >= 0.0 && d2 >= 0.0) {
            return Math.atan(d2 / d);
        }
        if (d < 0.0 && d2 >= 0.0) {
            return Math.PI - Math.atan(-d2 / d);
        }
        if (d < 0.0 && d2 < 0.0) {
            return Math.PI + Math.atan(d2 / d);
        }
        if (d >= 0.0 && d2 < 0.0) {
            return Math.PI * 2 - Math.atan(-d2 / d);
        }
        return 0.0;
    }

    public Map<SURFInterestPoint, SURFInterestPoint> getMatchingPoints(Surf surf, boolean bl) {
        System.out.println("Finding matching points..");
        HashMap<SURFInterestPoint, SURFInterestPoint> hashMap = new HashMap<SURFInterestPoint, SURFInterestPoint>();
        List<SURFInterestPoint> list = bl ? this.getUprightInterestPoints() : this.getFreeOrientedInterestPoints();
        for (SURFInterestPoint sURFInterestPoint : list) {
            double d = 3.4028234663852886E38;
            double d2 = 3.4028234663852886E38;
            SURFInterestPoint sURFInterestPoint2 = null;
            for (SURFInterestPoint sURFInterestPoint3 : bl ? surf.getUprightInterestPoints() : surf.getFreeOrientedInterestPoints()) {
                double d3 = sURFInterestPoint.getDistance(sURFInterestPoint3);
                if (d3 < d) {
                    d2 = d;
                    d = d3;
                    sURFInterestPoint2 = sURFInterestPoint3;
                    continue;
                }
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
            if (!(d / d2 < 0.75)) continue;
            hashMap.put(sURFInterestPoint, sURFInterestPoint2);
        }
        System.out.println("Done finding matching points");
        return hashMap;
    }

    public String getStringRepresentation(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (SURFInterestPoint sURFInterestPoint : bl ? this.getFreeOrientedInterestPoints() : this.getUprightInterestPoints()) {
            float[] fArray = sURFInterestPoint.getDescriptor();
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                double d = fArray[i];
                stringBuffer.append(Double.doubleToLongBits(d) + ",");
            }
        }
        stringBuffer.substring(0, stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void setStringRepresentation(String string) {
    }

    private double gaussian(double d, double d2, double d3) {
        return 1.0 / (Math.PI * 2 * d3 * d3) * Math.exp(-(d * d + d2 * d2) / (2.0 * d3 * d3));
    }

    public boolean isEquivalentTo(Surf surf) {
        List<SURFInterestPoint> list = surf.getFreeOrientedInterestPoints();
        List<SURFInterestPoint> list2 = this.getFreeOrientedInterestPoints();
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            SURFInterestPoint sURFInterestPoint;
            SURFInterestPoint sURFInterestPoint2 = list.get(i);
            if (sURFInterestPoint2.isEquivalentTo(sURFInterestPoint = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void saveToFile(Surf surf, String string) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(surf);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Surf readFromFile(String string) {
        File file = new File(string);
        if (file != null && file.exists()) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                return (Surf)objectInputStream.readObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.mFreeOrientedPoints == null) {
            this.getFreeOrientedInterestPoints();
        }
        if (this.mUprightPoints == null) {
            this.getUprightInterestPoints();
        }
        objectOutputStream.defaultWriteObject();
    }

    public static void main(String[] stringArray) {
        try {
            BufferedImage bufferedImage = ImageIO.read(new File("H:\\workspace\\javaopensurf\\example\\lenna.png"));
            Surf surf = new Surf(bufferedImage);
            Surf.saveToFile(surf, "C:\\surf_test.bin");
            Surf surf2 = Surf.readFromFile("C:\\surf_test.bin");
            List<SURFInterestPoint> list = surf2.getFreeOrientedInterestPoints();
            System.out.println("Found " + list.size() + " interest points");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

