/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.SURFInterestPoint;
import com.stromberglabs.jopensurf.Surf;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SurfCompare
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int BASE_CIRCLE_DIAMETER = 8;
    private static final int TARGET_CIRCLE_DIAMETER = 4;
    private static final int UNMATCHED_CIRCLE_DIAMETER = 4;
    private BufferedImage image;
    private BufferedImage imageB;
    private float mImageAXScale = 0.0f;
    private float mImageAYScale = 0.0f;
    private float mImageBXScale = 0.0f;
    private float mImageBYScale = 0.0f;
    private int mImageAWidth = 0;
    private int mImageAHeight = 0;
    private int mImageBWidth = 0;
    private int mImageBHeight = 0;
    private Surf mSurfA;
    private Surf mSurfB;
    private Map<SURFInterestPoint, SURFInterestPoint> mAMatchingPoints;
    private Map<SURFInterestPoint, SURFInterestPoint> mBMatchingPoints;
    private boolean mUpright = false;

    public SurfCompare(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.image = bufferedImage;
        this.imageB = bufferedImage2;
        this.mSurfA = new Surf(bufferedImage);
        this.mSurfB = new Surf(bufferedImage2);
        this.mImageAXScale = (float)Math.min(bufferedImage.getWidth(), 800) / (float)bufferedImage.getWidth();
        this.mImageAYScale = Math.min((float)bufferedImage.getHeight(), 800.0f * (float)bufferedImage.getHeight() / (float)bufferedImage.getWidth()) / (float)bufferedImage.getHeight();
        this.mImageBXScale = (float)Math.min(bufferedImage2.getWidth(), 800) / (float)bufferedImage2.getWidth();
        this.mImageBYScale = Math.min((float)bufferedImage2.getHeight(), 800.0f * (float)bufferedImage2.getHeight() / (float)bufferedImage2.getWidth()) / (float)bufferedImage2.getHeight();
        this.mImageAWidth = (int)((float)bufferedImage.getWidth() * this.mImageAXScale);
        this.mImageAHeight = (int)((float)bufferedImage.getHeight() * this.mImageAYScale);
        this.mImageBWidth = (int)((float)bufferedImage2.getWidth() * this.mImageBXScale);
        this.mImageBHeight = (int)((float)bufferedImage.getHeight() * this.mImageBYScale);
        this.mAMatchingPoints = this.mSurfA.getMatchingPoints(this.mSurfB, this.mUpright);
        this.mBMatchingPoints = this.mSurfB.getMatchingPoints(this.mSurfA, this.mUpright);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this.mImageAWidth, this.mImageAHeight, this);
        graphics.drawImage(this.imageB, this.mImageAWidth, 0, this.mImageBWidth, this.mImageBHeight, Color.WHITE, this);
        if (this.mSurfA != null && this.mSurfB != null) {
            this.drawIpoints(graphics, this.mUpright ? this.mSurfA.getUprightInterestPoints() : this.mSurfA.getFreeOrientedInterestPoints(), 0, this.mImageAXScale, this.mImageAYScale);
            this.drawIpoints(graphics, this.mUpright ? this.mSurfB.getUprightInterestPoints() : this.mSurfB.getFreeOrientedInterestPoints(), this.mImageAWidth, this.mImageBXScale, this.mImageBYScale);
            this.drawConnectingPoints(graphics);
        }
    }

    private void drawIpoints(Graphics graphics, List<SURFInterestPoint> list, int n, float f, float f2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.RED);
        for (SURFInterestPoint sURFInterestPoint : list) {
            if (this.mAMatchingPoints.containsKey(sURFInterestPoint) || this.mBMatchingPoints.containsKey(sURFInterestPoint)) continue;
            int n2 = (int)(f * sURFInterestPoint.getX()) + n;
            int n3 = (int)(f2 * sURFInterestPoint.getY());
            graphics2D.drawOval(n2 - 2, n3 - 2, 4, 4);
        }
    }

    private void drawConnectingPoints(Graphics graphics) {
        int n;
        int n2;
        SURFInterestPoint sURFInterestPoint;
        int n3;
        int n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.GREEN);
        int n5 = this.mImageAWidth;
        for (SURFInterestPoint sURFInterestPoint2 : this.mAMatchingPoints.keySet()) {
            n4 = (int)(this.mImageAXScale * sURFInterestPoint2.getX());
            n3 = (int)(this.mImageAYScale * sURFInterestPoint2.getY());
            graphics2D.drawOval(n4 - 4, n3 - 4, 8, 8);
            sURFInterestPoint = this.mAMatchingPoints.get(sURFInterestPoint2);
            n2 = (int)(this.mImageBXScale * sURFInterestPoint.getX()) + n5;
            n = (int)(this.mImageBYScale * sURFInterestPoint.getY());
            graphics2D.drawOval(n2 - 2, n - 2, 4, 4);
            graphics2D.drawLine(n4, n3, n2, n);
        }
        graphics2D.setColor(Color.BLUE);
        for (SURFInterestPoint sURFInterestPoint2 : this.mBMatchingPoints.keySet()) {
            n4 = (int)(this.mImageBXScale * sURFInterestPoint2.getX()) + n5;
            n3 = (int)(this.mImageBYScale * sURFInterestPoint2.getY());
            graphics2D.drawOval(n4 - 4, n3 - 4, 8, 8);
            sURFInterestPoint = this.mBMatchingPoints.get(sURFInterestPoint2);
            n2 = (int)(this.mImageAXScale * sURFInterestPoint.getX());
            n = (int)(this.mImageAYScale * sURFInterestPoint.getY());
            graphics2D.drawOval(n2 - 2, n - 2, 4, 4);
            graphics2D.drawLine(n4, n3, n2, n);
        }
    }

    public void display() {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(new JScrollPane(this));
        jFrame.setSize(this.mImageAWidth + this.mImageBWidth, Math.max(this.mImageAHeight, this.mImageBHeight));
        jFrame.setLocation(0, 0);
        jFrame.setVisible(true);
    }

    public void matchesInfo() {
        Map<SURFInterestPoint, SURFInterestPoint> map = this.mSurfA.getMatchingPoints(this.mSurfB, true);
        Map<SURFInterestPoint, SURFInterestPoint> map2 = this.mSurfB.getMatchingPoints(this.mSurfA, true);
        System.out.println("There are: " + map.size() + " matching points of " + this.mSurfA.getUprightInterestPoints().size());
        System.out.println("There are: " + map2.size() + " matching points of " + this.mSurfB.getUprightInterestPoints().size());
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(stringArray[0]));
        BufferedImage bufferedImage2 = ImageIO.read(new File(stringArray[1]));
        SurfCompare surfCompare = new SurfCompare(bufferedImage, bufferedImage2);
        surfCompare.display();
    }
}

