/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirror;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class SummaryJUnitResultFormatter
implements JUnitResultFormatter,
JUnitTaskMirror.SummaryJUnitResultFormatterMirror {
    private NumberFormat nf = NumberFormat.getInstance();
    private OutputStream out;
    private boolean withOutAndErr = false;
    private String systemOutput = null;
    private String systemError = null;

    public void startTestSuite(JUnitTest suite) {
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("Running ");
        sb.append(suite.getName());
        sb.append(newLine);
        try {
            this.out.write(sb.toString().getBytes());
            this.out.flush();
        }
        catch (IOException ioex) {
            throw new BuildException("Unable to write summary output", (Throwable)ioex);
        }
    }

    public void startTest(Test t) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    public void setSystemError(String err) {
        this.systemError = err;
    }

    public void setWithOutAndErr(boolean value) {
        this.withOutAndErr = value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest suite) throws BuildException {
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("Tests run: ");
        sb.append(suite.runCount());
        sb.append(", Failures: ");
        sb.append(suite.failureCount());
        sb.append(", Errors: ");
        sb.append(suite.errorCount());
        sb.append(", Time elapsed: ");
        sb.append(this.nf.format((double)suite.getRunTime() / 1000.0));
        sb.append(" sec");
        sb.append(newLine);
        if (this.withOutAndErr) {
            if (this.systemOutput != null && this.systemOutput.length() > 0) {
                sb.append("Output:").append(newLine).append(this.systemOutput).append(newLine);
            }
            if (this.systemError != null && this.systemError.length() > 0) {
                sb.append("Error: ").append(newLine).append(this.systemError).append(newLine);
            }
        }
        try {
            try {
                this.out.write(sb.toString().getBytes());
                this.out.flush();
            }
            catch (IOException ioex) {
                throw new BuildException("Unable to write summary output", (Throwable)ioex);
            }
            Object var6_4 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.out == System.out) throw throwable;
            if (this.out == System.err) throw throwable;
            try {
                this.out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        this.out.close();
        return;
    }
}

