/*
 * Decompiled with CFR 0.152.
 */
package airspace;

import airspace.AirControlInterface;
import airspace.Plane;
import calculation.BuildTree;
import calculation.Tree;
import calculation.TreeNode;
import calculation.Vertex;
import general.Parameters;
import java.awt.Color;
import java.util.ArrayList;

public class AirControl
implements AirControlInterface {
    private static int planeCreateCounter = 0;
    private static int leafNumber = 0;
    private ArrayList<Plane> planes = new ArrayList();
    private int planeCreateInterval;
    private Parameters parameters;
    private ArrayList[] arcPoints;
    private BuildTree buildTree;
    private Tree tree;
    private int numberOfPlanes;
    private int arrivedPlanes;
    private int minSafeDistance;
    private final int createmultiplier;
    private final Color colorNormal;
    private final Color colorAlert;
    double interval;

    public AirControl(Parameters parameters, ArrayList[] arcPoints) {
        this.parameters = parameters;
        this.arcPoints = arcPoints;
        this.planeCreateInterval = Integer.valueOf(parameters.getParameterValue("PlaneCreateInterval"));
        this.buildTree = null;
        this.tree = null;
        this.numberOfPlanes = 0;
        this.arrivedPlanes = 0;
        this.minSafeDistance = Integer.valueOf(parameters.getParameterValue("MinSafeDistance"));
        this.createmultiplier = Integer.valueOf(parameters.getParameterValue("PlaneCreateMultiplier"));
        this.colorNormal = new Color(Integer.parseInt(parameters.getParameterValue("ColorNormal"), 16));
        this.colorAlert = new Color(Integer.parseInt(parameters.getParameterValue("ColorAlert"), 16));
        this.interval = Double.valueOf(parameters.getParameterValue("TimerInterval"));
    }

    @Override
    public final void update() {
        this.controlPlanes();
    }

    public void setBuildTree(BuildTree buildTree) {
        this.buildTree = buildTree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public boolean getAirportStatus() {
        boolean returnValue = false;
        if (this.tree != null && this.tree.getRoot() != null) {
            returnValue = true;
        }
        return returnValue;
    }

    public final BuildTree getBuildTree() {
        return this.buildTree;
    }

    @Override
    public final ArrayList<Plane> getPlanes() {
        return this.planes;
    }

    @Override
    public int getNumberOfPlanes() {
        return this.numberOfPlanes;
    }

    @Override
    public int getArrivedPlanes() {
        return this.arrivedPlanes;
    }

    public void testingAddPlane() {
        this.addPlane();
    }

    private void addPlane() {
        int multiplier;
        ArrayList<TreeNode> leaves = this.tree.getLeaves();
        int lsize = leaves.size();
        if (lsize < (multiplier = (int)(Math.random() * (double)this.createmultiplier) + 1)) {
            multiplier = lsize;
        }
        int i = 0;
        while (i < multiplier) {
            if (leafNumber >= lsize) {
                leafNumber = 0;
            }
            TreeNode startLeaf = leaves.get(leafNumber);
            ++leafNumber;
            Plane plane = new Plane(startLeaf, this.arcPoints, this.parameters, this.tree.getRoot());
            this.planes.add(plane);
            ++this.numberOfPlanes;
            ++i;
        }
    }

    private void controlPlanes() {
        this.tree = this.buildTree.getTree();
        if (this.tree.getRoot() == null) {
            int i = 0;
            while (i < this.getNumberOfPlanes()) {
                boolean atAirport = this.flyPlane(this.getPlanes().get(i));
                if (!atAirport) {
                    this.planes.remove(i);
                    --this.numberOfPlanes;
                    ++this.arrivedPlanes;
                }
                ++i;
            }
        } else {
            if (planeCreateCounter == this.planeCreateInterval || this.numberOfPlanes == 0) {
                this.addPlane();
                planeCreateCounter = 0;
            } else {
                ++planeCreateCounter;
            }
            boolean isChanged = this.buildTree.isChanged();
            int i = 0;
            while (i < this.getNumberOfPlanes()) {
                boolean atAirport;
                boolean onTree;
                if (isChanged && !(onTree = this.getPlanes().get(i).isOnArrivalTree(this.tree.getRoot(), this.getPlanes().get(i).getCurrentNode().hashCode()))) {
                    this.newPath(this.getPlanes().get(i));
                }
                if (!(atAirport = this.flyPlane(this.getPlanes().get(i)))) {
                    this.planes.remove(i);
                    --this.numberOfPlanes;
                    ++this.arrivedPlanes;
                }
                ++i;
            }
        }
        this.safetyZoneCheck();
    }

    public TreeNode testingclosestMergePoint(Plane plane, int arc) {
        return this.closestMergePoint(plane, arc);
    }

    private TreeNode closestMergePoint(Plane plane, int arc) {
        double distance = -1.0;
        double tmpDist = 0.0;
        TreeNode closest = null;
        if (this.tree.getRoot() == null) {
            return null;
        }
        if (arc == 0) {
            return this.tree.getRoot().getLeft().getLeft();
        }
        ArrayList[] mergePoints = this.sort(this.tree.getTreeMergePoints());
        int i = 0;
        while (i < mergePoints[arc].size()) {
            TreeNode tntmp = (TreeNode)mergePoints[arc].get(i);
            Vertex vtmp = tntmp.getVertex();
            tmpDist = vtmp.distanceTo(plane.getCurrentNode().getVertex());
            if (distance < 0.0 || tmpDist < distance) {
                distance = tmpDist;
                closest = (TreeNode)mergePoints[arc].get(i);
            }
            ++i;
        }
        return closest;
    }

    public TreeNode testingClosestTNToPlane(Plane plane) {
        return this.closestTNToPlane(plane);
    }

    private TreeNode closestTNToPlane(Plane plane) {
        double distance = -1.0;
        double tmpDist = 0.0;
        TreeNode closest = null;
        if (plane.getNextArc() == 0) {
            return this.tree.getRoot().getLeft();
        }
        int i = 0;
        while (i < this.tree.getTree().size()) {
            tmpDist = plane.distanceTo(this.tree.getTree().get(i).getVertex());
            if (distance < 0.0 || distance > tmpDist) {
                distance = tmpDist;
                closest = this.tree.getTree().get(i);
            }
            ++i;
        }
        int parents = 5;
        int j = 0;
        while (j < parents) {
            if (closest == this.tree.getRoot() || closest.getParent() == this.tree.getRoot()) break;
            closest = closest.getParent();
            ++j;
        }
        return closest;
    }

    public void testingSafetyZoneCheck() {
        this.safetyZoneCheck();
    }

    private void safetyZoneCheck() {
        Vertex arcp = (Vertex)this.arcPoints[0].get(0);
        if (!this.planes.isEmpty()) {
            int i = 0;
            while (i < this.planes.size()) {
                boolean clear = true;
                Plane plane = this.planes.get(i);
                double toApi = plane.distanceTo(arcp);
                plane.setDistToAirport(toApi);
                int j = 0;
                while (j < this.planes.size()) {
                    Plane other = this.planes.get(j);
                    double toApj = other.distanceTo(arcp);
                    other.setDistToAirport(toApj);
                    if (plane.distanceTo(other) < plane.getSafetyZone() && plane != other) {
                        if (toApi < toApj) {
                            other.setColor(this.colorAlert);
                            other.setSpeed(other.getSpeed() * 0.8);
                        } else {
                            plane.setColor(this.colorAlert);
                            plane.setSpeed(plane.getSpeed() * 0.8);
                            clear = false;
                        }
                    }
                    ++j;
                }
                if (clear) {
                    plane.setSpeed(plane.getSpeed() * 1.5);
                    plane.setColor(this.colorNormal);
                }
                ++i;
            }
        }
    }

    public boolean testingFlyPlane(Plane plane) {
        return this.flyPlane(plane);
    }

    private boolean flyPlane(Plane plane) {
        double nmiPerInterval = plane.getSpeed() / 3600.0 * (30000.0 / this.interval);
        double travelDistance = 1.852 * nmiPerInterval;
        double startLon = plane.getLon();
        double startLat = plane.getLat();
        boolean atAirport = plane.fly(travelDistance);
        double goalLon = plane.getLon();
        double goalLat = plane.getLat();
        plane.setDir(startLon, startLat, goalLon, goalLat);
        return atAirport;
    }

    public void testingNewPath(Plane plane) {
        this.newPath(plane);
    }

    private void newPath(Plane plane) {
        TreeNode closestMergePointTmp;
        Vertex planeLocation = plane.getCurrentNode().getVertex();
        TreeNode closestMergePoint = this.closestTNToPlane(plane);
        double planeToAp = plane.distanceTo(this.tree.getRoot().getVertex());
        if (planeToAp < closestMergePoint.getVertex().distanceTo(this.tree.getRoot().getVertex()) && (closestMergePointTmp = this.closestMergePoint(plane, plane.getNextArc())) != null && planeToAp < (closestMergePoint = closestMergePointTmp).getVertex().distanceTo(this.tree.getRoot().getVertex())) {
            closestMergePoint = this.tree.getRoot().getLeft();
        }
        if (closestMergePoint.getVertex().hashCode() != plane.getCurrentNode().getVertex().hashCode()) {
            if (!planeLocation.isAvailable()) {
                plane.clearPath();
                plane.setPath(closestMergePoint);
            } else {
                int t = 0;
                while (t < this.tree.getTree().size()) {
                    this.buildTree.setSafetyDistanceAirPlanes(this.tree.getTree().get(t).getVertex(), true, this.minSafeDistance);
                    ++t;
                }
                Tree tmpTree = new Tree();
                ArrayList<Vertex> mergeList = this.buildTree.aStar(plane.getCurrentNode().getVertex(), closestMergePoint.getVertex());
                ArrayList<TreeNode> tmpPath = tmpTree.treeNodePath(mergeList);
                if (tmpPath.size() > 1) {
                    plane.addToPath(tmpPath, closestMergePoint);
                } else {
                    plane.setPath(closestMergePoint);
                }
            }
        }
    }

    public ArrayList[] testingSorted(ArrayList<TreeNode> al) {
        return this.sort(al);
    }

    private ArrayList[] sort(ArrayList<TreeNode> al) {
        ArrayList[] sorted = new ArrayList[4];
        sorted[3] = new ArrayList();
        sorted[2] = new ArrayList();
        sorted[1] = new ArrayList();
        sorted[0] = new ArrayList();
        int i = 0;
        while (i < al.size()) {
            TreeNode mptmp = al.get(i);
            double distance = mptmp.getVertex().distanceTo(this.tree.getRoot().getVertex());
            if (distance < 115.0 && distance > 107.0) {
                sorted[3].add(mptmp);
            }
            if (distance < 60.0 && distance > 50.0) {
                sorted[2].add(mptmp);
            }
            if (distance < 22.0 && distance > 15.0) {
                sorted[1].add(mptmp);
            }
            if (distance < 1.0) {
                sorted[0].add(mptmp);
            }
            ++i;
        }
        return sorted;
    }
}

