/*
 * Decompiled with CFR 0.152.
 */
package airspace;

import calculation.TreeNode;
import calculation.Vertex;
import general.Parameters;
import java.awt.Color;
import java.util.ArrayList;

public class Plane
implements Comparable<Plane> {
    private double lat;
    private double lon;
    private double speed;
    private double safetyZone;
    private double distToAirport;
    private TreeNode currentNode;
    private int nextArc;
    private ArrayList<TreeNode> path;
    private int planeId;
    private Color color;
    private double direction;
    private TreeNode root;
    private double minspeed;
    private double maxspeed;
    private static int planeIdCounter = 1;

    public Plane(TreeNode startNode, ArrayList[] arcPoints, Parameters parameters, TreeNode root) {
        this.minspeed = Integer.valueOf(parameters.getParameterValue("PlaneMinimumSpeed")).intValue();
        this.maxspeed = Integer.valueOf(parameters.getParameterValue("PlaneMaximumSpeed")).intValue();
        this.checkSpeeds();
        this.currentNode = startNode;
        this.lat = this.currentNode.getVertex().getLat();
        this.lon = this.currentNode.getVertex().getLon();
        this.safetyZone = Integer.valueOf(parameters.getParameterValue("PlaneMinSafeDistance")).intValue();
        this.setSpeed(this.maxspeed);
        this.nextArc = arcPoints.length - 1;
        this.path = new ArrayList();
        this.setPath(this.currentNode);
        this.color = new Color(Integer.parseInt(parameters.getParameterValue("ColorNormal"), 16));
        this.distToAirport = 0.0;
        this.root = root;
        this.planeId = planeIdCounter++;
    }

    public boolean fly(double travelDistance) {
        double targLon;
        double targLat;
        double currLon;
        if (this.path.size() == 1) {
            return false;
        }
        double currLat = this.getLat();
        double distanceToTreeNode = this.distanceOfPoints(currLat, currLon = this.getLon(), targLat = this.path.get(1).getVertex().getLat(), targLon = this.path.get(1).getVertex().getLon());
        if (travelDistance < distanceToTreeNode) {
            double xDelta = targLon - currLon;
            double yDelta = targLat - currLat;
            this.setLon(currLon + travelDistance / distanceToTreeNode * xDelta);
            this.setLat(currLat + travelDistance / distanceToTreeNode * yDelta);
            this.checkArc();
        } else {
            this.setCurrentTreeNode(this.path.get(1));
            this.path.remove(0);
            double newTravel = travelDistance - distanceToTreeNode;
            this.fly(newTravel);
        }
        return true;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void clearPath() {
        this.path.clear();
    }

    public void setCurrentTreeNode(TreeNode node) {
        this.currentNode = node;
        this.setLat(node.getVertex().getLat());
        this.setLon(node.getVertex().getLon());
    }

    public void setLat(double latitude) {
        this.lat = latitude;
    }

    public void setLon(double longitude) {
        this.lon = longitude;
    }

    public boolean isOnArrivalTree(TreeNode node, int hashCode) {
        TreeNode left = node.getLeft();
        TreeNode right = node.getRight();
        if (node.hashCode() == hashCode) {
            return true;
        }
        boolean btmp = false;
        if (left != null && !btmp) {
            btmp = this.isOnArrivalTree(left, hashCode);
        }
        if (right != null && !btmp) {
            btmp = this.isOnArrivalTree(right, hashCode);
        }
        return btmp;
    }

    public void addToPath(ArrayList<TreeNode> pathToAdd, TreeNode joinPoint) {
        this.path.clear();
        this.setPath(pathToAdd.get(0));
        if (joinPoint.getParent() != null) {
            this.setPath(joinPoint.getParent());
        }
        this.setCurrentTreeNode(this.getPath().get(0));
    }

    public void setPath(TreeNode currentNode) {
        if (currentNode != null) {
            this.path.add(currentNode);
            if (currentNode.getParent() != null) {
                this.setPath(currentNode.getParent());
            }
        }
    }

    public void setSpeed(double speed) {
        this.speed = speed <= this.minspeed ? this.minspeed : (speed > this.maxspeed ? this.maxspeed : speed);
    }

    public void setDistToAirport(double dist) {
        this.distToAirport = dist;
    }

    public void setDir(double startLon, double startLat, double goalLon, double goalLat) {
        double xDelta = goalLon - startLon;
        double yDelta = goalLat - startLat;
        if (xDelta == 0.0) {
            if (yDelta == 0.0) {
                this.direction = 999.99;
                return;
            }
            xDelta = 1.0E-5;
        }
        double tan = yDelta / xDelta;
        double temp = Math.toDegrees(Math.atan(tan));
        if (xDelta > 0.0 && yDelta < 0.0) {
            temp += 360.0;
        } else if (xDelta < 0.0 && yDelta <= 0.0) {
            temp += 180.0;
        } else if (xDelta < 0.0 && yDelta > 0.0) {
            temp += 180.0;
        }
        this.direction = temp;
    }

    public double getDistToAirport() {
        return this.distToAirport;
    }

    public double getDir() {
        return this.direction;
    }

    public final Color getColor() {
        return this.color;
    }

    public final TreeNode getCurrentNode() {
        return this.currentNode;
    }

    public final int getId() {
        return this.planeId;
    }

    public final double getLat() {
        return this.lat;
    }

    public final double getLon() {
        return this.lon;
    }

    public final ArrayList<TreeNode> getPath() {
        return this.path;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final double getSafetyZone() {
        return this.safetyZone;
    }

    public final int getNextArc() {
        return this.nextArc;
    }

    public final String toString() {
        String a = "Plane: " + this.planeId + ". Location: (" + (float)this.lon + ", " + (float)this.lat + ")";
        return a;
    }

    public double distanceOfPoints(double currLat, double currLon, double targLat, double targLon) {
        double x = targLat - currLat;
        double y = targLon - currLon;
        double a = Math.sqrt(x * x + y * y);
        return a;
    }

    public double distanceTo(Plane other) {
        double x = other.lat - this.lat;
        double y = other.lon - this.lon;
        double a = Math.sqrt(x * x + y * y);
        return a;
    }

    public double distanceTo(double targlat, double targlon) {
        double x = targlat - this.lat;
        double y = targlon - this.lon;
        double a = Math.sqrt(x * x + y * y);
        return a;
    }

    public double distanceTo(Vertex other) {
        double x = other.getLat() - this.lat;
        double y = other.getLon() - this.lon;
        double a = Math.sqrt(x * x + y * y);
        return a;
    }

    @Override
    public final int compareTo(Plane other) {
        if (this.distToAirport < other.distToAirport) {
            return -1;
        }
        if (this.distToAirport > other.distToAirport) {
            return 1;
        }
        return 0;
    }

    public void testingCheckArc() {
        this.checkArc();
    }

    private void checkArc() {
        double distance = this.distanceTo(this.root.getVertex());
        if (this.nextArc > 0) {
            if (this.getNextArc() == 3 && distance < 133.0) {
                this.nextArc = 2;
            }
            if (this.getNextArc() == 2 && distance < 65.0) {
                this.nextArc = 1;
            }
            if (this.getNextArc() == 1 && distance < 22.0) {
                this.nextArc = 0;
            }
        }
    }

    public void testingCheckSpeeds() {
        this.checkSpeeds();
    }

    private void checkSpeeds() {
        if (this.minspeed < 1.0) {
            this.minspeed = 1.0;
        }
        if (this.maxspeed < this.minspeed) {
            this.maxspeed = this.minspeed + 1.0;
        }
    }
}

