/*
 * Decompiled with CFR 0.152.
 */
package calculation;

import calculation.Graph;
import calculation.Tree;
import calculation.TreeNode;
import calculation.Vertex;
import general.DataCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;

public class BuildTree {
    private Graph graph = null;
    private Tree arrivalTree = null;
    private DataCollection dataCollection;
    private int safetyDistance;
    private boolean flagArrivalTreeUpdated;
    private boolean asked;
    private int pathCounter;
    private int finalPathCount;
    private ArrayList<Vertex> mergePoints;

    public BuildTree(DataCollection dataCollection) {
        this.dataCollection = dataCollection;
        this.mergePoints = new ArrayList();
        if (dataCollection != null && dataCollection.getParameterClass() != null) {
            String safetyDistanceString = this.dataCollection.getParameterClass().getParameterValue("MinSafeDistance");
            this.safetyDistance = Integer.valueOf(safetyDistanceString);
        }
    }

    public BuildTree() {
        this.safetyDistance = 3;
        this.mergePoints = new ArrayList();
    }

    public void setNewTree(Tree tree) {
        this.flagArrivalTreeUpdated = true;
        this.asked = false;
        this.arrivalTree = tree;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public int getPathCounter() {
        return this.pathCounter;
    }

    public int getfinalPathCount() {
        return this.finalPathCount;
    }

    public void getTreeRecursion(Vertex startNode, ArrayList<Vertex> endNodes) {
        this.treeRecursion(startNode, endNodes);
    }

    public void getSetSlidingSafetyDistance(Vertex startNode, boolean sliding, boolean availability) {
        this.setSlidingSafetyDistance(startNode, sliding, availability);
    }

    public ArrayList<Vertex> getCalculatePath(Vertex startNode, ArrayList<Vertex> endNodes) {
        return this.calculatePath(startNode, endNodes);
    }

    public void getSetSafetyDistance(Vertex vertex, boolean availability, int distance, boolean set) {
        this.setSafetyDistance(vertex, availability, distance, set);
    }

    public int getTestSide(ArrayList<Vertex> path, ArrayList<Vertex> endNodes) {
        return this.testSide(path, endNodes);
    }

    public ArrayList<Vertex> getHalfTable(ArrayList<Vertex> endNodes, boolean side) {
        return this.halfTable(endNodes, side);
    }

    public boolean update(Graph graph) {
        this.graph = graph;
        this.flagArrivalTreeUpdated = false;
        if (this.arrivalTree == null || this.checkTree() || this.arrivalTree.getTree().isEmpty()) {
            this.flagArrivalTreeUpdated = true;
            this.asked = false;
            this.calculate();
        }
        return true;
    }

    public Tree getTree() {
        return this.arrivalTree;
    }

    public boolean isChanged() {
        if (this.asked) {
            return false;
        }
        this.asked = true;
        return this.flagArrivalTreeUpdated;
    }

    public void calculate() {
        this.arrivalTree = new Tree();
        this.pathCounter = 0;
        this.finalPathCount = 0;
        this.mergePoints.clear();
        Vertex startNode = this.graph.getAirport();
        this.mergePoints.add(startNode);
        ArrayList<Vertex> endNodes = this.graph.getOuterArc();
        this.treeRecursion(startNode, endNodes);
        this.arrivalTree.setTreeMergePoints(this.mergePoints);
    }

    private boolean checkTree() {
        boolean reCalculateArrivalTree = false;
        ArrayList<TreeNode> tree = this.arrivalTree.getTree();
        int i = 0;
        while (i < tree.size() - 1) {
            if (tree.get(i).getVertex().getStorm() || tree.get(i).getVertex().getStormSafety()) {
                reCalculateArrivalTree = true;
                break;
            }
            ++i;
        }
        return reCalculateArrivalTree;
    }

    public void treeRecursion(Vertex parStartNode, ArrayList<Vertex> endNodeTable) {
        ArrayList<Vertex> endNodes = endNodeTable;
        ArrayList<Vertex> parEndNodes = new ArrayList();
        Vertex startNode = parStartNode;
        ArrayList<Vertex> queue = new ArrayList<Vertex>();
        int side = 3;
        if (!this.arrivalTree.getTree().isEmpty()) {
            this.setSlidingSafetyDistance(startNode, false, true);
            this.setSlidingSafetyDistance(startNode, true, false);
            this.setSafetyDistance(startNode, true, 1, false);
        }
        ArrayList<Vertex> path = this.calculatePath(startNode, endNodes);
        this.setSlidingSafetyDistance(startNode, false, false);
        ++this.pathCounter;
        ++this.finalPathCount;
        if (path != null && !path.isEmpty()) {
            int j = 0;
            while (j < this.graph.getArcPoints().length) {
                int k = 0;
                while (k < path.size()) {
                    if (!this.graph.getArcPoints()[j].contains(path.get(0)) && this.graph.getArcPoints()[j].contains(path.get(k)) && !this.graph.getOuterArc().contains(path.get(k))) {
                        queue.add(path.get(k));
                        ++j;
                    }
                    ++k;
                }
                ++j;
            }
            this.arrivalTree.addToTree(path);
            int i = 1;
            while (i < path.size()) {
                this.setSafetyDistance(path.get(i), false, this.safetyDistance, true);
                ++i;
            }
            while (!queue.isEmpty()) {
                side = this.testSide(path, endNodes);
                if (side == 0) {
                    parEndNodes = this.halfTable(endNodes, false);
                    endNodes = this.halfTable(endNodes, true);
                } else if (side == 1) {
                    parEndNodes = this.halfTable(endNodes, true);
                    endNodes = this.halfTable(endNodes, false);
                } else if (side == 3) {
                    parEndNodes = null;
                    endNodes = null;
                }
                parStartNode = (Vertex)queue.get(0);
                this.mergePoints.add(parStartNode);
                queue.remove(0);
                if (parEndNodes != null) {
                    this.treeRecursion(parStartNode, parEndNodes);
                } else {
                    --this.pathCounter;
                }
                --this.pathCounter;
            }
        }
    }

    private void setSlidingSafetyDistance(Vertex startNode, boolean sliding, boolean availability) {
        Vertex nodeNow = startNode;
        int slidingInterval = this.safetyDistance;
        int i = 1;
        while (i < this.safetyDistance + 1) {
            int j = 0;
            while (j < slidingInterval) {
                if (sliding) {
                    this.setSafetyDistance(nodeNow, availability, i, false);
                } else {
                    this.setSafetyDistance(nodeNow, availability, this.safetyDistance, false);
                }
                if (this.arrivalTree.getVertexLeaves().contains(nodeNow) || this.arrivalTree.getVertexTree().size() <= this.arrivalTree.getVertexTree().indexOf(nodeNow) + 1) {
                    return;
                }
                nodeNow = this.arrivalTree.getVertexTree().get(this.arrivalTree.getVertexTree().indexOf(nodeNow) + 1);
                ++j;
            }
            slidingInterval += this.safetyDistance;
            ++i;
        }
    }

    private ArrayList<Vertex> calculatePath(Vertex startNode, ArrayList<Vertex> endNodes) {
        ArrayList<Vertex> shortestPath = new ArrayList<Vertex>();
        ArrayList<Vertex> pathNow = new ArrayList();
        double shortestLength = 0.0;
        double pathNowLength = 0.0;
        int i = 0;
        while (i < endNodes.size()) {
            if (endNodes.get(i).isAvailable()) {
                pathNow = this.aStar(startNode, endNodes.get(i));
                pathNowLength = this.pathLength(pathNow);
                if (i == 0) {
                    shortestLength = pathNowLength;
                    shortestPath = pathNow;
                } else if (pathNowLength < shortestLength) {
                    shortestPath = pathNow;
                    shortestLength = pathNowLength;
                }
            }
            ++i;
        }
        return shortestPath;
    }

    private void setSafetyDistance(Vertex vertex, boolean availability, int distance, boolean set) {
        int j = 0;
        while (j < 8) {
            Vertex parAdj = vertex.getAdjacent(j) != null ? vertex.getAdjacent(j) : null;
            if (parAdj != null) {
                if (!parAdj.getStorm() && !parAdj.getStormSafety()) {
                    if (set) {
                        if (parAdj.getPathSafety() == 0) {
                            parAdj.setPathSafety(this.finalPathCount);
                            parAdj.setAvailable(availability);
                        }
                    } else if (parAdj.getPathSafety() == this.pathCounter || parAdj.getPathSafety() == 6) {
                        parAdj.setAvailable(availability);
                    }
                }
                if (distance > 1) {
                    this.setSafetyDistance(parAdj, availability, distance - 1, set);
                }
            }
            ++j;
        }
    }

    public void setSafetyDistanceAirPlanes(Vertex vertex, boolean availability, int distance) {
        int j = 0;
        while (j < 8) {
            Vertex parAdj = vertex.getAdjacent(j) != null ? vertex.getAdjacent(j) : null;
            if (parAdj != null) {
                if (!parAdj.getStorm() && !parAdj.getStormSafety()) {
                    parAdj.setAvailable(availability);
                }
                if (distance > 1) {
                    this.setSafetyDistanceAirPlanes(parAdj, availability, distance - 1);
                }
            }
            ++j;
        }
    }

    private int testSide(ArrayList<Vertex> path, ArrayList<Vertex> endNodes) {
        if (endNodes == null) {
            return 3;
        }
        if (endNodes.size() == 0 || endNodes.size() == 1) {
            return 3;
        }
        int last = path.size() - 1;
        int halfTableSize = endNodes.size() / 2;
        int i = 0;
        while (i < halfTableSize) {
            if (endNodes.get(i).equals(path.get(last))) {
                return 0;
            }
            ++i;
        }
        i = halfTableSize;
        while (i < endNodes.size()) {
            if (endNodes.get(i).equals(path.get(last))) {
                return 1;
            }
            ++i;
        }
        return 2;
    }

    private ArrayList<Vertex> halfTable(ArrayList<Vertex> endNodes, boolean side) {
        ArrayList<Vertex> halfTable = new ArrayList<Vertex>();
        int halfSize = endNodes.size() / 2;
        int pairless = endNodes.size() - halfSize - halfSize;
        if (side) {
            int i = 0;
            while (i < halfSize) {
                halfTable.add(endNodes.get(i));
                ++i;
            }
        } else if (pairless == 1) {
            int i = 0;
            while (i < halfSize + 1) {
                halfTable.add(endNodes.get(halfSize + i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < halfSize) {
                halfTable.add(endNodes.get(halfSize + i));
                ++i;
            }
        }
        return halfTable;
    }

    public ArrayList<Vertex> aStar(Vertex start, Vertex goal) {
        if (start == null || goal == null) {
            throw new IllegalArgumentException("Null");
        }
        PriorityQueue<Vertex> openSet = new PriorityQueue<Vertex>();
        ArrayList<Vertex> closedSet = new ArrayList<Vertex>((int)start.distanceTo(goal));
        Vertex current = start;
        current.setHCost(goal);
        openSet.add(current);
        current.setState(1);
        Vertex dirStart = start;
        Vertex bestDirVertex = goal;
        double bestDirValue = 10.0;
        double rightDir = dirStart.calculateDir(goal);
        while (!openSet.isEmpty()) {
            current = (Vertex)openSet.poll();
            if (current.getBestDir() != 1) {
                dirStart = current;
                rightDir = dirStart.calculateDir(goal);
            }
            closedSet.add(current);
            current.setState(2);
            if (current == goal) {
                return this.resultPath(start, current, openSet, closedSet);
            }
            Vertex[] adjacents = current.getAdjacents();
            int i = 0;
            while (i < adjacents.length) {
                double tempDirValue;
                Vertex neighbour = adjacents[i];
                if (neighbour.isAvailable() && neighbour.getState() != 2) {
                    if (neighbour.getState() != 1) {
                        neighbour.setGCost(current.getGCost() + (i % 2 == 0 ? 1.0 : 1.4142));
                        neighbour.setHCost(goal);
                        neighbour.setDistCost(goal);
                        openSet.add(neighbour);
                        neighbour.setState(1);
                        neighbour.setParent(current);
                    } else {
                        double possibleNewGCost = current.getGCost() + (i % 2 == 0 ? 1.0 : 1.4142);
                        if (possibleNewGCost < neighbour.getGCost()) {
                            openSet.remove(neighbour);
                            neighbour.setGCost(possibleNewGCost);
                            neighbour.setParent(current);
                            openSet.add(neighbour);
                        }
                    }
                }
                if ((tempDirValue = neighbour.calculateDirCost(dirStart, rightDir)) < bestDirValue && neighbour.distanceTo(goal) < current.distanceTo(goal)) {
                    bestDirValue = tempDirValue;
                    bestDirVertex = neighbour;
                }
                ++i;
            }
            bestDirVertex.setBestDir(true);
            if (openSet.remove(bestDirVertex)) {
                openSet.add(bestDirVertex);
            }
            bestDirVertex = goal;
            bestDirValue = 10.0;
        }
        this.resetVertices(openSet, closedSet);
        return null;
    }

    private ArrayList<Vertex> resultPath(Vertex start, Vertex goal, PriorityQueue<Vertex> openSet, ArrayList<Vertex> closedSet) {
        Vertex current = goal;
        ArrayList<Vertex> reversePath = new ArrayList<Vertex>();
        ArrayList<Vertex> path = new ArrayList<Vertex>();
        while (current != start) {
            reversePath.add(current);
            current = current.getParent();
        }
        reversePath.add(current);
        path.ensureCapacity(reversePath.size());
        int i = reversePath.size() - 1;
        while (i >= 0) {
            path.add((Vertex)reversePath.get(i));
            --i;
        }
        this.resetVertices(openSet, closedSet);
        return path;
    }

    private void resetVertices(PriorityQueue<Vertex> openSet, ArrayList<Vertex> closedSet) {
        Iterator<Vertex> iter = openSet.iterator();
        while (iter.hasNext()) {
            iter.next().reset();
        }
        iter = closedSet.iterator();
        while (iter.hasNext()) {
            iter.next().reset();
        }
    }

    public double pathLength(ArrayList<Vertex> path) {
        double result = 0.0;
        if (path != null) {
            int i = 0;
            while (i < path.size() - 1) {
                result += path.get(i).distanceTo(path.get(i + 1));
                ++i;
            }
        }
        return result;
    }
}

