/*
 * Decompiled with CFR 0.152.
 */
package calculation;

import airspace.AirControl;
import calculation.BuildTree;
import calculation.CalculationInterface;
import calculation.Graph;
import filecontroller.FileController;
import general.DataCollection;
import general.Parameters;

public class CalculationControl
implements CalculationInterface {
    private AirControl airControl;
    private DataCollection dataCollection;
    private Parameters parameters;
    private FileController fileController;
    private boolean flagSystemTimer = true;
    private Graph graph;
    private BuildTree buildTree;
    private int internalClock;
    private int updateIntervalMap;
    private int updateIntervalAirspace;
    private int updateIntervalGraphics;
    private int timerUpdateMap;
    private int timerUpdateAirSpace;
    private int timerUpdateGraphics;
    private boolean testMode;

    public CalculationControl(DataCollection dataCollection) {
        if (dataCollection == null) {
            return;
        }
        this.dataCollection = dataCollection;
        this.parameters = this.dataCollection.getParameterClass();
        this.startDelay();
        this.updateIntervalMap = Integer.valueOf(this.parameters.getParameterValue("UpdateIntervalOfMap"));
        this.updateIntervalAirspace = Integer.valueOf(this.parameters.getParameterValue("UpdateIntervalOfAirspace"));
        this.updateIntervalGraphics = Integer.valueOf(this.parameters.getParameterValue("UpdateIntervalOfGraphics"));
        this.timerUpdateMap = this.updateIntervalMap;
        this.timerUpdateAirSpace = this.updateIntervalAirspace;
        this.timerUpdateGraphics = this.updateIntervalGraphics;
        this.fileController = new FileController(dataCollection.getParameterClass());
        if (!this.fileController.getStatus() && this.dataCollection.getGraphicsClass() != null) {
            this.dataCollection.getGraphicsClass().showErrorMessage(this.fileController.getErrorMessage(), true);
        }
        this.graph = new Graph(this.dataCollection, Integer.valueOf(this.parameters.getParameterValue("GraphWidth")), Integer.valueOf(this.parameters.getParameterValue("GraphHeight")));
        this.dataCollection.setArcPoints(this.graph.getArcPoints());
        this.airControl = new AirControl(this.dataCollection.getParameterClass(), this.dataCollection.getArcPoints());
        this.dataCollection.setAirControlClass(this.airControl);
        this.buildTree = new BuildTree(this.dataCollection);
    }

    @Override
    public boolean runTimer() {
        Runtime runtimeObject = Runtime.getRuntime();
        long timerInterval = Integer.valueOf(this.parameters.getParameterValue("TimerInterval")).intValue();
        int relativeTime = 30;
        while (this.flagSystemTimer) {
            long timeExtraction;
            long startTime;
            long refreshRate = startTime = System.currentTimeMillis();
            if (!this.dataCollection.getFlagPause()) {
                this.internalClock += relativeTime;
                this.update();
            }
            if ((timeExtraction = System.currentTimeMillis() - startTime) < timerInterval) {
                runtimeObject.gc();
                long sleepTime = timerInterval - timeExtraction;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    this.dataCollection.getGraphicsClass().showErrorMessage("Error: Timer interrupted exception", true);
                }
            }
            this.dataCollection.setRefreshRate(System.currentTimeMillis() - refreshRate);
            if (!this.testMode) continue;
            this.flagSystemTimer = false;
        }
        return true;
    }

    @Override
    public void setTimerFlag(boolean flag) {
        this.flagSystemTimer = flag;
    }

    private boolean update() {
        boolean succeed = true;
        ++this.timerUpdateMap;
        ++this.timerUpdateGraphics;
        ++this.timerUpdateAirSpace;
        this.dataCollection.setInternalClock(this.internalClock);
        switch (this.updateIntervalMap - this.timerUpdateMap) {
            case 4: {
                this.fileController.prepare();
            }
        }
        if (this.timerUpdateMap >= this.updateIntervalMap) {
            this.fileController.update();
            if (!this.fileController.getStatus()) {
                succeed = false;
                this.dataCollection.getGraphicsClass().showErrorMessage(this.fileController.getErrorMessage(), true);
            }
            this.dataCollection.setWeatherMapClass(this.fileController.getWeatherMap());
            this.graph.update();
            this.dataCollection.setGraph(this.graph.getGraph());
            this.buildTree.update(this.graph);
            this.dataCollection.setTreeClass(this.buildTree.getTree());
            this.dataCollection.setFlagMap(true);
            this.timerUpdateMap = 0;
        }
        if (this.timerUpdateAirSpace >= this.updateIntervalAirspace) {
            this.airControl.setBuildTree(this.buildTree);
            this.airControl.update();
            this.timerUpdateAirSpace = 0;
        }
        if (this.timerUpdateGraphics >= this.updateIntervalGraphics) {
            if (this.dataCollection.getGraphicsClass() != null) {
                this.dataCollection.getGraphicsClass().update();
            }
            this.timerUpdateGraphics = 0;
        }
        return succeed;
    }

    private void startDelay() {
        long delay = Integer.valueOf(this.parameters.getParameterValue("StartDelay")).intValue();
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                this.dataCollection.getGraphicsClass().showErrorMessage("Error: Start delay interrupted exception", true);
            }
        }
    }

    public void setTestMode() {
        this.testMode = true;
    }
}

