/*
 * Decompiled with CFR 0.152.
 */
package calculation;

import calculation.Vertex;
import filecontroller.WeatherMap;
import general.DataCollection;
import general.Parameters;
import java.util.ArrayList;

public class Graph {
    static final int STORM = 1;
    static final int MAP_WIDTH = 500;
    static final int MAP_HEIGHT = 500;
    static final int SCALE = 2;
    private int safety = 5;
    private int[][] mapMatrix;
    private WeatherMap map;
    private double cornerlat;
    private double cornerlon;
    private double start;
    private double end;
    private double startPointCount;
    private Vertex[][] graph;
    private ArrayList[] arcpoints;
    private Vertex nullVertex;
    private Vertex airportVertex;
    private DataCollection dataCollection;
    private Parameters param;

    public Graph(DataCollection data, int width, int height) {
        this.dataCollection = data;
        this.graph = this.createGraph(width, height);
        this.airportVertex = this.graph[width / 2][height / 2];
        if (data != null) {
            this.param = this.dataCollection.getParameterClass();
            this.safety = Integer.valueOf(this.param.getParameterValue("StormSafetyDistance"));
            this.start = Double.valueOf(this.param.getParameterValue("SectorStartDeg"));
            this.end = Double.valueOf(this.param.getParameterValue("SectorEndDeg"));
            this.startPointCount = Double.valueOf(this.param.getParameterValue("NumberOfStartPoints"));
            this.cornerlat = Double.valueOf(data.getParameterClass().getParameterValue("LocationCornerLatitude"));
            this.cornerlon = Double.valueOf(data.getParameterClass().getParameterValue("LocationCornerLongitude"));
            this.calculateArcPoints(this.start, this.end, this.startPointCount);
        }
    }

    public Graph(Vertex[][] gRaph) {
        this.graph = gRaph;
    }

    public void setArcPoints(ArrayList[] arcPoints) {
        this.arcpoints = arcPoints;
    }

    public Vertex[][] createGraph(int width, int height) {
        int y;
        int origoX = width / 2;
        int origoY = height / 2;
        double radius = Math.pow(width / 2, 2.0);
        Vertex[][] net = new Vertex[width][height];
        this.nullVertex = new Vertex(10000.0, 10000.0, 10000, 10000, false, null);
        int scale = 1;
        int x = 0;
        while (x < width) {
            y = 0;
            while (y < height) {
                if (Math.pow(x - origoX, 2.0) + Math.pow(y - origoY, 2.0) >= radius) {
                    net[x][y] = this.nullVertex;
                } else {
                    double lon = this.cornerlon + (double)(x * scale);
                    double lat = this.cornerlat + (double)(y * scale);
                    net[x][y] = new Vertex(lon, lat, x, y, true, this.nullVertex);
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < width) {
            y = 0;
            while (y < height) {
                Vertex vertex = net[x][y];
                if (vertex == null) {
                    System.out.println("Null vertex found.");
                    net = null;
                    break;
                }
                if (y != width - 1) {
                    vertex.setAdjacent(2, net[x][y + 1]);
                }
                if (x != 0 && y != width - 1) {
                    vertex.setAdjacent(3, net[x - 1][y + 1]);
                }
                if (x != 0) {
                    vertex.setAdjacent(4, net[x - 1][y]);
                }
                if (x != 0 && y != 0) {
                    vertex.setAdjacent(5, net[x - 1][y - 1]);
                }
                if (y != 0) {
                    vertex.setAdjacent(6, net[x][y - 1]);
                }
                if (x != height - 1 && y != 0) {
                    vertex.setAdjacent(7, net[x + 1][y - 1]);
                }
                if (x != height - 1) {
                    vertex.setAdjacent(0, net[x + 1][y]);
                }
                if (y != width - 1 && x != height - 1) {
                    vertex.setAdjacent(1, net[x + 1][y + 1]);
                }
                ++y;
            }
            ++x;
        }
        return net;
    }

    public boolean graphUpdate(int scale, int[][] matrix, Vertex[][] graph, int safety) {
        Vertex ap = this.getAirport();
        if (graph == null || matrix == null || ap == null) {
            return false;
        }
        int x = 0;
        while (x < graph.length) {
            int y = 0;
            while (y < graph[x].length) {
                if (this.checkSquare(scale, x * scale, y * scale, matrix)) {
                    graph[x][y].setAvailable(false);
                    graph[x][y].setStorm(true);
                    if (graph[x][y].distanceTo(ap) >= 18.52) {
                        this.setSafezone(false, graph[x][y], safety);
                    }
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public void setSafezone(boolean state, Vertex node, int width) {
        Vertex[] adj = node.getAdjacents();
        int i = 0;
        while (i < adj.length && width > 0) {
            if (adj[i].isAvailable() == !state) {
                adj[i].setAvailable(state);
                if (!state) {
                    adj[i].setStormSafety(true);
                } else {
                    adj[i].setStormSafety(false);
                }
                this.setSafezone(state, adj[i], width - 1);
            }
            ++i;
        }
    }

    public boolean checkSquare(int size, int x, int y, int[][] matrix) {
        int i = x;
        while (i < x + size && i < matrix.length) {
            int j = matrix.length - 1 - y;
            while (j > matrix.length - 1 - y - size && j >= 0) {
                if (matrix[i][j] >= 1) {
                    return true;
                }
                --j;
            }
            ++i;
        }
        return false;
    }

    public boolean resetGraph(Vertex[][] net) {
        if (net == null) {
            return false;
        }
        int x = 0;
        while (x < net.length) {
            int y = 0;
            while (y < net[x].length) {
                net[x][y].setAvailable(true);
                net[x][y].setStorm(false);
                net[x][y].setStormSafety(false);
                net[x][y].setPathSafety(0);
                ++y;
            }
            ++x;
        }
        return true;
    }

    public Vertex[][] getGraph() {
        return this.graph;
    }

    public Vertex getAirport() {
        return this.airportVertex;
    }

    public ArrayList<Vertex>[] getArcPoints() {
        return this.arcpoints;
    }

    public ArrayList<Vertex> getOuterArc() {
        int len = this.arcpoints.length - 1;
        return this.arcpoints[len];
    }

    public boolean update() {
        boolean success = true;
        if (this.dataCollection == null) {
            System.out.println("DataCollection class not found.");
            return false;
        }
        this.map = this.dataCollection.getWeatherMapClass();
        if (this.map == null) {
            System.out.println("Could not get WeatherMap.");
            return false;
        }
        this.mapMatrix = this.map.getMapMatrix();
        this.resetGraph(this.graph);
        if (!this.graphUpdate(2, this.mapMatrix, this.graph, this.safety)) {
            return false;
        }
        this.getAirport().setAvailable(true);
        this.setSafezone(true, this.getAirport(), 7);
        success = true;
        return success;
    }

    public void testCalculateArcPoints(double start, double end, double num) {
        this.calculateArcPoints(start, end, num);
    }

    public void calculateArcPoints(double start, double end, double startPointCount) {
        Vertex vertexTemp;
        int x;
        int y;
        double angle;
        double radius;
        ArrayList<Vertex> circle;
        double[] nmiToVertex = new double[]{18.52, 55.56, 111.12};
        int circleCount = 4;
        int currentCircle = 0;
        ArrayList[] circles = new ArrayList[circleCount];
        int originX = 250;
        int originY = 250;
        int xCheck = -1;
        int yCheck = -1;
        int i = 0;
        while (i < circleCount - 1) {
            circle = new ArrayList();
            radius = nmiToVertex[i];
            angle = 0.0;
            int j = 0;
            while (j < 60000) {
                angle = (double)j * 0.006;
                y = originY + (int)(radius * Math.sin(Math.toRadians(angle)));
                x = originX + (int)(radius * Math.cos(Math.toRadians(angle)));
                if (j == 0) {
                    xCheck = x;
                    yCheck = y;
                }
                if (xCheck != x || yCheck != y) {
                    if (xCheck - x != 0 && yCheck - y != 0) {
                        vertexTemp = x < originX ? this.graph[xCheck + 1][yCheck] : this.graph[xCheck - 1][yCheck];
                        circle.add(vertexTemp);
                    }
                    xCheck = x;
                    yCheck = y;
                    vertexTemp = this.graph[x][y];
                    circle.add(vertexTemp);
                }
                ++j;
            }
            circles[currentCircle] = circle;
            ++currentCircle;
            ++i;
        }
        circle = new ArrayList<Vertex>();
        radius = 249.99;
        int j = 0;
        while ((double)j < startPointCount) {
            angle = start + (double)j * Math.abs((end - start) / (startPointCount - 1.0));
            y = originY + (int)(radius * Math.sin(Math.toRadians(angle)));
            x = originX + (int)(radius * Math.cos(Math.toRadians(angle)));
            vertexTemp = this.graph[x][y];
            circle.add(vertexTemp);
            ++j;
        }
        circles[currentCircle] = circle;
        this.arcpoints = circles;
    }

    public void printgraph() {
        int parx = this.graph.length;
        int pary = this.graph.length;
        int x = parx;
        int y = pary;
        x = parx - 1;
        while (x >= 0) {
            System.out.print(String.valueOf(x) + "|");
            y = 0;
            while (y < pary) {
                if (this.graph[x][y].isAvailable()) {
                    System.out.print(" A |");
                } else if (this.graph[x][y] == this.nullVertex) {
                    System.out.print(" n |");
                } else {
                    System.out.print(" - |");
                }
                ++y;
            }
            System.out.print("\n");
            --x;
        }
        System.out.print("  ");
        y = 0;
        while (y < pary) {
            System.out.print(" " + y + "  ");
            ++y;
        }
        System.out.println();
    }
}

