/*
 * Decompiled with CFR 0.152.
 */
package calculation;

import calculation.TreeNode;
import calculation.Vertex;
import java.util.ArrayList;

public class Tree {
    private ArrayList<TreeNode> treeNodes = new ArrayList();
    private TreeNode root = null;
    private ArrayList<TreeNode> treeMergePoints = new ArrayList();
    private ArrayList<Vertex> vertexTree = new ArrayList();

    public TreeNode getRoot() {
        return this.root;
    }

    public ArrayList<TreeNode> getTreeMergePoints() {
        return this.treeMergePoints;
    }

    public void setTreeMergePoints(ArrayList<Vertex> mergePoints) {
        int i = 0;
        while (i < this.treeNodes.size()) {
            if (mergePoints.contains(this.treeNodes.get(i).getVertex())) {
                this.treeMergePoints.add(this.treeNodes.get(i));
            }
            ++i;
        }
    }

    public ArrayList<TreeNode> getTree() {
        return this.treeNodes;
    }

    public ArrayList<Vertex> getVertexTree() {
        return this.vertexTree;
    }

    public ArrayList<TreeNode> treeNodePath(ArrayList<Vertex> path) {
        ArrayList<TreeNode> treeNodeTable = new ArrayList<TreeNode>();
        Vertex nodeNow = null;
        if (path == null) {
            return treeNodeTable;
        }
        if (!path.isEmpty()) {
            treeNodeTable.add(new TreeNode(path.get(0)));
            int size = treeNodeTable.size();
            int i = 1;
            while (i < path.size()) {
                nodeNow = path.get(i);
                treeNodeTable.add(new TreeNode(nodeNow));
                treeNodeTable.get(++size - 2).setParent(treeNodeTable.get(size - 1));
                ++i;
            }
        }
        return treeNodeTable;
    }

    public boolean addToTree(ArrayList<Vertex> path) {
        Vertex nodeNow = null;
        if (this.treeNodes.isEmpty()) {
            this.treeNodes.add(new TreeNode(path.get(0)));
            this.vertexTree.add(path.get(0));
            this.treeNodes.add(new TreeNode(path.get(1)));
            this.vertexTree.add(path.get(1));
            this.root = this.treeNodes.get(0);
            this.treeNodes.get(0).setChild(this.treeNodes.get(1));
            this.treeNodes.get(1).setParent(this.treeNodes.get(0));
        } else {
            int treeNodesSize = this.treeNodes.size();
            int i = 0;
            while (i < treeNodesSize) {
                if (this.treeNodes.get(i).getVertex().equals(path.get(0))) {
                    this.treeNodes.add(new TreeNode(path.get(1)));
                    this.vertexTree.add(path.get(1));
                    int size = this.treeNodes.size();
                    this.treeNodes.get(size - 1).setParent(this.treeNodes.get(i));
                    this.treeNodes.get(i).setChild(this.treeNodes.get(size - 1));
                    break;
                }
                if (i == treeNodesSize - 1) {
                    return false;
                }
                ++i;
            }
        }
        int i = 2;
        while (i < path.size()) {
            nodeNow = path.get(i);
            this.treeNodes.add(new TreeNode(nodeNow));
            this.vertexTree.add(nodeNow);
            int size = this.treeNodes.size();
            this.treeNodes.get(size - 1).setParent(this.treeNodes.get(size - 2));
            this.treeNodes.get(size - 2).setChild(this.treeNodes.get(size - 1));
            ++i;
        }
        return true;
    }

    public ArrayList<TreeNode> getLeaves() {
        ArrayList<TreeNode> leaves = new ArrayList<TreeNode>();
        int i = 0;
        while (i < this.treeNodes.size()) {
            TreeNode now = this.treeNodes.get(i);
            if (now.getLeft() == null && now.getRight() == null) {
                leaves.add(this.treeNodes.get(i));
            }
            ++i;
        }
        return leaves;
    }

    public ArrayList<Vertex> getVertexLeaves() {
        ArrayList<Vertex> leaves = new ArrayList<Vertex>();
        ArrayList<TreeNode> treeLeaves = this.getLeaves();
        if (leaves != null) {
            int i = 0;
            while (i < treeLeaves.size()) {
                leaves.add(treeLeaves.get(i).getVertex());
                ++i;
            }
        }
        return leaves;
    }

    public void treeToString() {
        int i = 0;
        while (i < this.vertexTree.size()) {
            System.out.println("x: " + this.vertexTree.get(i).getX() + " & y: " + this.vertexTree.get(i).getY());
            ++i;
        }
    }
}

