/*
 * Decompiled with CFR 0.152.
 */
package calculation;

public class Vertex
implements Comparable<Vertex> {
    public static final int UNVISITED = 0;
    public static final int ON_OPEN_SET = 1;
    public static final int ON_CLOSED_SET = 2;
    public static final int NORTH = 0;
    public static final int NORTHEAST = 1;
    public static final int EAST = 2;
    public static final int SOUTHEAST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTHWEST = 5;
    public static final int WEST = 6;
    public static final int NORTHWEST = 7;
    private final double lat;
    private final double lon;
    private final int x;
    private final int y;
    private Vertex[] adj;
    private boolean available;
    private boolean storm;
    private int state;
    private double gCost;
    private double hCost;
    private Vertex parent;
    private double distCost;
    private int bestDir;
    private boolean stormSafety;
    private int pathSafety;

    public Vertex(double lon, double lat, int x, int y, boolean available, Vertex nullVertex) {
        this.lon = lon;
        this.lat = lat;
        this.x = x;
        this.y = y;
        this.available = available;
        this.adj = new Vertex[8];
        int i = 0;
        while (i < this.adj.length) {
            this.adj[i] = nullVertex;
            ++i;
        }
        this.state = 0;
        this.gCost = 0.0;
        this.hCost = 0.0;
        this.parent = null;
        this.distCost = 10000.0;
        this.bestDir = 0;
    }

    public void reset() {
        this.state = 0;
        this.gCost = 0.0;
        this.hCost = 0.0;
        this.parent = null;
        this.distCost = 10000.0;
        this.bestDir = 0;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean value) {
        this.available = value;
    }

    public void setState(int newState) {
        if (newState < 0 || newState > 2) {
            throw new IllegalArgumentException("State must be between 0 and 2.");
        }
        this.state = newState;
    }

    public int getState() {
        return this.state;
    }

    public void setStorm(boolean value) {
        this.storm = value;
    }

    public boolean getStorm() {
        return this.storm;
    }

    public void setParent(Vertex newParent) {
        this.parent = newParent;
    }

    public Vertex getParent() {
        return this.parent;
    }

    public boolean getStormSafety() {
        return this.stormSafety;
    }

    public void setStormSafety(boolean isStormSafety) {
        this.stormSafety = isStormSafety;
    }

    public int getPathSafety() {
        return this.pathSafety;
    }

    public void setPathSafety(int isPathSafety) {
        this.pathSafety = isPathSafety;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Vertex[] getAdjacents() {
        return this.adj;
    }

    public Vertex getAdjacent(int direction) {
        if (direction < 0 && direction > 7) {
            throw new IllegalArgumentException("Direction must be between 0 and 7.");
        }
        return this.adj[direction];
    }

    public int getAdjacentNumber(Vertex vertex) {
        int adjacentNumber = 10;
        int i = 0;
        while (i < this.adj.length) {
            if (vertex.equals(this.adj[i])) {
                adjacentNumber = i;
            }
            ++i;
        }
        return adjacentNumber;
    }

    public void setAdjacent(int direction, Vertex other) {
        if (direction < 0 && direction > 7) {
            throw new IllegalArgumentException("Direction must be between 0 and 7.");
        }
        this.adj[direction] = other;
    }

    public void setGCost(double newCost) {
        this.gCost = newCost;
    }

    public double getGCost() {
        return this.gCost;
    }

    public void setHCost(Vertex goal) {
        this.hCost = this.graphDistanceTo(goal);
    }

    public double getHCost() {
        return this.hCost;
    }

    public void setDistCost(Vertex goal) {
        this.distCost = this.distanceTo(goal);
    }

    public double getDistCost() {
        return this.distCost;
    }

    public void setBestDir(boolean value) {
        this.bestDir = value ? 1 : 0;
    }

    public int getBestDir() {
        return this.bestDir;
    }

    public double calculateDirCost(Vertex dirStart, double rightDir) {
        double dirIs = dirStart.calculateDir(this);
        double dif = Math.abs(rightDir - dirIs);
        if (dif > Math.PI) {
            dif = Math.PI * 2 - dif;
        }
        return dif;
    }

    public double calculateDir(Vertex goal) {
        double xDif = goal.getX() - this.x;
        double yDif = goal.getY() - this.y;
        if (xDif == 0.0) {
            xDif = 1.0E-5;
        }
        double tan = yDif / xDif;
        double temp = Math.atan(tan);
        if (xDif > 0.0 && yDif < 0.0) {
            temp += Math.PI * 2;
        } else if (xDif < 0.0 && yDif <= 0.0) {
            temp += Math.PI;
        } else if (xDif < 0.0 && yDif > 0.0) {
            temp += Math.PI;
        }
        return temp;
    }

    public double distanceTo(Vertex other) {
        return Math.sqrt(Math.pow(other.getX() - this.x, 2.0) + Math.pow(other.getY() - this.y, 2.0));
    }

    public double graphDistanceTo(Vertex other) {
        double yDif;
        double result = 10000.0;
        double xDif = Math.abs(other.getX() - this.x);
        result = xDif < (yDif = (double)Math.abs(other.getY() - this.y)) ? xDif * 1.4142 + (yDif - xDif) * 1.0 : yDif * 1.4142 + (xDif - yDif) * 1.0;
        return result;
    }

    @Override
    public final int compareTo(Vertex other) {
        double fCost = this.gCost + this.hCost;
        double otherFCost = other.getGCost() + other.getHCost();
        if (fCost < otherFCost && otherFCost - fCost > 0.001) {
            return -1;
        }
        if (fCost == otherFCost) {
            if (this.bestDir > other.bestDir) {
                return -1;
            }
            if (this.bestDir < other.bestDir) {
                return 1;
            }
            if (this.distCost < other.getDistCost()) {
                return -1;
            }
            if (this.distCost > other.getDistCost()) {
                return 1;
            }
            return 0;
        }
        if (fCost > otherFCost && fCost - otherFCost > 0.001) {
            return 1;
        }
        return -2;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

