/*
 * Decompiled with CFR 0.152.
 */
package filecontroller;

import filecontroller.FileInterface;
import filecontroller.ReadImageFile;
import filecontroller.ReadPGMImageFile;
import filecontroller.WeatherMap;
import general.Parameters;

public class FileController
implements FileInterface {
    private String errorMessage;
    private String mode;
    private Parameters parameters;
    private ReadImageFile readImageFile;
    private ReadPGMImageFile readPGMImageFile;
    private boolean status;
    private WeatherMap weatherMap;

    public FileController(Parameters parameters) {
        boolean succeed = true;
        this.parameters = parameters;
        this.weatherMap = new WeatherMap();
        if (this.parameters == null) {
            this.status = false;
            this.errorMessage = "Invalid Parameter -class.";
            return;
        }
        this.mode = this.parameters.getParameterValue("WeatherDataType");
        if (this.mode.equals("radar")) {
            this.readImageFile = new ReadImageFile(parameters);
            if (!this.readImageFile.getStatus()) {
                this.errorMessage = this.readImageFile.getErrorMessage();
                succeed = false;
            }
        } else if (this.mode.equals("PGM")) {
            this.readPGMImageFile = new ReadPGMImageFile(parameters);
            if (!this.readPGMImageFile.getStatus()) {
                this.errorMessage = this.readPGMImageFile.getErrorMessage();
                succeed = false;
            }
        }
        this.status = succeed;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean getStatus() {
        return this.status;
    }

    @Override
    public WeatherMap getWeatherMap() {
        return this.weatherMap;
    }

    @Override
    public boolean update() {
        boolean succeed = true;
        if (!this.status) {
            return false;
        }
        if (this.mode.equals("radar")) {
            if (this.readImageFile.getMap() == null) {
                this.prepare();
            }
            this.weatherMap.apply(this.readImageFile.getMap(), this.readImageFile.getMapMatrix());
        } else if (this.mode.equals("PGM")) {
            this.readPGMImageFile.update();
            if (!this.readPGMImageFile.getStatus()) {
                this.errorMessage = this.readPGMImageFile.getErrorMessage();
                this.status = false;
                succeed = false;
            }
            this.weatherMap.apply(this.readPGMImageFile.getMap(), this.readPGMImageFile.getMapMatrix());
        }
        return succeed;
    }

    @Override
    public boolean prepare() {
        boolean succeed = true;
        if (this.mode.equals("radar")) {
            this.readImageFile.update();
            if (!this.readImageFile.getStatus()) {
                this.status = false;
                succeed = false;
                this.errorMessage = this.readImageFile.getErrorMessage();
            }
        }
        return succeed;
    }
}

