/*
 * Decompiled with CFR 0.152.
 */
package filecontroller;

import general.Parameters;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

public class ReadImageFile {
    private Color colorOfCornerArea;
    private Color colorOfRadarArea;
    private int radarPics;
    private int currentRadarPic;
    private int[] radarImageSize;
    private int[] radarBins;
    private int[] colorPalette;
    private String dataDir;
    private double[] radarStartAzimuts;
    private double[] elevations;
    private int pictureWidth;
    private int pictureHeight;
    private int renderMapWidth;
    private int renderMapHeight;
    private int originX;
    private int originY;
    private int stormSensitivity;
    private int filterWhiteNoise;
    private BufferedImage offScreenImage;
    private BufferedImage mapImage;
    private int[][] mapMatrix;
    private Parameters parameters;
    private ArrayList<String> weatherFiles;
    private int weatherFilesPointer;
    private String errorMessage;
    private Boolean status;

    public ReadImageFile(Parameters parameters) {
        if (parameters == null) {
            this.errorMessage = "Invalid Parameter -class.";
            this.status = false;
            return;
        }
        this.parameters = parameters;
        this.status = true;
        this.weatherFilesPointer = 0;
        this.currentRadarPic = 0;
        this.radarPics = 0;
        this.radarImageSize = new int[2];
        this.radarBins = new int[10];
        this.pictureWidth = Integer.valueOf(this.parameters.getParameterValue("WeathermapWidth"));
        this.pictureHeight = Integer.valueOf(this.parameters.getParameterValue("WeathermapHeight"));
        this.renderMapWidth = Integer.valueOf(this.parameters.getParameterValue("WeathermapRenderWidth"));
        this.renderMapHeight = Integer.valueOf(this.parameters.getParameterValue("WeathermapRenderHeight"));
        this.stormSensitivity = Integer.valueOf(this.parameters.getParameterValue("DBZstormSensitivity"));
        this.dataDir = this.parameters.getParameterValue("DataDir");
        this.filterWhiteNoise = Integer.valueOf(this.parameters.getParameterValue("NoiseFilterSensitivity"));
        int tempValue = Integer.valueOf(this.parameters.getParameterValue("WeathermapCornerBackgroudcolor"));
        this.colorOfCornerArea = new Color(tempValue, tempValue, tempValue);
        tempValue = Integer.valueOf(this.parameters.getParameterValue("WeathermapRadarBackgroudcolor"));
        this.colorOfRadarArea = new Color(tempValue, tempValue, tempValue);
        this.originX = this.pictureWidth / 2;
        this.originY = this.pictureHeight / 2;
        this.colorPalette = this.getPrintColorPalette();
        this.offScreenImage = new BufferedImage(this.pictureWidth, this.pictureHeight, 2);
        this.weatherFiles = new ArrayList();
        if (!this.loadList(this.parameters.getParameterValue("WeatherDataFile"))) {
            this.status = false;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public BufferedImage getMap() {
        return this.mapImage;
    }

    public int[][] getMapMatrix() {
        return this.mapMatrix;
    }

    public boolean getStatus() {
        return this.status;
    }

    public boolean update() {
        boolean updateSucceed = this.loadPicture();
        if (updateSucceed) {
            updateSucceed = this.renderWeathermapToBufferedImage();
        } else {
            this.status = false;
        }
        return updateSucceed;
    }

    private boolean loadList(String filename) {
        int counter = 0;
        File loadFile = new File(filename);
        try {
            Scanner inputFile = new Scanner(loadFile);
            while (inputFile.hasNextLine()) {
                String line = inputFile.nextLine();
                if (line.length() > 0 && line.indexOf("#") < 0) {
                    this.weatherFiles.add(line);
                    ++this.radarPics;
                }
                ++counter;
            }
            inputFile.close();
        }
        catch (FileNotFoundException e) {
            this.errorMessage = "Error - file not found: " + filename;
            return false;
        }
        return true;
    }

    private boolean loadPicture() {
        int totalElevations = 0;
        int columCounter = 0;
        int rowCounter = 0;
        int x = 0;
        int y = 0;
        double curSectorCorrection = 0.0;
        double sectorCorrection = 0.1;
        double filelenghth = 0.0;
        this.mapMatrix = new int[this.pictureWidth][this.pictureHeight];
        int[][] temporaryMap = new int[this.pictureWidth][this.pictureHeight];
        y = 0;
        while (y < this.pictureHeight) {
            x = 0;
            while (x < this.pictureWidth) {
                this.mapMatrix[x][y] = 0;
                temporaryMap[x][y] = 0;
                ++x;
            }
            ++y;
        }
        String filename = this.getPictureName();
        try {
            while (filename != null) {
                int headerCount = 0;
                rowCounter = 0;
                int mapElevation = 0;
                String headeritem = "";
                BufferedInputStream readBuffer = new BufferedInputStream(new FileInputStream(new File(filename)));
                filelenghth = readBuffer.available();
                while (filelenghth > 0.0) {
                    int value = readBuffer.read();
                    filelenghth -= 1.0;
                    if (headerCount < 19) {
                        if (value != 10) {
                            headeritem = String.valueOf(headeritem) + (char)value;
                            continue;
                        }
                        this.recognizeHeaderLine(headeritem, ++headerCount);
                        headeritem = "";
                        continue;
                    }
                    if (columCounter < this.radarBins[mapElevation] - 1) {
                        ++columCounter;
                    } else {
                        columCounter = 0;
                        if (++rowCounter > 360) {
                            rowCounter = 0;
                            ++totalElevations;
                            if (++mapElevation >= this.radarBins.length) break;
                        }
                    }
                    int dBZ = (int)(0.5 * (double)value - 32.0);
                    if (value >= 250 || dBZ <= this.stormSensitivity) continue;
                    double r = Math.cos(this.elevations[mapElevation]) * (double)columCounter;
                    if (r < 0.0) {
                        r *= -1.0;
                    }
                    curSectorCorrection = 0.0;
                    int i = 0;
                    while (i < 10) {
                        curSectorCorrection = sectorCorrection * (double)i;
                        double angle = this.radarStartAzimuts[mapElevation] - 90.0 + (double)rowCounter + curSectorCorrection;
                        y = this.originY + (int)(r * Math.sin(Math.toRadians(angle)));
                        x = this.originX + (int)(r * Math.cos(Math.toRadians(angle)));
                        if (dBZ > temporaryMap[x][y] && x > 0 && x < this.pictureWidth && y > 0 && y < this.pictureHeight) {
                            temporaryMap[x][y] = dBZ;
                        }
                        ++i;
                    }
                }
                readBuffer.close();
                filename = this.getPictureName();
            }
        }
        catch (FileNotFoundException e) {
            this.status = false;
            this.errorMessage = "Error - file not found: " + filename;
            return false;
        }
        catch (IOException e) {
            this.status = false;
            this.errorMessage = "Error - IO Exception: " + filename;
            return false;
        }
        this.mapMatrix = this.noiseFilter(this.noiseFilter(temporaryMap));
        temporaryMap = null;
        return true;
    }

    private int[][] noiseFilter(int[][] temporaryMap) {
        int x;
        int[][] filterMap = new int[this.pictureWidth][this.pictureHeight];
        int y = 0;
        while (y < this.pictureHeight) {
            x = 0;
            while (x < this.pictureWidth) {
                filterMap[x][y] = 0;
                ++x;
            }
            ++y;
        }
        y = 1;
        while (y < this.pictureHeight - 1) {
            x = 1;
            while (x < this.pictureWidth - 1) {
                if (temporaryMap[x][y] > 0) {
                    int neighbours = 0;
                    if (temporaryMap[x - 1][y - 1] > 0) {
                        ++neighbours;
                    }
                    if (temporaryMap[x][y - 1] > 0) {
                        ++neighbours;
                    }
                    if (temporaryMap[x + 1][y - 1] > 0) {
                        ++neighbours;
                    }
                    if (temporaryMap[x - 1][y] > 0) {
                        ++neighbours;
                    }
                    if (temporaryMap[x + 1][y] > 0) {
                        ++neighbours;
                    }
                    if (temporaryMap[x - 1][y + 1] > 0) {
                        ++neighbours;
                    }
                    if (temporaryMap[x][y + 1] > 0) {
                        ++neighbours;
                    }
                    if (temporaryMap[x + 1][y + 1] > 0) {
                        ++neighbours;
                    }
                    if (neighbours >= this.filterWhiteNoise) {
                        filterMap[x][y] = temporaryMap[x][y];
                    }
                }
                ++x;
            }
            ++y;
        }
        return filterMap;
    }

    private boolean renderWeathermapToBufferedImage() {
        Graphics2D g2 = this.offScreenImage.createGraphics();
        g2.setColor(this.colorOfCornerArea);
        g2.fillRect(0, 0, this.pictureHeight, this.pictureWidth);
        g2.setColor(this.colorOfRadarArea);
        g2.fill(new Ellipse2D.Double(0.0, 0.0, this.pictureHeight, this.pictureWidth));
        int y = 0;
        while (y < this.pictureHeight) {
            int x = 0;
            while (x < this.pictureWidth) {
                int dBZ = this.mapMatrix[x][y];
                if (dBZ > 0) {
                    this.offScreenImage.setRGB(x, y, this.colorPalette[dBZ] + 1);
                }
                ++x;
            }
            ++y;
        }
        g2 = this.offScreenImage.createGraphics();
        g2.drawImage(this.offScreenImage.getScaledInstance(this.renderMapWidth, this.renderMapHeight, 4), 0, 0, null);
        this.mapImage = this.offScreenImage;
        this.offScreenImage.flush();
        return true;
    }

    private String getPictureName() {
        String[] choices = new String[]{"A", "B", "C", "D", "E"};
        String currentFile = "";
        if (this.currentRadarPic >= choices.length) {
            this.currentRadarPic = 0;
            ++this.weatherFilesPointer;
            return null;
        }
        if (this.weatherFilesPointer >= this.radarPics) {
            this.status = false;
            this.errorMessage = "No more weatherdata!";
            return null;
        }
        currentFile = this.weatherFiles.get(this.weatherFilesPointer);
        String imagefile = String.valueOf(this.dataDir) + currentFile + choices[this.currentRadarPic] + ".raw.pgm";
        if (!new File(imagefile).exists()) {
            if (this.currentRadarPic == 0) {
                this.status = false;
                this.errorMessage = "First Weather map not found: " + imagefile;
                return null;
            }
            this.currentRadarPic = 0;
            ++this.weatherFilesPointer;
            return null;
        }
        ++this.currentRadarPic;
        return imagefile;
    }

    private int[] getPrintColorPalette() {
        int[] palette = new int[255];
        int i = 0;
        while (i < palette.length) {
            int cr = 100 + i * 3;
            if (cr > 250) {
                cr = 250;
            }
            Color pal = new Color(cr, 40, 40);
            palette[i] = 1 * pal.getRGB();
            ++i;
        }
        return palette;
    }

    private boolean recognizeHeaderLine(String headerLine, int headerNumber) {
        String[] valueArray;
        if (headerLine.indexOf("=") != -1) {
            int start = headerLine.indexOf(61);
            int end = headerLine.length();
            String value = headerLine.substring(start + 1, end);
            valueArray = value.split(" ");
        } else {
            valueArray = headerLine.split(" ");
        }
        switch (headerNumber) {
            case 13: {
                this.elevations = new double[valueArray.length];
                int i = 0;
                while (i < valueArray.length) {
                    this.elevations[i] = Double.valueOf(valueArray[i]);
                    ++i;
                }
                break;
            }
            case 14: {
                this.radarBins = new int[valueArray.length];
                int i = 0;
                while (i < valueArray.length) {
                    this.radarBins[i] = Integer.valueOf(valueArray[i]);
                    ++i;
                }
                break;
            }
            case 16: {
                this.radarStartAzimuts = new double[valueArray.length];
                int i = 0;
                while (i < valueArray.length) {
                    this.radarStartAzimuts[i] = Double.valueOf(valueArray[i]);
                    ++i;
                }
                break;
            }
            case 18: {
                this.radarImageSize[0] = Integer.valueOf(valueArray[0]);
                this.radarImageSize[1] = Integer.valueOf(valueArray[1]);
                break;
            }
        }
        return true;
    }
}

