/*
 * Decompiled with CFR 0.152.
 */
package filecontroller;

import general.Parameters;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

public class ReadPGMImageFile {
    private Color colorOfCornerArea;
    private Color colorOfRadarArea;
    private int radarPics;
    private int[] radarImageSize;
    private int[] colorPalette;
    private String dataDir;
    private int pictureWidth;
    private int pictureHeight;
    private int renderMapWidth;
    private int renderMapHeight;
    private BufferedImage offScreenImage;
    private BufferedImage mapImage;
    private int[][] mapMatrix;
    private Parameters parameters;
    private ArrayList<String> weatherFiles;
    private int weatherFilesPointer;
    private String errorMessage;
    private Boolean status;

    public ReadPGMImageFile(Parameters parameters) {
        this.parameters = parameters;
        if (parameters == null) {
            this.status = false;
            this.errorMessage = "Invalid Parameter -class.";
            return;
        }
        this.status = true;
        this.radarPics = 0;
        this.weatherFilesPointer = 0;
        this.weatherFiles = new ArrayList();
        this.dataDir = this.parameters.getParameterValue("DataDir");
        this.pictureWidth = Integer.valueOf(this.parameters.getParameterValue("WeathermapWidth"));
        this.pictureHeight = Integer.valueOf(this.parameters.getParameterValue("WeathermapHeight"));
        this.renderMapWidth = 800;
        this.renderMapHeight = 800;
        this.radarImageSize = new int[2];
        this.colorPalette = this.getPrintColorPalette();
        int tempValue = Integer.valueOf(this.parameters.getParameterValue("WeathermapCornerBackgroudcolor"));
        this.colorOfCornerArea = new Color(tempValue, tempValue, tempValue);
        tempValue = Integer.valueOf(this.parameters.getParameterValue("WeathermapRadarBackgroudcolor"));
        this.colorOfRadarArea = new Color(tempValue, tempValue, tempValue);
        this.offScreenImage = new BufferedImage(this.pictureWidth, this.pictureHeight, 2);
        if (!this.loadList(this.parameters.getParameterValue("WeatherDataFile"))) {
            this.status = false;
        }
    }

    public BufferedImage getMap() {
        return this.mapImage;
    }

    public boolean getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int[][] getMapMatrix() {
        return this.mapMatrix;
    }

    public boolean update() {
        boolean updateSucceed = this.loadPicture();
        if (updateSucceed) {
            updateSucceed = this.renderWeathermapToBufferedImage();
        }
        return updateSucceed;
    }

    private boolean loadList(String filename) {
        int counter = 0;
        File loadFile = new File(filename);
        if (!loadFile.exists()) {
            this.errorMessage = "Error - file not found: " + filename;
            return false;
        }
        try {
            Scanner inputFile = new Scanner(loadFile);
            while (inputFile.hasNextLine()) {
                String line = inputFile.nextLine();
                if (line.indexOf("#") < 0) {
                    this.weatherFiles.add(line);
                    ++this.radarPics;
                }
                ++counter;
            }
            inputFile.close();
        }
        catch (FileNotFoundException e) {
            this.errorMessage = "Error - file not found: " + filename;
            return false;
        }
        return true;
    }

    private boolean loadPicture() {
        int[][] temporaryMap;
        block11: {
            int x;
            this.mapMatrix = new int[this.pictureWidth][this.pictureHeight];
            temporaryMap = new int[this.pictureWidth][this.pictureHeight];
            int y = 0;
            while (y < this.pictureHeight) {
                x = 0;
                while (x < this.pictureWidth) {
                    this.mapMatrix[x][y] = 0;
                    temporaryMap[x][y] = 0;
                    ++x;
                }
                ++y;
            }
            x = 0;
            y = 0;
            String filename = this.getPictureName();
            double filelenghth = 0.0;
            try {
                int headerCount = 0;
                String headeritem = "";
                if (new File(filename).exists()) {
                    BufferedInputStream lukupuskuri = new BufferedInputStream(new FileInputStream(new File(filename)));
                    filelenghth = lukupuskuri.available();
                    while (filelenghth > 0.0) {
                        filelenghth -= 1.0;
                        int value = lukupuskuri.read();
                        if (headerCount < 3) {
                            if (value != 10) {
                                headeritem = String.valueOf(headeritem) + (char)value;
                                continue;
                            }
                            this.recognizeHeaderLine(headeritem, ++headerCount);
                            headeritem = "";
                            continue;
                        }
                        if (value > 0) {
                            if (value == 255) {
                                value = 254;
                            }
                            temporaryMap[y][x] = value;
                        }
                        if (++y != this.pictureWidth) continue;
                        y = 0;
                        ++x;
                    }
                    break block11;
                }
                this.errorMessage = "Error - file not found: " + filename;
                this.status = false;
                return false;
            }
            catch (FileNotFoundException e) {
                this.errorMessage = "Error - file not found: " + filename;
                return false;
            }
            catch (IOException e) {
                this.errorMessage = "Error - IO Exception: " + filename;
                return false;
            }
        }
        this.mapMatrix = temporaryMap;
        return true;
    }

    private boolean renderWeathermapToBufferedImage() {
        Graphics2D g2 = this.offScreenImage.createGraphics();
        g2.setColor(this.colorOfCornerArea);
        g2.fillRect(0, 0, this.pictureHeight, this.pictureWidth);
        g2.setColor(this.colorOfRadarArea);
        g2.fill(new Ellipse2D.Double(0.0, 0.0, this.pictureHeight, this.pictureWidth));
        int y = 0;
        while (y < this.pictureHeight) {
            int x = 0;
            while (x < this.pictureWidth) {
                int dBZ = this.mapMatrix[x][y];
                if (dBZ > 0) {
                    this.offScreenImage.setRGB(x, y, this.colorPalette[dBZ] + 1);
                }
                ++x;
            }
            ++y;
        }
        g2 = this.offScreenImage.createGraphics();
        g2.drawImage(this.offScreenImage.getScaledInstance(this.renderMapWidth, this.renderMapHeight, 4), 0, 0, null);
        this.mapImage = this.offScreenImage;
        this.offScreenImage.flush();
        return true;
    }

    private String getPictureName() {
        String currentFile = "";
        currentFile = this.weatherFiles.get(this.weatherFilesPointer++);
        if (this.weatherFilesPointer >= this.radarPics) {
            this.weatherFilesPointer = 0;
        }
        String imagefile = String.valueOf(this.dataDir) + currentFile + ".pgm";
        return imagefile;
    }

    private int[] getPrintColorPalette() {
        int[] palette = new int[255];
        int bgColor = 50;
        Color pal = new Color(bgColor, bgColor, bgColor);
        palette[0] = pal.getRGB();
        int i = 1;
        while (i < palette.length) {
            int cr = i * 3;
            if (cr > bgColor) {
                cr = bgColor;
            }
            pal = new Color(100 + cr, 40, 40);
            palette[i] = 1 * pal.getRGB();
            ++i;
        }
        return palette;
    }

    private boolean recognizeHeaderLine(String headerLine, int headerNumber) {
        String[] valueArray = headerLine.split(" ");
        switch (headerNumber) {
            case 2: {
                this.radarImageSize[0] = Integer.valueOf(valueArray[0]);
                this.radarImageSize[1] = Integer.valueOf(valueArray[1]);
                break;
            }
        }
        return true;
    }
}

