/*
 * Decompiled with CFR 0.152.
 */
package general;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Parameter {
    ProgramVersion("ProgramVersion", "1.0"),
    ProgramDate("ProgramDate", "2008-12-12"),
    Title("Title", "Path Planning in Face of Uncertainty"),
    Demo("Demo", "0"),
    Debug("Debug", "0"),
    StartDelay("StartDelay", "300"),
    MediaDir("MediaDir", "data/"),
    JarFile("JarFile", "0"),
    LocationCornerLatitude("LocationCornerLatitude", "0"),
    LocationCornerLongitude("LocationCornerLongitude", "0"),
    TimerInterval("TimerInterval", "1000"),
    SectorStartDeg("SectorStartDeg", "45"),
    SectorEndDeg("SectorEndDeg", "135"),
    NumberOfStartPoints("NumberOfStartPoints", "8"),
    MinSafeDistance("MinSafeDistance", "4"),
    UpdateIntervalOfMap("UpdateIntervalOfMap", "10"),
    UpdateIntervalOfAirspace("UpdateIntervalOfAirspace", "1"),
    UpdateIntervalOfGraphics("UpdateIntervalOfGraphics", "1"),
    WeatherDataType("WeatherDataType", "radar"),
    WeatherDataFile("WeatherDataFile", "weatherset.dat"),
    WeathermapWidth("WeathermapWidth", "1000"),
    WeathermapHeight("WeathermapHeight", "1000"),
    WeathermapRenderWidth("WeathermapRenderWidth", "800"),
    WeathermapRenderHeight("WeathermapRenderHeight", "800"),
    WeathermapCornerBackgroudcolor("WeathermapCornerBackgroudcolor", "50"),
    WeathermapRadarBackgroudcolor("WeathermapRadarBackgroudcolor", "190"),
    DBZstormSensitivity("DBZstormSensitivity", "30"),
    NoiseFilterSensitivity("NoiseFilterSensitivity", "6"),
    DataDir("DataDir", "data/images/"),
    GraphWidth("GraphWidth", "500"),
    GraphHeight("GraphHeight", "500"),
    StormSafetyDistance("StormSafetyDistance", "5"),
    WindowWidth("WindowWidth", "1100"),
    WindowHeight("WindowHeight", "800"),
    RenderAirspace("RenderAirspace", "true"),
    RenderArrivalTree("RenderArrivalTree", "true"),
    RenderArcpoints("RenderArcPoints", "true"),
    RenderPlanePath("RenderPlanePath", "true"),
    RenderPlaneAsTriangle("RenderPlaneAsTriangle", "false"),
    GraphicsEngineArcpointsColor("GraphicsEngineArcpointsColor", "250"),
    GraphicsEngineArrivalTreeColor("GraphicsEngineArrivalTreeColor", "180"),
    PlaneCreateInterval("PlaneCreateInterval", "8"),
    PlaneMaximumSpeed("PlaneMaximumSpeed", "400"),
    PlaneMinimumSpeed("PlaneMinimumSpeed", "100"),
    PlaneMinSafeDistance("PlaneMinSafeDistance", "20"),
    PlaneCreateMultiplier("PlaneCreateMultiplier", "2"),
    ColorNormal("ColorNormal", "0000ff"),
    ColorAlert("ColorAlert", "ffffff");

    private static final Map<String, Parameter> LOOKUP;
    private String paramName;
    private String paramValue;

    static {
        LOOKUP = new HashMap<String, Parameter>();
        for (Parameter p : EnumSet.allOf(Parameter.class)) {
            LOOKUP.put(p.getParameterName(), p);
        }
    }

    private Parameter(String paramName, String paramValue) {
        this.paramName = paramName;
        this.paramValue = paramValue;
    }

    public String getParameterName() {
        return this.paramName;
    }

    public String getParameterValue() {
        return this.paramValue;
    }

    public static Parameter get(String paramName) {
        return LOOKUP.get(paramName);
    }

    public boolean setParameterValue(String pValue) {
        this.paramValue = pValue;
        return true;
    }
}

