/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import airspace.Plane;
import calculation.TreeNode;
import calculation.Vertex;
import general.DataCollection;
import general.Parameters;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;

public class GraphicsEngine {
    private Color colorArrivalTree;
    private Color colorArcPoints;
    private BasicStroke planes;
    private BasicStroke arrivalTree;
    private BasicStroke arcPoints;
    private DataCollection dataCollection;
    private BufferedImage nextBufferedImage;
    private BufferedImage offScreenImage;
    private Image offScreenImage2;
    private BufferedImage[] graphicsData;
    private Parameters parameters;
    private double scale;
    private int renderMapWidth;
    private int renderMapHeight;
    private double mountedLat;
    private double mountedLon;
    private double relativeCornerPoint;
    private boolean renderAirspace;
    private boolean renderArcPoints;
    private boolean renderArrivalTree;
    private boolean renderDebug;
    private boolean renderDebug2;
    private boolean renderPlanePath;
    private boolean renderPlaneAsTriangle;
    private boolean renderWeatherMap;
    private boolean status;

    public GraphicsEngine(DataCollection dCollection) {
        this.parameters = dCollection.getParameterClass();
        this.dataCollection = dCollection;
        this.renderAirspace = Boolean.valueOf(this.parameters.getParameterValue("RenderAirspace"));
        this.renderArrivalTree = Boolean.valueOf(this.parameters.getParameterValue("RenderArrivalTree"));
        this.renderArcPoints = Boolean.valueOf(this.parameters.getParameterValue("RenderArcPoints"));
        this.renderPlanePath = Boolean.valueOf(this.parameters.getParameterValue("RenderPlanePath"));
        this.renderWeatherMap = true;
        this.renderPlaneAsTriangle = Boolean.valueOf(this.parameters.getParameterValue("RenderPlaneAsTriangle"));
        int temp = Integer.valueOf(this.parameters.getParameterValue("GraphicsEngineArcpointsColor"));
        this.colorArcPoints = new Color(temp, temp, temp);
        temp = Integer.valueOf(this.parameters.getParameterValue("GraphicsEngineArrivalTreeColor"));
        this.colorArrivalTree = new Color(0, temp, 0);
        this.renderMapWidth = Integer.valueOf(this.parameters.getParameterValue("WeathermapRenderWidth"));
        this.renderMapHeight = Integer.valueOf(this.parameters.getParameterValue("WeathermapRenderHeight"));
        this.scale = (double)this.renderMapWidth / Double.valueOf(this.parameters.getParameterValue("GraphWidth"));
        this.mountedLat = Double.valueOf(this.parameters.getParameterValue("LocationCornerLatitude"));
        this.mountedLon = Double.valueOf(this.parameters.getParameterValue("LocationCornerLongitude"));
        this.status = false;
        this.relativeCornerPoint = this.renderMapHeight;
        this.renderDebug = false;
        this.renderDebug2 = false;
        float[] dash1 = new float[]{1.5f};
        this.planes = new BasicStroke(2.0f, 1, 0, 10.0f, dash1, 0.0f);
        this.arrivalTree = new BasicStroke(2.0f, 1, 0, 1.0f, dash1, 0.0f);
        this.arcPoints = new BasicStroke(1.0f, 1, 0, 1.0f, dash1, 0.0f);
        this.offScreenImage = new BufferedImage(this.renderMapWidth, this.renderMapHeight, 2);
        this.loadCommonGraphics();
    }

    public boolean buildNextFrame() {
        this.status = true;
        Graphics2D g2 = null;
        g2 = this.offScreenImage.createGraphics();
        if (this.dataCollection.getFlagMap()) {
            if (this.renderWeatherMap && this.dataCollection.getWeatherMapClass() != null) {
                g2.drawImage((Image)this.dataCollection.getWeatherMapClass().getMap(), 0, 0, null);
            }
            if (this.dataCollection.getTreeClass() != null && this.dataCollection.getTreeClass().getRoot() != null) {
                this.graphicsRenderAirport(g2, this.dataCollection.getTreeClass().getRoot().getVertex());
            }
            if (this.renderArcPoints) {
                g2.setStroke(this.arcPoints);
                g2.setColor(this.colorArcPoints);
                this.graphicsRenderArcPoints(g2);
            }
            if (this.renderArrivalTree && this.dataCollection.getTreeClass() != null && this.dataCollection.getTreeClass().getRoot() != null) {
                g2.setStroke(this.arrivalTree);
                g2.setColor(this.colorArrivalTree);
                this.graphicsRenderArrivalTree(g2, this.dataCollection.getTreeClass().getRoot());
            }
            this.offScreenImage2 = this.offScreenImage.getScaledInstance(this.renderMapWidth, this.renderMapHeight, 4);
            this.dataCollection.setFlagMap(false);
        }
        g2.drawImage(this.offScreenImage2, 0, 0, null);
        if (this.renderAirspace && this.dataCollection.getAirControlClass() != null) {
            g2.setStroke(this.planes);
            this.graphicsRenderAirspace(g2, this.dataCollection.getAirControlClass().getPlanes());
        }
        if (this.renderDebug) {
            g2.setStroke(this.arcPoints);
            g2.setStroke(this.arcPoints);
            this.graphicsRenderRealArcPoints(g2, this.dataCollection.getArcPoints());
            this.debugDrawGraph(g2);
        }
        if (this.renderDebug2) {
            this.graphicsRenderStuff(g2);
        }
        this.nextBufferedImage = this.offScreenImage;
        this.offScreenImage.flush();
        return true;
    }

    public BufferedImage getFrame() {
        return this.nextBufferedImage;
    }

    public BufferedImage getGraphics(int index) {
        if (index >= 0 && index <= this.graphicsData.length) {
            return this.graphicsData[index];
        }
        return null;
    }

    public final boolean getStatus() {
        return this.status;
    }

    public final void setDebugMode(boolean mode) {
        this.renderDebug = true;
    }

    public final void setDebugMode2() {
        this.renderDebug2 = !this.renderDebug2;
    }

    private void graphicsRenderAirport(Graphics2D g2, Vertex root) {
        if (root == null) {
            return;
        }
        int size = 6;
        int x = (int)((this.mountedLon + root.getLon()) * this.scale);
        int y = (int)(this.relativeCornerPoint + (this.mountedLat - root.getLat()) * this.scale);
        g2.setColor(this.colorArrivalTree);
        g2.fill(new Ellipse2D.Double(x - size / 2, y - size / 2, size, size));
    }

    private boolean graphicsRenderAirspace(Graphics2D g2, ArrayList<Plane> planes) {
        int y;
        int x;
        Plane plane;
        int i;
        if (this.renderPlanePath) {
            i = 0;
            while (i < planes.size()) {
                plane = planes.get(i);
                g2.setColor(Color.yellow);
                ArrayList<TreeNode> path = plane.getPath();
                if (path.size() > 1) {
                    int j = 0;
                    while (j < path.size() - 1) {
                        x = (int)(path.get(j).getVertex().getLon() * this.scale);
                        y = (int)(this.relativeCornerPoint + (this.mountedLat - path.get(j).getVertex().getLat()) * this.scale);
                        g2.fill(new Ellipse2D.Double(x, y, 1.0, 1.0));
                        ++j;
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < planes.size()) {
            plane = planes.get(i);
            x = (int)((this.mountedLon + plane.getLon()) * this.scale);
            y = (int)(this.relativeCornerPoint + (this.mountedLat - plane.getLat()) * this.scale);
            g2.setColor(plane.getColor());
            if (this.renderPlaneAsTriangle) {
                this.graphicsRenderPlaneAsTriangle(g2, x, y, plane.getDir());
            } else {
                g2.fill(new Ellipse2D.Double(x - 3, y - 3, 6.0, 6.0));
            }
            ++i;
        }
        return true;
    }

    private void graphicsRenderPlaneAsTriangle(Graphics2D g2, int x, int y, double direction) {
        double edgeWidth = 6.0;
        double angle = 45.0;
        direction = 360.0 - direction;
        double ta = direction - angle;
        int x1 = x - (int)(edgeWidth * Math.cos(Math.toRadians(ta)));
        int y1 = y - (int)(edgeWidth * Math.sin(Math.toRadians(ta)));
        ta = direction + angle;
        int x2 = x - (int)(edgeWidth * Math.cos(Math.toRadians(ta)));
        int y2 = y - (int)(edgeWidth * Math.sin(Math.toRadians(ta)));
        g2.draw(new Line2D.Double(x, y, x1, y1));
        g2.draw(new Line2D.Double(x, y, x2, y2));
    }

    private void graphicsRenderArcPoints(Graphics2D g2) {
        int origoX = 400;
        int origoY = 400;
        double r = 18.5 * this.scale;
        g2.draw(new Ellipse2D.Double((double)origoX - r, (double)origoY - r, 2.0 * r, 2.0 * r));
        r = 55.56 * this.scale;
        g2.draw(new Ellipse2D.Double((double)origoX - r, (double)origoY - r, 2.0 * r, 2.0 * r));
        r = 111.12 * this.scale;
        g2.draw(new Ellipse2D.Double((double)origoX - r, (double)origoY - r, 2.0 * r, 2.0 * r));
        r = 250.0 * this.scale;
        g2.draw(new Ellipse2D.Double((double)origoX - r, (double)origoY - r, 2.0 * r, 2.0 * r));
    }

    private void graphicsRenderArrivalTree(Graphics2D g2, TreeNode node) {
        int y2;
        int x2;
        TreeNode left = node.getLeft();
        TreeNode right = node.getRight();
        int x1 = (int)((this.mountedLon + node.getVertex().getLon()) * this.scale);
        int y1 = (int)(this.relativeCornerPoint + (this.mountedLat - node.getVertex().getLat()) * this.scale);
        if (left != null) {
            x2 = (int)((this.mountedLon + left.getVertex().getLon()) * this.scale);
            y2 = (int)(this.relativeCornerPoint + (this.mountedLat - left.getVertex().getLat() * this.scale));
            g2.draw(new Line2D.Double(x1, y1, x2, y2));
            this.graphicsRenderArrivalTree(g2, left);
        }
        if (right != null) {
            x2 = (int)((this.mountedLon + right.getVertex().getLon()) * this.scale);
            y2 = (int)(this.relativeCornerPoint + (this.mountedLat - right.getVertex().getLat() * this.scale));
            g2.draw(new Line2D.Double(x1, y1, x2, y2));
            this.graphicsRenderArrivalTree(g2, right);
        }
    }

    private boolean loadCommonGraphics() {
        boolean loadSucceed = true;
        BufferedImage image = null;
        String path = this.parameters.getParameterValue("MediaDir");
        String[] fileList = new String[]{"chopper.jpg", "sidebarTopBackground.jpg"};
        this.graphicsData = new BufferedImage[fileList.length];
        int i = 0;
        while (i < fileList.length) {
            String filename = String.valueOf(path) + fileList[i];
            image = this.loadImage(filename);
            if (image != null) {
                this.graphicsData[i] = image;
            } else {
                loadSucceed = false;
                System.out.println("Can't find: " + filename);
            }
            ++i;
        }
        return loadSucceed;
    }

    private BufferedImage loadImage(String filename) {
        try {
            return ImageIO.read(new File(filename));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void takeSnapshot() {
        String snapshotImageType = "png";
        String snapshotImagaNameFormat = "yyyyMMdd_HHmmss";
        SimpleDateFormat formatter = new SimpleDateFormat(snapshotImagaNameFormat);
        String path = this.parameters.getParameterValue("MediaDir");
        String imageName = "Snapshot_" + formatter.format((Object)new Date()) + "." + snapshotImageType;
        if (this.getFrame() != null) {
            try {
                BufferedImage image = this.getFrame();
                File outputfile = new File(String.valueOf(path) + imageName);
                ImageIO.write((RenderedImage)image, snapshotImageType, outputfile);
            }
            catch (IOException e) {
                System.out.println("Can't take snapshot! (" + imageName + ")");
            }
        }
    }

    private void debugDrawGraph(Graphics2D g2) {
        Vertex[][] verkko = this.dataCollection.getGraph();
        if (verkko == null) {
            return;
        }
        int x1 = 0;
        int y1 = 0;
        int y = 0;
        while (y < 499) {
            int x = 0;
            while (x < 499) {
                if (!verkko[x][y].isAvailable()) {
                    x1 = (int)(this.mountedLon + verkko[x][y].getLon() * this.scale);
                    y1 = (int)(this.relativeCornerPoint - verkko[x][y].getLat() * this.scale);
                    g2.draw(new Line2D.Double(x1, y1, x1 + 1, y1 + 1));
                }
                ++x;
            }
            ++y;
        }
    }

    private void graphicsRenderStuff(Graphics2D g2) {
        int x = 10;
        int y = 20;
        int z = 20;
        String[] weatherData = this.getDebugData();
        g2.setColor(Color.white);
        g2.setFont(new Font("Arial", 1, 13));
        int i = 0;
        while (i < weatherData.length) {
            g2.drawString(weatherData[i], x, y);
            y += z;
            ++i;
        }
    }

    private String[] getDebugData() {
        String[] data = new String[]{"May the for", "V", "M", "J", "T", "T", "E"};
        String[] data2 = new String[]{"ce be wi", "e", "ik", "es", "ob", "i", "e"};
        String[] data3 = new String[]{"th you Val", "er", "k", "s", "ia", "m", "r"};
        String[] data4 = new String[]{"entin", "a", "o", "e", "s", "o", "o"};
        String[] debugData = new String[7];
        int i = 0;
        while (i < data.length) {
            debugData[i] = String.valueOf(data[i]) + data2[i] + data3[i] + data4[i];
            ++i;
        }
        return debugData;
    }

    private void graphicsRenderRealArcPoints(Graphics2D g2, ArrayList<Vertex>[] arcPoints) {
        if (arcPoints == null || arcPoints.length == 0) {
            return;
        }
        int i = 0;
        while (i < arcPoints.length) {
            ArrayList<Vertex> vertexList = arcPoints[i];
            int j = 0;
            while (j < vertexList.size()) {
                Vertex vertex = vertexList.get(j);
                int x = (int)((this.mountedLon + vertex.getLon()) * this.scale);
                int y = (int)(this.relativeCornerPoint + (this.mountedLat - vertex.getLat()) * this.scale);
                g2.draw(new Ellipse2D.Double(x, y, 1.0, 1.0));
                ++j;
            }
            ++i;
        }
    }
}

