/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import general.DataCollection;
import general.Parameters;
import graphics.GraphicsEngine;
import graphics.GraphicsInterface;
import graphics.InfoPane;
import graphics.OutputPane;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class GraphicsWindow
extends JFrame
implements GraphicsInterface,
ActionListener,
KeyListener {
    private static final long serialVersionUID = 1695173054698706699L;
    private Parameters parameters;
    private GraphicsEngine graphicsEngine;
    private OutputPane outputPane;
    private InfoPane infoPane;
    private JMenuBar menuBar;
    private JMenuItem itemClose;
    private JMenuItem itemPause;
    private JMenuItem itemRun;
    private JMenuItem itemSnapshot;
    private DataCollection dataCollection;

    public GraphicsWindow(DataCollection dataCollection, GraphicsEngine graphicsEngine) {
        this.dataCollection = dataCollection;
        this.parameters = dataCollection.getParameterClass();
        this.graphicsEngine = graphicsEngine;
        this.buildWindow();
    }

    @Override
    public boolean update() {
        this.outputPane.update();
        this.infoPane.update();
        return true;
    }

    @Override
    public boolean showErrorMessage(String message, boolean terminate) {
        JOptionPane.showMessageDialog(this, message, "Info", 0);
        if (terminate) {
            if (this.dataCollection.getCalculationControl() != null) {
                this.dataCollection.getCalculationControl().setTimerFlag(false);
            }
            System.exit(1);
        }
        return true;
    }

    @Override
    public boolean showMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "Info", 1);
        return true;
    }

    private boolean buildWindow() {
        int windowWidth = Integer.valueOf(this.parameters.getParameterValue("WindowWidth"));
        int windowHeight = Integer.valueOf(this.parameters.getParameterValue("WindowHeight"));
        int infoPaneWidth = 200;
        int infoPaneHeight = windowHeight;
        int outputPaneWidth = 800;
        int outputPaneHeight = windowHeight;
        this.outputPane = new OutputPane(this.graphicsEngine, outputPaneWidth, outputPaneHeight);
        this.infoPane = new InfoPane(this.graphicsEngine, this.dataCollection, infoPaneWidth, infoPaneHeight);
        this.setLayout(new BorderLayout());
        this.add("West", this.outputPane);
        this.add("East", this.infoPane);
        this.menuBar = new JMenuBar();
        this.itemClose = new JMenuItem("Close");
        this.itemClose.addActionListener(this);
        this.menuBar.add("West", this.itemClose);
        this.itemRun = new JMenuItem("Run");
        this.itemRun.addActionListener(this);
        this.menuBar.add("West", this.itemRun);
        this.itemPause = new JMenuItem("Pause");
        this.itemPause.addActionListener(this);
        this.menuBar.add("West", this.itemPause);
        this.itemSnapshot = new JMenuItem("Snapshot");
        this.itemSnapshot.addActionListener(this);
        this.menuBar.add("West", this.itemSnapshot);
        this.addKeyListener(this);
        this.itemClose.setEnabled(true);
        this.itemPause.setEnabled(true);
        this.itemRun.setEnabled(false);
        this.setJMenuBar(this.menuBar);
        this.setTitle(this.parameters.getParameterValue("Title"));
        this.setDefaultCloseOperation(3);
        this.setSize(windowWidth, windowHeight);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.itemClose) {
            System.exit(1);
        } else if (object == this.itemPause) {
            this.dataCollection.setFlagPause(true);
            this.itemPause.setEnabled(false);
            this.itemRun.setEnabled(true);
        } else if (object == this.itemRun) {
            this.dataCollection.setFlagPause(false);
            this.itemPause.setEnabled(true);
            this.itemRun.setEnabled(false);
        } else if (object == this.itemSnapshot) {
            this.graphicsEngine.takeSnapshot();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 67) {
            this.graphicsEngine.setDebugMode2();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

