/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import general.DataCollection;
import graphics.GraphicsEngine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JPanel;

public class InfoPane
extends JPanel {
    private static final long serialVersionUID = 1731983234032336151L;
    private Color colorBackground = new Color(255, 255, 255);
    private BufferedImage backgroundImage;
    private DataCollection dataCollection;
    private static final Font FONT_TITLE = new Font("Arial", 1, 13);
    private static final Font FONT_CAPTION = new Font("Arial", 1, 11);
    private static final Font FONT_DESCRIPTION = new Font("Arial", 0, 11);

    public InfoPane(GraphicsEngine engine, DataCollection dataCollection, int panelWidth, int panelHeight) {
        this.dataCollection = dataCollection;
        this.setPreferredSize(new Dimension(panelWidth, panelHeight));
        this.backgroundImage = engine.getGraphics(1);
    }

    public boolean update() {
        this.repaint();
        return true;
    }

    @Override
    public void paint(Graphics g) {
        int composition = 60;
        int planeCurrent = 0;
        int planeArrived = 0;
        int internalTime = 0;
        int internalTimeHours = 0;
        double planesArrivedRate = 0.0;
        boolean currentAirportStatus = false;
        boolean debugMode = false;
        DecimalFormat planesPerHour = new DecimalFormat("0.0");
        internalTime = this.dataCollection.getInternalClock() / 60;
        if (this.dataCollection.getAirControlClass() != null) {
            planeArrived = this.dataCollection.getAirControlClass().getArrivedPlanes();
            planeCurrent = this.dataCollection.getAirControlClass().getNumberOfPlanes();
            currentAirportStatus = this.dataCollection.getAirControlClass().getAirportStatus();
        }
        String infoPlanesCurrent = "Landing: " + planeCurrent;
        String infoPlanesArrived = "Arrived: " + planeArrived;
        String infoAirportStatus = currentAirportStatus ? "Airport: open" : "Airport: closed";
        int timetemp = internalTime;
        while (timetemp >= 60) {
            timetemp -= 60;
            ++internalTimeHours;
        }
        String infoTime = internalTimeHours + " hour " + timetemp + " min";
        if (internalTime > 0) {
            planesArrivedRate = (double)planeArrived / (1.0 * (double)internalTime / 60.0);
        }
        String planeArrivedPerHour = "Rate: " + planesPerHour.format(planesArrivedRate) + " planes / h";
        String debugRefreshRate = "Refresh rate: " + this.dataCollection.getRefreshRate() + " ms";
        g.setColor(this.colorBackground);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.backgroundImage, 0, 0, null);
        g.setColor(Color.white);
        g.setFont(FONT_TITLE);
        g.drawString("Info", 10, 22);
        g.setColor(Color.black);
        g.setFont(FONT_CAPTION);
        g.drawString("Planes", 10, composition);
        g.setFont(FONT_DESCRIPTION);
        g.drawString(infoPlanesCurrent, 10, composition += 15);
        g.drawString(infoPlanesArrived, 10, composition += 15);
        g.drawString(planeArrivedPerHour, 10, composition += 15);
        g.setFont(FONT_CAPTION);
        g.drawString("Airport", 10, composition += 30);
        g.setFont(FONT_DESCRIPTION);
        g.drawString(infoAirportStatus, 10, composition += 15);
        g.setFont(FONT_CAPTION);
        g.drawString("Time", 10, composition += 30);
        g.setFont(FONT_DESCRIPTION);
        g.drawString(infoTime, 10, composition += 15);
        if (debugMode) {
            g.setFont(FONT_CAPTION);
            g.drawString("Miscellaneous", 10, composition += 30);
            g.setFont(FONT_DESCRIPTION);
            g.drawString(debugRefreshRate, 10, composition += 15);
        }
    }
}

