/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import graphics.GraphicsEngine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;

public class OutputPane
extends JPanel {
    private static final long serialVersionUID = 9054430788315943103L;
    private GraphicsEngine engine;
    private Color colorBackground = new Color(50, 50, 50);
    private static final Font FONT_TITLE = new Font("Arial", 1, 13);

    public OutputPane(GraphicsEngine engine, int panelWidth, int panelHeight) {
        this.setPreferredSize(new Dimension(panelWidth, panelHeight));
        this.engine = engine;
        this.repaint();
    }

    public boolean update() {
        this.repaint();
        return true;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.engine.getStatus()) {
            g.setColor(this.colorBackground);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.engine.getGraphics(0), this.getWidth() / 2 - 215, this.getHeight() / 2 - 100, null);
            g.setColor(Color.white);
            g.setFont(FONT_TITLE);
            g.drawString("Loading...", this.getWidth() / 2 - 20, this.getHeight() / 2 + 80);
        } else {
            g.drawImage(this.engine.getFrame(), 0, 0, null);
        }
    }
}

