// INCLUDE FILES
#include "ContextCallLogAppUi.h"
#include "ContextCallLogView.h"
#include <ContextCallLog.rsg>
#include "contextcalllog.hrh"
#include "contextcalllogapp.h"

#include <avkon.hrh>
#include "icons.h"
#include <bautils.h>

const TInt KUidToBackgroundValue=0x2004;
const TUid KUidToBackground={KUidToBackgroundValue};

void CContextCallLogAppUi::ConstructL()
{
	
#ifndef __WINS__
	// works only for context_log on the emulator
	{ TRAPD(errs, StartStarterL(_L("call_log"), KUidContextCallLog, true)); }
#endif

	iWait=CTimeOut::NewL(*this);
	iWaitingOps=CList<TCallBack>::NewL();

	BaseConstructL();

	// LOGGING ON or OFF
	TBool logging=ETrue;
	Settings().GetSettingL(18, logging);
	iLog=Cfile_output_base::NewL(AppContext(), _L("calllog_log"), logging, false);

	if (!logging && iLog) iLog->paused=true;

	iJabberDb=CDb::NewL(AppContext(), _L("JABBER"), EFileWrite|EFileShareAny);
	iJabberData=CJabberData::NewL(AppContext(), *iJabberDb);

	iPresenceHolder=CPresenceHolder::NewL(*iJabberData);

	iCallLog=new (ELeave) call_log(AppContext(), *iJabberData, *iPresenceHolder);
	iCallLog->ConstructL();

	iPhoneHelper = new (ELeave) phonehelper(*iCallLog, NULL);
	iPhoneHelper->ConstructL();

	if (iPresenceHolder) iPresenceHolder->AddListener(iCallLog);
	if (iPresenceHolder) iPresenceHolder->AddListener(this);

	CEikStatusPane* sp = StatusPane();
	iNaviPane = (CAknNavigationControlContainer*)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi));
	iDecoratedTabGroup = iNaviPane->ResourceDecorator();
	if (iDecoratedTabGroup)
	{
		iTabGroup = (CAknTabGroup*) iDecoratedTabGroup->DecoratedControl();
	}

	iIconlist = new (ELeave) CAknIconArray(30);
	LoadIcons(iIconlist);

	// for phonebook dialogs
	iResource_files=new (ELeave) CArrayFixFlat<TInt>(5);
	TFileName resfile=_L("z:\\System\\data\\PBKVIEW.RSC");
	BaflUtils::NearestLanguageFile(iEikonEnv->FsSession(), resfile); 
	iResource_files->AppendL(iEikonEnv->AddResourceFileL(resfile));

	iMissedView = new (ELeave) CContextCallLogView(*iJabberData, iLog, iCallLog, iIconlist, *iPhoneHelper);

	CleanupStack::PushL( iMissedView );
	iMissedView->ConstructL(KMissedViewId);
	AddViewL( iMissedView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();    

	iReceivedView = new (ELeave) CContextCallLogView(*iJabberData, iLog, iCallLog, iIconlist, *iPhoneHelper);

	CleanupStack::PushL( iReceivedView );
	iReceivedView->ConstructL(KReceivedViewId);
	AddViewL( iReceivedView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();  

	iDialledView = new (ELeave) CContextCallLogView(*iJabberData, iLog, iCallLog, iIconlist, *iPhoneHelper);

	CleanupStack::PushL( iDialledView );
	iDialledView->ConstructL(KDialledViewId);
	AddViewL( iDialledView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();

	auto_ptr<CPresenceDetailView> detailview(CPresenceDetailView::NewL());
	AddViewL(detailview.get());
	iPresenceDetailView=detailview.release();

	SetDefaultViewL(*iMissedView);

	iEikonEnv->AddForegroundObserverL(*this);
}

CContextCallLogAppUi::~CContextCallLogAppUi()
{
	if(iDialledView) iDialledView->exiting();
	if(iReceivedView) iReceivedView->exiting();
	if(iMissedView) iMissedView->exiting();

	iEikonEnv->RemoveForegroundObserver(*this);
	if (iResource_files)
	{
		for (int i=0; i<iResource_files->Count(); i++) {
			iEikonEnv->DeleteResourceFile((*iResource_files)[i]);
		}
	}
	delete iResource_files;
	delete iPhoneHelper;

	delete iWait;
	delete iWaitingOps;
	
     	delete iLog;
	delete iCallLog;
	delete iPresenceHolder;
	delete iPresenceUpdater;
	delete iJabberData;
	delete iJabberDb;
	delete iDecoratedTabGroup; 
	delete iIconlist;
}

TKeyResponse CContextCallLogAppUi::HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
{
	if ( iTabGroup == NULL )
	{
		return EKeyWasNotConsumed;
	}

	TInt active = iTabGroup->ActiveTabIndex();
	TInt count = iTabGroup->TabCount();

	switch ( aKeyEvent.iCode )
	{
		case EKeyLeftArrow:
			if ( active > 0 )
			{
				active--;
				iTabGroup->SetActiveTabByIndex( active );
				ActivateLocalViewL(TUid::Uid(iTabGroup->TabIdFromIndex(active)));
			}
			break;
		case EKeyRightArrow:
			if( (active + 1) < count )
			{
				active++;
				iTabGroup->SetActiveTabByIndex( active );
				ActivateLocalViewL(TUid::Uid(iTabGroup->TabIdFromIndex(active)));
			}
			break;
		default:
			return EKeyWasNotConsumed;
			break;
	}
	return EKeyWasConsumed;
}

void CContextCallLogAppUi::HandleCommandL(TInt aCommand)
{
	switch ( aCommand )
	{
		case EContextCallLogCmdCrash:
		{
			TBuf<2> b; b.Append(_L("xxx"));
		}
		case EEikCmdExit:
		{
			Exit();
			break;
		}
		case EAknSoftkeyBack:
		{
			hide();
			break;
		}
		
		default:
			break;      
	}
}

void CContextCallLogAppUi::hide()
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::hide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	
	TApaTask task(wsSession);
	TInt id = CEikonEnv::Static()->RootWin().Identifier();
	task.SetWgId(id);
		
	if ( wsSession.GetFocusWindowGroup() == id )
	{
		task.SendToBackground();
	}
}

void CContextCallLogAppUi::HandleGainingForeground()
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::HandleGainingForeground"));

	iCallLog->refresh();

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("To foreground"));
		iLog->write_nl();
	}
	//if (iPresenceUpdater) iPresenceUpdater->Start();
}

void CContextCallLogAppUi::HandleLosingForeground()
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::HandleLosingForeground"));

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("To background\n"));
		iLog->write_nl();
	}
	
	//if (iPresenceUpdater) iPresenceUpdater->Stop();
}

void CContextCallLogAppUi::Notify(const TDesC& /*aMessage*/)
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::Notify"));
	// no impl	
}

void CContextCallLogAppUi::PresenceChangedL(TInt /*ContactId*/, MPresenceData &/*info*/)
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::PresenceChangedL"));
	// no implementation
}

void CContextCallLogAppUi::DisplayPresenceDetailsL(const TDesC& Name, const MPresenceData* PresenceData)
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::DisplayPresenceDetailsL"));

	if (PresenceData == 0) return;
	iPresenceDetailView->SetData(Name, PresenceData);
	ActivateLocalViewL(KPresenceDetailView);
}


void CContextCallLogAppUi::SetTab(TInt tabId)
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::SetTab"));

	iTabGroup->SetActiveTabById(tabId);

}
  
void CContextCallLogAppUi::QueueOp(TCallBack Op, int AfterSeconds)
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::QueueOp"));

	iWaitingOps->AppendL(Op);
	iWait->Wait(AfterSeconds);
}
void CContextCallLogAppUi::expired(CBase*)
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::expired"));

	TCallBack op=iWaitingOps->Pop();
	((*this).*op)();
	while (iWaitingOps->iFirst && iWaitingOps->Top()==op) iWaitingOps->Pop();
	if (iWaitingOps->iFirst) {
		iWait->Wait(1);
	}
}

void CContextCallLogAppUi::ProcessMessageL(TUid aUid,const TDesC8& aParams)
{
	CALLSTACKITEM(_L("CContextCallLogAppUi::ProcessMessageL"));

	if (aUid==KUidToBackground) {
		QueueOp(&CContextCallLogAppUi::hide);
	} else {
		CAknViewAppUi::ProcessMessageL(aUid,aParams);
	}
}

void CContextCallLogAppUi::HandleWsEventL(const TWsEvent& aEvent,CCoeControl* aDestination)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::HandleWsEventL"));


	if (aEvent.Type() == 999)
	{
		QueueOp(&CContextCallLogAppUi::hide);
	}
	else
	{
		CAknViewAppUi::HandleWsEventL(aEvent, aDestination);
	}

}
