#include "ContextCallLogDocument.h"
#include "ContextCallLogAppUi.h"
#include "settings.h"

CContextCallLogDocument::CContextCallLogDocument(CEikApplication& aApp)
: CAknDocument(aApp)    
    {
    }

CContextCallLogDocument::~CContextCallLogDocument()
{
	delete iContext;
}

// EPOC default constructor can leave.
void CContextCallLogDocument::ConstructL()
{
	iContext=CApp_context::NewL(false, _L("call_log"));
	
	CALLSTACKITEM(_L("CContextCallLogDocument::ConstructL"));
	
#ifndef __WINS__
	TParsePtrC parse(Application()->DllName());
	iContext->SetAppDir(parse.DriveAndPath());
#else
	iContext->SetAppDir(_L("c:\\system\\apps\\contextcalllog\\"));
#endif
	iContext->SetDataDir(_L("c:\\system\\data\\context\\"), EFalse);
	CSettings* s=CSettings::NewL(*iContext, iNoDefaults, _L(""), true); // readonly settings
	iContext->SetSettings(s);
}

CContextCallLogDocument* CContextCallLogDocument::NewL(CEikApplication& aApp)     
{
	CContextCallLogDocument* self = new (ELeave) CContextCallLogDocument( aApp );
	CleanupStack::PushL( self );
	self->ConstructL();
	CleanupStack::Pop();

	return self;
}

CEikAppUi* CContextCallLogDocument::CreateAppUiL()
    {
    return new (ELeave) CContextCallLogAppUi(*iContext);
    }


