/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CC_CONNECTIONINIT_H_INCLUDED
#define CC_CONNECTIONINIT_H_INCLUDED 1

#include "ver.h"

#include <in_sock.h>
#include <es_sock.h>
#include <AgentClient.h>
#include <capcodec.h>
#include "app_context.h"

#ifndef __S60V2__
#include <intconninit.h>
#endif

#include "timeout.h"
#include "independent.h"
#include "checkedactive.h"

#ifdef __S60V2__
#include <CommDbConnPref.h>
#endif

class MSocketObserver {
public:
	virtual void success(CBase* source) = 0;
	virtual void error(CBase* source, TInt code, const TDesC& reason) = 0;
	virtual void info(CBase* source, const TDesC& msg) = 0;
};


class CConnectionOpener : public CCheckedActive, public MTimeOut {
	// separate class since the CIntConnectionInitiator gives multiple
	// events from single invokation :-(
public:
#ifndef __S60V2__
	IMPORT_C static CConnectionOpener* NewL(MSocketObserver& Observer, RSocketServ& Serv);
#else
	IMPORT_C static CConnectionOpener* NewL(MSocketObserver& Observer, RSocketServ& Serv, RConnection& Connection);
#endif
	IMPORT_C void MakeConnectionL(TUint32 Iap); // async
	IMPORT_C void CloseConnection(); // sync
	IMPORT_C bool MadeConnection();
	IMPORT_C ~CConnectionOpener();
private:
#ifndef __S60V2__
	CConnectionOpener(MSocketObserver& Observer, RSocketServ& Serv);
#else
	CConnectionOpener(MSocketObserver& Observer, RSocketServ& Serv, RConnection& Connection);
#endif
	void ConstructL();
	enum state { IDLE, CLOSING, RETRYING_CLOSE, CONNECTING, RETRYING_CONNECT, CONNECTED };
	state current_state;
	
	void CheckedRunL();
	void DoCancel();
	TInt CheckedRunError(TInt aError);

	MSocketObserver& iObserver;

	TUint32		iIapId;
	bool		iMadeConnection;
	RSocketServ&	iServ;

#ifdef __S60V2__
	RConnection&	iConnection;
	TCommDbConnPref iConnPref;
#else
	CIntConnectionInitiator *iInitiator;
	CCommsDbConnectionPrefTableView::TCommDbIapConnectionPref iConnPref;
#endif

	TInt	iRetryCount;
	static const TInt MAX_RETRIES;
	CTimeOut	*iWait;
	void expired(CBase*);

#ifdef __WINS__
	independent_worker	iKeepAlive;
#endif
};

#endif
