#ifndef CC_ERRORHANDLING_H_INCLUDED
#define CC_ERRORHANDLING_H_INCLUDED 1

#include <e32std.h>
#include <e32base.h>

class CErrorInfo : public CBase {
public:
	enum TErrorLevel {
		EInfo,
		EWarning,
		EError,
		ECritical
	};
	enum TErrorType {
		EInputData,
		EReferenceData,
		EEnvironment,
		EProgramFault,
		ETemporary
	};
	IMPORT_C static CErrorInfo* NewL(TInt aErrorCode, const TDesC& aSource,
		const TDesC& aUserMessage, const TDesC& aTechMessage,
		TErrorType aErrorType, TErrorLevel aErrorLevel,
		CErrorInfo* aInnerError); // on success, takes ownership
		// may produce a 'best-effort' partially constructed object
	IMPORT_C virtual ~CErrorInfo();

	virtual TInt ErrorCode() const = 0;
	virtual const TDesC& Source() const = 0;
	virtual const TDesC& UserMessage() const = 0;
	virtual const TDesC& aTechMessage() const = 0;
	virtual TErrorType ErrorType() const = 0;
	virtual TErrorLevel ErrorLevel() const = 0;
	virtual const CErrorInfo* InnerError() const = 0;
};

#define LEAVE_ERRORINFO(CODE, SOURCE, USERMESSAGE, TECHMESSAGE, TYPE, LEVEL, INNER) { GetContext()->RaiseErrorWithInfo(CODE, SOURCE, USERMESSAGE, TECHMESSAGE, TYPE, LEVEL, INNER); }
#define TRAP_ERRORINFO(ERR, INFO, BLOCK) { TRAP(ERR, BLOCK); INFO=GetContext()->GetLastErrorInfo(); }
#define TRAPD_ERRORINFO(ERR, INFO, BLOCK) { TInt ERR; CErrorInfo* INFO; TRAP(ERR, BLOCK); INFO=GetContext()->GetLastErrorInfo(); }
#endif
