#ifndef CC_RAW32STD_H_INCLUDED
#define CC_RAW32STD_H_INCLUDED 1

#include <w32std.h>
#include <raii.h>

class RAWsSession : public RWsSession, public RABase {
public:
	inline void ConnectLA() {
		RABase::CloseRA();
		User::LeaveIfError(Connect());
		iOpen=ETrue;
		PutOnStackL();
	}
	~RAWsSession() { RABase::CloseRA(); }
	void CloseInner() { RWsSession::Close(); }
private:
	void Close() { }
};

class RAWindowGroup : public RWindowGroup, public RABase {
public:
	RAWindowGroup(RWsSession &aWs) : RWindowGroup(aWs) { }
	inline void ConstructLA(TUint32 aClientHandle) {
		RABase::CloseRA();
		User::LeaveIfError(Construct(aClientHandle));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void ConstructLA(TUint32 aClientHandle, TBool aInitialFocusState) {
		RABase::CloseRA();
		User::LeaveIfError(Construct(aClientHandle,aInitialFocusState));
		iOpen=ETrue;
		PutOnStackL();
	}
	~RAWindowGroup() { RABase::CloseRA(); }
	void CloseInner() { RWindowGroup::Close(); }
private:
	void Close() { }
};

#endif // CC_RAW32STD_H_INCLUDED
