/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CC_XMLBUF_H_INCLUDED
#define CC_XMLBUF_H_INCLUDED 1

#include <e32std.h>
#include <e32base.h>
#include <badesca.h>

#if defined(_UNICODE)
    #define CXmlBuf	CXmlBuf16
#else
    #define CXmlBuf	CXmlBuf8
#endif

class CXmlBuf16 : public CBase {
public:
	IMPORT_C static CXmlBuf16*	NewL(TInt initial_size);
	IMPORT_C void Zero();
	IMPORT_C void BeginElement(const TDesC& name, const MDesCArray* const attributes=0);
	IMPORT_C void EndElement(const TDesC& name);
	IMPORT_C void Characters(const TDesC& buf, bool escape_quote=false);
	IMPORT_C void Leaf(const TDesC& name, const TDesC& buf, const MDesCArray* const attributes=0);
	IMPORT_C const TDesC& Buf() const;
	IMPORT_C ~CXmlBuf16();
private:
	CXmlBuf16();
	void ConstructL(TInt initial_size);

	void AppendL(const TDesC& buf);

	HBufC*		iBuf;
};

class CXmlBuf8 : public CBase {
public:
	IMPORT_C static CXmlBuf8*	NewL(TInt initial_size);
	IMPORT_C void Zero();
	IMPORT_C void BeginElement(const TDesC8& name, const MDesC8Array* const attributes=0);
	IMPORT_C void EndElement(const TDesC8& name);
	IMPORT_C void Characters(const TDesC8& buf, bool escape_quote=false);
	IMPORT_C void Characters(const TDesC16& buf, bool escape_quote=false);
	IMPORT_C void Leaf(const TDesC8& name, const TDesC8& buf, const MDesC8Array* const attributes=0);
	IMPORT_C void Leaf(const TDesC8& name, const TDesC16& buf, const MDesC8Array* const attributes=0);
	IMPORT_C const TDesC8& Buf() const;
	IMPORT_C ~CXmlBuf8();
private:
	CXmlBuf8();
	void ConstructL(TInt initial_size);

	void AppendL(const TDesC8& buf);
	void AppendL(const TDesC16& buf);

	HBufC8*		iBuf;
};

#endif
