#include "errorhandling.h"

#include "symbian_auto_ptr.h"

_LIT(KUnsetNoMemory, "<failed to allocate memory for string>");

class CErrorInfoImpl : public CErrorInfo {
private:
	CErrorInfoImpl(TInt aErrorCode, TErrorType aErrorType, TErrorLevel aErrorLevel,
		CErrorInfo* aInnerError);
	void ConstructL(const TDesC& aSource, const TDesC& aUserMessage, 
		const TDesC& aTechMessage);
		
	virtual ~CErrorInfoImpl();

	virtual TInt ErrorCode() const;
	virtual const TDesC& Source() const;
	virtual const TDesC& UserMessage() const;
	virtual const TDesC& aTechMessage() const;
	virtual TErrorType ErrorType() const;
	virtual TErrorLevel ErrorLevel() const;
	virtual const CErrorInfo* InnerError() const;

	friend class CErrorInfo;
	friend class auto_ptr<CErrorInfoImpl>;

	TInt		iErrorCode;
	HBufC	*iSource, *iUserMessage, *iTechMessage;
	CErrorInfo	*iInnerError;
	TErrorType	iErrorType;
	TErrorLevel	iErrorLevel;
};

EXPORT_C CErrorInfo* CErrorInfo::NewL(TInt aErrorCode, const TDesC& aSource,
		const TDesC& aUserMessage, const TDesC& aTechMessage,
		TErrorType aErrorType, TErrorLevel aErrorLevel,
		CErrorInfo* aInnerError)
{
	auto_ptr<CErrorInfoImpl> ret(new (ELeave) CErrorInfoImpl(aErrorCode,
		aErrorType, aErrorLevel, aInnerError) );
	ret->ConstructL(aSource, aUserMessage, aTechMessage);
	return ret.release();
}

EXPORT_C CErrorInfo::~CErrorInfo()
{
}


CErrorInfoImpl::CErrorInfoImpl(TInt aErrorCode, TErrorType aErrorType, TErrorLevel aErrorLevel,
	CErrorInfo* aInnerError) : iErrorCode(aErrorCode), iErrorType(aErrorType),
	iErrorLevel(aErrorLevel), iInnerError(aInnerError)
{
}

void CErrorInfoImpl::ConstructL(const TDesC& aSource, const TDesC& aUserMessage, 
	const TDesC& aTechMessage)
{
	iSource=aSource.Alloc();
	iUserMessage=aUserMessage.Alloc();
	iTechMessage=aTechMessage.Alloc();
}
	
CErrorInfoImpl::~CErrorInfoImpl()
{
	delete iSource;
	delete iUserMessage;
	delete iTechMessage;
	delete iInnerError;
}

TInt CErrorInfoImpl::ErrorCode() const
{
	return iErrorCode;
}

const TDesC& CErrorInfoImpl::Source() const
{
	if (iSource) return *iSource;
	return KUnsetNoMemory;
}

const TDesC& CErrorInfoImpl::UserMessage() const
{
	if (iUserMessage) return *iUserMessage;
	return KUnsetNoMemory;
}

const TDesC& CErrorInfoImpl::aTechMessage() const
{
	if (iTechMessage) return *iTechMessage;
	return KUnsetNoMemory;
}

CErrorInfo::TErrorType CErrorInfoImpl::ErrorType() const
{
	return iErrorType;
}

CErrorInfo::TErrorLevel CErrorInfoImpl::ErrorLevel() const
{
	return iErrorLevel;
}

const CErrorInfo* CErrorInfoImpl::InnerError() const
{
	return iInnerError;
}
