/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "jabberdata.h"
#include "symbian_auto_ptr.h"

EXPORT_C CJabberData* CJabberData::NewL(MApp_context& Context, CDb& Db)
{
	auto_ptr<CJabberData> ret(new (ELeave) CJabberData(Context, Db));
	ret->ConstructL();
	return ret.release();
}

void CJabberData::ConstructL()
{
	TInt cols[]={ EDbColInt32, EDbColText, -1 };
	TInt idx[]= { 1, -2, 2, -1 };

	MDBStore::ConstructL(cols, idx, true, _L("NICK"));
}

EXPORT_C bool CJabberData::GetJabberNickL(TInt ContactId, TDes& Nick)
{
	SwitchIndexL(0);
	TDbSeekKey rk( ContactId );
	if (iTable.SeekL(rk) ) {
		iTable.GetL();
		Nick.CopyLC(iTable.ColDes(2));
		return true;
	} else {
		Nick.Zero();
		return false;
	}
}

EXPORT_C void CJabberData::SetJabberNickL(TInt ContactId, const TDesC& Nick)
{
	SwitchIndexL(0);
	TDbSeekKey rk( ContactId);
	TBuf<100> n;
	n.CopyLC(Nick);
	if (iTable.SeekL(rk) ) {
		iTable.UpdateL();
		iTable.SetColL(2, n);
	} else {
		iTable.InsertL();
		iTable.SetColL(1, ContactId);
		iTable.SetColL(2, n);
	}
	PutL();
}

EXPORT_C CJabberData::~CJabberData()
{
}

EXPORT_C TInt CJabberData::GetContactIdL(const TDesC& Nick)
{
	// KErrNotFound if not found
	TBuf<100> n;
	n.CopyLC(Nick);
	SwitchIndexL(1);
	TDbSeekKey rk(n);
	if (iTable.SeekL(rk) ) {
		iTable.GetL();
		return iTable.ColInt32(1);
	} else {
		return KErrNotFound;
	}
}

CJabberData::CJabberData(MApp_context& Context, CDb& Db) : MDBStore(Db.Db()), MContextBase(Context), iJabberNickDb(Db)
{
}