#include "presencedetailview.h"
#include <contextcommon.rsg>
#include <aknviewappui.h>
#include <bautils.h>
#include <eiklabel.h>
#include <eikimage.h>
#include "icons.h"
#include <contextcommon.mbg>
#include <gulalign.h>
#include <aknnavi.h>
#include <akntitle.h> 
#include "presence_data.h"

class CPresenceDetailContainer : public CCoeControl, public MEikScrollBarObserver {
public:
	CPresenceDetailContainer(const TDesC& Name, const MPresenceData* PresenceData);
	~CPresenceDetailContainer();
	void ConstructL(const TRect& aRect);

	void HandleScrollEventL(CEikScrollBar* aScrollBar, TEikScrollEvent aEventType);
	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	void CreateScrollBars();
        
private:
	void MoveUp();
	void MoveDown();
	void SizeChanged();
	
	TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
	void SetSizeOfComponents();
	void SetPositionOfComponents();

	const TDesC&		iName;
	const MPresenceData*	iPresence;
	TEikScrollBarModel iModel;
	CEikScrollBarFrame * iSBFrame; 
	CEikLabel * prev_loc_title;
	CEikLabel * prev_loc;
	CEikLabel * curr_loc_title;
	CEikLabel * curr_loc;
	CEikLabel * curr_profile_title;
	CEikLabel * curr_profile_name;
	CEikLabel * curr_profile_speaker;
	CEikLabel * curr_profile_speaker_volume;
	CEikLabel * curr_profile_vib;
	CEikLabel * user_active;
	CEikLabel * bt_nb_title;
	CEikLabel * bt_nb_buddies;
	CEikLabel * bt_nb_others;
	CEikImage * icon_speaker;
	CEikImage * icon_vibra;
	CEikImage * icon_buddies;
	CEikImage * icon_others;
	CEikImage * icon_user_activity;

	TInt iScrollSpan; 
	TInt iNbPosition; 
	TInt iThumbPosition; 
	TInt iCurrentPos;
};

class CPresenceDetailViewImpl : public CPresenceDetailView {
private:
	CPresenceDetailViewImpl();
	void ConstructL();

	virtual void SetData(const TDesC& Name, const MPresenceData* PresenceData);
	
		TUid Id() const;

	
        void HandleCommandL(TInt aCommand);
        void DoActivateL(const TVwsViewId& aPrevViewId,
		TUid aCustomMessageId,
		const TDesC8& aCustomMessage);
        void DoDeactivate();

	friend class CPresenceDetailView;

	TBuf<100>	iName;
	const MPresenceData*	iPresence;
	CPresenceDetailContainer* iContainer;
	TVwsViewId	iPrevView;
	TInt		iResource;
public:
	virtual ~CPresenceDetailViewImpl();
};

EXPORT_C CPresenceDetailView* CPresenceDetailView::NewL()
{
	auto_ptr<CPresenceDetailViewImpl> ret(new (ELeave) CPresenceDetailViewImpl);
	ret->ConstructL();
	return ret.release();
}

CPresenceDetailContainer::CPresenceDetailContainer(const TDesC& Name, const MPresenceData* PresenceData) : 
	iName(Name), iPresence(PresenceData)
{
}

CPresenceDetailContainer::~CPresenceDetailContainer()
{
	delete prev_loc_title;
	delete prev_loc;
	delete curr_loc_title;
	delete curr_loc;
	delete curr_profile_title;
	delete curr_profile_name;
	delete curr_profile_speaker;
	delete curr_profile_speaker_volume;
	delete curr_profile_vib;
	delete user_active;
	delete bt_nb_title;
	delete bt_nb_buddies;
	delete bt_nb_others;
	delete icon_speaker;
	delete icon_vibra;
	delete icon_buddies;
	delete icon_others;
	delete icon_user_activity;

	delete iSBFrame;

	CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
        CAknNavigationControlContainer* np = (CAknNavigationControlContainer *)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi));
        np->Pop();
}

void CPresenceDetailContainer::ConstructL(const TRect& aRect)
{
	CreateWindowL(); 

	//navi pane
	CEikStatusPane* s=iEikonEnv->AppUiFactory()->StatusPane();
	CAknNavigationControlContainer	*np = (CAknNavigationControlContainer *)s->ControlL(TUid::Uid(EEikStatusPaneUidNavi)); 
	// view title 
	HBufC * title = iEikonEnv->AllocReadResourceL(R_TITLE);
	title = title->ReAllocL(title->Length() + 1 + iName.Length());
	title->Des().Append(_L(" "));
	title->Des().Append(iName);
	CAknTitlePane* tp=(CAknTitlePane*)s->ControlL(TUid::Uid(EEikStatusPaneUidTitle));
	tp->SetText(title);

	//CAknNavigationDecorator * et = np->ResourceDecorator(); just a test

	np->PushDefaultL();
	
	TRgb light_gray = TRgb(225,225,225);
	TRgb dark_gray = TRgb(210,210,210);
	TBuf<60> temp;
	HBufC * temp2 = 0;
	TInt icon = 0;
	_LIT(KQuestion, "?");

	temp.Zero();
	prev_loc_title=new (ELeave) CEikLabel;
	temp2 = iEikonEnv->AllocReadResourceL(R_PREVIOUS_LOCATION);
	temp.Append(temp2->Des());
	delete temp2; temp2 = 0;
	prev_loc_title->SetTextL(temp);
	prev_loc_title->SetContainerWindowL(*this);
	prev_loc_title->SetFont(CEikonEnv::Static()->DenseFont());
	prev_loc_title->SetEmphasis(CEikLabel::EFullEmphasis);
	prev_loc_title->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	prev_loc_title->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	prev_loc_title->SetAllMarginsTo(2);
	
	prev_loc=new (ELeave) CEikLabel;
	prev_loc->SetContainerWindowL(*this);
	prev_loc->SetEmphasis(CEikLabel::EFullEmphasis);
	prev_loc->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	prev_loc->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	prev_loc->SetFont(CEikonEnv::Static()->DenseFont());
	prev_loc->SetAllMarginsTo(2);

	temp.Zero();
	curr_loc_title=new (ELeave) CEikLabel;
	temp2 = iEikonEnv->AllocReadResourceL(R_CURRENT_LOCATION);
	temp.Append(temp2->Des());
	delete temp2; temp2 = 0;
	curr_loc_title->SetTextL(temp);
        curr_loc_title->SetContainerWindowL(*this);
	curr_loc_title->SetFont(CEikonEnv::Static()->DenseFont());
	curr_loc_title->SetAllMarginsTo(2);
	curr_loc_title->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_loc_title->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	curr_loc_title->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray); 

	curr_loc=new (ELeave) CEikLabel;
	curr_loc->SetContainerWindowL(*this);
	curr_loc->SetFont(CEikonEnv::Static()->DenseFont());
	curr_loc->SetAllMarginsTo(2);
	curr_loc->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_loc->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	curr_loc->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray); 
	
	temp.Zero();
	curr_profile_title=new (ELeave) CEikLabel;
	temp2 = iEikonEnv->AllocReadResourceL(R_CURRENT_PROFILE);
	temp.Append(temp2->Des());
	delete temp2; temp2 = 0;
        curr_profile_title->SetTextL(temp);
	curr_profile_title->SetContainerWindowL(*this);
	curr_profile_title->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_title->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_profile_title->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	curr_profile_title->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_title->SetAllMarginsTo(2);

	curr_profile_name=new (ELeave) CEikLabel;
	curr_profile_name->SetContainerWindowL(*this);
	curr_profile_name->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_name->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_profile_name->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	curr_profile_name->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_name->SetAllMarginsTo(2);
	
	curr_profile_speaker=new (ELeave) CEikLabel;
	curr_profile_speaker->SetContainerWindowL(*this);
	curr_profile_speaker->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_speaker->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_profile_speaker->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	curr_profile_speaker->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_speaker->SetAllMarginsTo(2);
	
	curr_profile_speaker_volume=new (ELeave) CEikLabel;
	curr_profile_speaker_volume->SetContainerWindowL(*this);
	curr_profile_speaker_volume->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_speaker_volume->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_profile_speaker_volume->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	curr_profile_speaker_volume->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray); 
	curr_profile_speaker_volume->SetAllMarginsTo(2);
	curr_profile_speaker_volume->SetTextL(_L(" "));
	
	curr_profile_vib=new (ELeave) CEikLabel;
	curr_profile_vib->SetContainerWindowL(*this);
	curr_profile_vib->SetFont(CEikonEnv::Static()->DenseFont());
	curr_profile_vib->SetEmphasis(CEikLabel::EFullEmphasis);
	curr_profile_vib->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	curr_profile_vib->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray); 
	curr_profile_vib->SetAllMarginsTo(2);
		
	user_active=new (ELeave) CEikLabel;
	user_active->SetContainerWindowL(*this);
	user_active->SetFont(CEikonEnv::Static()->DenseFont());
	user_active->SetAllMarginsTo(2);
	user_active->SetEmphasis(CEikLabel::EFullEmphasis);
	user_active->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
        user_active->OverrideColorL(EColorLabelHighlightFullEmphasis, dark_gray);

	temp.Zero();
	bt_nb_title = new (ELeave) CEikLabel;
	temp2 = iEikonEnv->AllocReadResourceL(R_BT_NB);
	temp.Append(temp2->Des());
	delete temp2; temp2 =0;
	bt_nb_title->SetTextL(temp);
	bt_nb_title->SetContainerWindowL(*this);
	bt_nb_title->SetFont(CEikonEnv::Static()->DenseFont());
	bt_nb_title->SetAllMarginsTo(2);
	bt_nb_title->SetEmphasis(CEikLabel::EFullEmphasis);
	bt_nb_title->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	bt_nb_title->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray);

	bt_nb_buddies = new (ELeave) CEikLabel;
	bt_nb_buddies->SetContainerWindowL(*this);
	bt_nb_buddies->SetFont(CEikonEnv::Static()->DenseFont());
	bt_nb_buddies->SetAllMarginsTo(2);
	bt_nb_buddies->SetEmphasis(CEikLabel::EFullEmphasis);
	bt_nb_buddies->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	bt_nb_buddies->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray);

	bt_nb_others = new (ELeave) CEikLabel;
	bt_nb_others->SetContainerWindowL(*this);
	bt_nb_others->SetFont(CEikonEnv::Static()->DenseFont());
	bt_nb_others->SetAllMarginsTo(2);
	bt_nb_others->SetEmphasis(CEikLabel::EFullEmphasis);
	bt_nb_others->OverrideColorL(EColorLabelTextEmphasis, KRgbBlack);
	bt_nb_others->OverrideColorL(EColorLabelHighlightFullEmphasis, light_gray);

	icon_speaker = new (ELeave) CEikImage();
	icon_vibra = new (ELeave) CEikImage();
	icon_buddies = new (ELeave) CEikImage();
	icon_others = new (ELeave) CEikImage();
	icon_user_activity = new (ELeave) CEikImage();
	
	

	if (iPresence)
	{
		TBool out_of_date = IsOutOfDate(iPresence->SendTimeStamp());
		
		temp.Zero();
		if (iPresence->LocInfo().iFlags & TLocInfo::EPrevious)
		{
			temp2 = iEikonEnv->AllocReadResourceL(R_PREVIOUS_LOCATION_TEMPLATE);
			CleanupStack::PushL(temp2);
			temp.Format(temp2->Des(), &(*(iPresence->LocInfo().iPrevious)), &(TimeSinceStamp(iPresence->LocInfo().iPUpdated)));
			prev_loc->SetTextL(temp);
			CleanupStack::Pop();
			delete temp2; temp2 = 0;
		}
		else
		{
			prev_loc->SetTextL(_L("?"));
		}
		
		temp.Zero();
		if (iPresence->LocInfo().iFlags & TLocInfo::ECurrent)
		{
			temp2 = iEikonEnv->AllocReadResourceL(R_CURRENT_LOCATION_TEMPLATE);
			CleanupStack::PushL(temp2);
			temp.Format(temp2->Des(), &(*(iPresence->LocInfo().iCurrent)), &(TimeSinceStamp(iPresence->LocInfo().iCUpdated)) );
			curr_loc->SetTextL(temp);
			CleanupStack::Pop();
			delete temp2; temp2 = 0;
		}
		else
		{
			curr_loc->SetTextL(_L("?"));
		}
		
		temp.Zero();
		curr_profile_name->SetTextL(iPresence->ProfileInfo().iProfileName);
		
		temp.Zero();
		if ( iPresence->ProfileInfo().iRingingType == CPresenceData::ERingingTypeSilent )
		{
			temp2 = iEikonEnv->AllocReadResourceL(R_SPEAKER);
			temp.Append(temp2->Des());
                        temp.Append(_L(" "));
			delete temp2; temp2 = 0;
			temp2 = iEikonEnv->AllocReadResourceL(R_OFF);
			temp.Append(temp2->Des());
			delete temp2; temp2 = 0;
			curr_profile_speaker->SetTextL(temp);

			CleanupStack::PushL(icon_speaker);
			icon =0;
			if (out_of_date)
			{
				icon = GetIconIndex(EMbmContextcommonSpeaker_off_grey);
			}
			else
			{
				icon = GetIconIndex(EMbmContextcommonSpeaker_off);
			}
			icon_speaker->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
			CleanupStack::Pop();
		}
		else
		{
			temp2 = iEikonEnv->AllocReadResourceL(R_SPEAKER);
			temp.Append(temp2->Des());
			temp.Append(_L(" "));
			delete temp2; temp2 = 0;
			temp2 = iEikonEnv->AllocReadResourceL(R_SP_VOLUME);
			temp.AppendFormat(temp2->Des(), iPresence->ProfileInfo().iRingingVolume);
			curr_profile_speaker->SetTextL(temp);
			delete temp2; temp2 = 0;
						
			CleanupStack::PushL(icon_speaker);
			icon = 0;
			if (out_of_date)
			{
				icon = GetIconIndex(EMbmContextcommonSpeaker_on_grey);
			}
			else
			{
				icon = GetIconIndex(EMbmContextcommonSpeaker_on);
			}
			icon_speaker->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
			CleanupStack::Pop();
		}
			
		temp.Zero();
		temp2 = iEikonEnv->AllocReadResourceL(R_VIBRATOR);
		temp.Append(temp2->Des());
		temp.Append(_L(" "));
		delete temp2; temp2 = 0;
		if ( iPresence->ProfileInfo().iVibra )
		{
			temp2 = iEikonEnv->AllocReadResourceL(R_ON);
			temp.Append(temp2->Des());
			delete temp2; temp2 = 0;

			CleanupStack::PushL(icon_vibra);
			icon = 0;
			if (out_of_date)
			{
				icon = GetIconIndex(EMbmContextcommonVibrator_on_grey);
			}
			else
			{
				icon = GetIconIndex(EMbmContextcommonVibrator_on);
			}
			icon_vibra->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
			CleanupStack::Pop();
		}
		else
		{
			temp2 = iEikonEnv->AllocReadResourceL(R_OFF);
			temp.Append(temp2->Des());
			delete temp2; temp2 = 0;
			
			CleanupStack::PushL(icon_vibra);
			icon = 0;
			if (out_of_date)
			{
				icon = GetIconIndex(EMbmContextcommonVibrator_off_grey);
			}
			else
			{
				icon = GetIconIndex(EMbmContextcommonVibrator_off);
			}
			icon_vibra->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
			CleanupStack::Pop();
		}
		curr_profile_vib->SetTextL(temp);
		
		temp.Zero();
		if (out_of_date)
		{
			temp2 = iEikonEnv->AllocReadResourceL(R_OUT_OF_DATE);
			temp.Format(temp2->Des(), &(TimeSinceStamp(iPresence->SendTimeStamp(), 10)));
			delete temp2; temp2 = 0;
			user_active->SetTextL(temp);
			user_active->OverrideColorL(EColorLabelTextEmphasis, KRgbRed);
		}
		else
		{
			if (iPresence->ActivityInfo().iMode == TActivityInfo::EActive )
			{
				temp2 = iEikonEnv->AllocReadResourceL(R_USER_ACTIVE_TEMPLATE);
				temp.Append(temp2->Des());
				delete temp2; temp2 = 0;
				user_active->SetTextL(temp);
			}
			else
			{
				temp2 = iEikonEnv->AllocReadResourceL(R_USER_INACTIVE_TEMPLATE);
				temp.Format(temp2->Des(), &(TimeSinceStamp(iPresence->ActivityInfo().iUpdated, 2)));
				delete temp2; temp2 = 0;
				user_active->SetTextL(temp);
			}
		}

		temp.Zero();
		temp2 = iEikonEnv->AllocReadResourceL(R_BUDDIES_TEMPLATE);
                temp.Format(temp2->Des(), iPresence->NeighbourhoodInfo().iBuddies);
		delete temp2; temp2=0;
		bt_nb_buddies->SetTextL(temp);

		temp.Zero();
		temp2 = iEikonEnv->AllocReadResourceL(R_OTHERS_TEMPLATE);
		temp.Format(temp2->Des(), iPresence->NeighbourhoodInfo().iOtherPhones);
		delete temp2; temp2 =0;
		bt_nb_others->SetTextL(temp);
		
		icon = 0;
		temp.Zero();
		switch (iPresence->NeighbourhoodInfo().iBuddies)
		{
			case 0:
				icon = 0;
				break;
			case 1:
				if (out_of_date) {
					icon = GetIconIndex(EMbmContextcommonBuddy1_grey);
				} else {
					icon = GetIconIndex(EMbmContextcommonBuddy1);
				}
				break;
			case 2:
				if (out_of_date) {
					icon = GetIconIndex(EMbmContextcommonBuddy2_grey);
				} else {
					icon = GetIconIndex(EMbmContextcommonBuddy2);
				}
				break;
			case 3:
				if (out_of_date) {
					icon = GetIconIndex(EMbmContextcommonBuddy3_grey);
				} else {
					icon = GetIconIndex(EMbmContextcommonBuddy3);
				}
				break;
			default:
				if (out_of_date) {
					icon = GetIconIndex(EMbmContextcommonBuddy4_grey);
				} else {
					icon = GetIconIndex(EMbmContextcommonBuddy4);
				}
				break;
		}
		icon_buddies->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
		if (icon == 0) icon_buddies->MakeVisible(EFalse);

		icon = 0;
		switch (iPresence->NeighbourhoodInfo().iOtherPhones)
		{
			case 0:
				icon = 0;
				break;
			case 1:
				if (out_of_date) {
					icon = GetIconIndex(EMbmContextcommonOther1_grey);
				} else {
					icon = GetIconIndex(EMbmContextcommonOther1);
				}
				break;
			case 2:
				if (out_of_date) {
					icon = GetIconIndex(EMbmContextcommonOther2_grey);
				} else {
					icon = GetIconIndex(EMbmContextcommonOther2);
				}
				break;
			case 3:
				if (out_of_date) {
					icon = GetIconIndex(EMbmContextcommonOther3_grey);
				} else {
					icon = GetIconIndex(EMbmContextcommonOther3);
				}
				break;
			default:
				if (out_of_date) {
					icon = GetIconIndex(EMbmContextcommonOther4_grey);
				} else {
					icon = GetIconIndex(EMbmContextcommonOther4);
				}
				break;
		}
		icon_others->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
		if (icon == 0) icon_others->MakeVisible(EFalse);

		icon = 0;
		if (iPresence->ActivityInfo().iMode == TActivityInfo::EActive )
		{
			if (out_of_date) {
				icon = GetIconIndex(EMbmContextcommonUser_inactive);
			} else {
				icon = GetIconIndex(EMbmContextcommonUser_active);
			}
		}
		else if (iPresence->ActivityInfo().iMode == TActivityInfo::EIdle)
		{
			if (out_of_date) {
				icon = GetIconIndex(EMbmContextcommonUser_inactive);
			} else {

				TTimeIntervalMinutes minutes; TTime now; now.HomeTime();
				now.MinutesFrom(iPresence->ActivityInfo().iUpdated, minutes);
				if (minutes.Int() <= 10) {
					icon = GetIconIndex(EMbmContextcommonUser_inactive_lvl_1);
				} else if (minutes.Int() <= 60) {
					icon = GetIconIndex(EMbmContextcommonUser_inactive_lvl_2);
				} else if (minutes.Int() <= 240) {
					icon = GetIconIndex(EMbmContextcommonUser_inactive_lvl_3);
				} else {
					icon = GetIconIndex(EMbmContextcommonUser_inactive);
				}
			}
		}
		icon_user_activity->CreatePictureFromFileL(GetIconMbm(icon), GetIconBitmap(icon), GetIconMask(icon));
		if (icon == 0) icon_others->MakeVisible(EFalse);
	}
	else
	{
		temp.Zero();
		prev_loc->SetTextL(KQuestion);
		curr_loc->SetTextL(KQuestion);
		
		curr_profile_name->SetTextL(KQuestion);
		curr_profile_speaker->SetTextL(KQuestion);
		curr_profile_vib->SetTextL(KQuestion);
		temp2 = iEikonEnv->AllocReadResourceL(R_NO_INFO);
		temp.Append(temp2->Des());
		delete temp2; temp2 = 0;
		user_active->SetTextL(temp);
		user_active->OverrideColorL(EColorLabelTextEmphasis, KRgbRed);

		bt_nb_buddies->SetTextL(KQuestion);
		bt_nb_others->SetTextL(KQuestion);

		CleanupStack::PushL(icon_vibra);
		icon_vibra->CreatePictureFromFileL(GetIconMbm(0), GetIconBitmap(0), GetIconMask(0));
		icon_vibra->MakeVisible(EFalse);
		CleanupStack::Pop();

		CleanupStack::PushL(icon_speaker);
		icon_speaker->CreatePictureFromFileL(GetIconMbm(0), GetIconBitmap(0), GetIconMask(0));
		icon_speaker->MakeVisible(EFalse);
		CleanupStack::Pop();
		
		CleanupStack::PushL(icon_buddies);
		icon_buddies->CreatePictureFromFileL(GetIconMbm(0), GetIconBitmap(0), GetIconMask(0));
		icon_buddies->MakeVisible(EFalse);
		CleanupStack::Pop();

		CleanupStack::PushL(icon_others);
		icon_others->CreatePictureFromFileL(GetIconMbm(0), GetIconBitmap(0), GetIconMask(0));
		icon_others->MakeVisible(EFalse);
		CleanupStack::Pop();

		CleanupStack::PushL(icon_user_activity);
		icon_user_activity->CreatePictureFromFileL(GetIconMbm(0), GetIconBitmap(0), GetIconMask(0));
		icon_user_activity->MakeVisible(EFalse);
		CleanupStack::Pop();

	}
	SetPositionOfComponents();
	SetSizeOfComponents();
	SetRect(aRect);
	ActivateL();	
}

void CPresenceDetailContainer::HandleScrollEventL(CEikScrollBar* /*aScrollBar*/, TEikScrollEvent /*aEventType*/)
{
	//no impl
}


void CPresenceDetailContainer::CreateScrollBars()
{
	iScrollSpan = 4;
	iNbPosition = 0;
	iThumbPosition = 0;
	iCurrentPos = 0;

	iModel = TEikScrollBarModel(iScrollSpan, iNbPosition, iThumbPosition);
	iSBFrame = new (ELeave) CEikScrollBarFrame(this, this, ETrue);
	iSBFrame->SetScrollBarVisibilityL(CEikScrollBarFrame::EOn, CEikScrollBarFrame::EAuto);
	iSBFrame->SetScrollBarManagement(CEikScrollBar::EVertical, CEikScrollBarFrame::EFloating);
	iSBFrame->Tile(&iModel);
	iSBFrame->DrawScrollBarsNow();
}

void CPresenceDetailContainer::MoveUp()
{
	int i=0;
	for (i=0; i<this->CountComponentControls();i++)
	{
		CCoeControl * control = this->ComponentControl(i);
		TPoint ori_pos = control->Position();
		ori_pos.iY += 10;
		control->SetPosition(ori_pos);
	}
	DrawNow();
}

void CPresenceDetailContainer::MoveDown()
{
	int i=0;
	for (i=0; i<this->CountComponentControls();i++)
	{
		CCoeControl * control = this->ComponentControl(i);
		TPoint ori_pos = control->Position();
		ori_pos.iY -= 10;
		control->SetPosition(ori_pos);
	}
	DrawNow();
}

void CPresenceDetailContainer::SetPositionOfComponents()
{
	//7650 screen size = W:176 H:208
	prev_loc_title->SetPosition(TPoint(0, 0));
	prev_loc->SetPosition(TPoint(83,0));

	curr_loc_title->SetPosition(TPoint(0,30));
	curr_loc->SetPosition(TPoint(83, 30));

	curr_profile_title->SetPosition(TPoint(0, 60));
	curr_profile_name->SetPosition(TPoint(83, 60));

	icon_speaker->SetPosition(TPoint(60, 74));
	curr_profile_speaker->SetPosition(TPoint(83, 75));
	curr_profile_speaker_volume->SetPosition(TPoint(88, 109));  // empty label, just for the color
	icon_vibra->SetPosition(TPoint(60, 91));
	curr_profile_vib->SetPosition(TPoint(83, 92));

	bt_nb_title->SetPosition(TPoint(0, 109));
	bt_nb_buddies->SetPosition(TPoint(82, 126));
	bt_nb_others->SetPosition(TPoint(82, 143));
	icon_buddies->SetPosition(TPoint(62, 126));
	icon_others->SetPosition(TPoint(62, 143));

	user_active->SetPosition(TPoint(16, 159));
	icon_user_activity->SetPosition(TPoint(0, 159));
}


void CPresenceDetailContainer::SetSizeOfComponents()
{
	//7650 screen size = W:176 H:208 

	prev_loc_title->SetSize(TSize(88,30));
	prev_loc->SetSize(TSize(93,30));
	
	curr_loc_title->SetSize( TSize(88,30));
	curr_loc->SetSize( TSize(93,30));

	curr_profile_title->SetSize(TSize(88,49));
	curr_profile_name->SetSize(TSize(93,15));

	icon_speaker->SetSize(TSize(16,16));
	curr_profile_speaker->SetSize(TSize(103,17));
	curr_profile_speaker_volume->SetSize(TSize(88, 17)); // empty label just for the color
	icon_vibra->SetSize(TSize(16,16));
	curr_profile_vib->SetSize(TSize(103,17));

	user_active->SetSize(TSize(176,17));

	bt_nb_title->SetSize(TSize(89,50));
	bt_nb_buddies->SetSize(TSize(104,17));
	bt_nb_others->SetSize( TSize(104,17));
	icon_buddies->SetSize(TSize(18,16));
	icon_others->SetSize(TSize(18,16));
	icon_user_activity->SetSize(TSize(15,16));
}

void CPresenceDetailContainer::SizeChanged()
{
	SetSizeOfComponents();
}

TInt CPresenceDetailContainer::CountComponentControls() const
{
	return 18;
}

TKeyResponse CPresenceDetailContainer::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType)
{
	if (aKeyEvent.iCode==EKeyDownArrow && aType==EEventKey)
	{
		if (iCurrentPos < iScrollSpan-1)
		{
			iCurrentPos++;
			iSBFrame->MoveThumbsBy(0, 1);
			MoveDown();
		}
		return EKeyWasConsumed;
	}
	if (aKeyEvent.iCode==EKeyUpArrow && aType==EEventKey)
	{
		if (iCurrentPos > 0)
		{
			iCurrentPos--;
			iSBFrame->MoveThumbsBy(0, -1);
			MoveUp();
		}
		return EKeyWasConsumed;
	}
	if ( (aKeyEvent.iCode==EKeyLeftArrow) || (aKeyEvent.iCode==EKeyRightArrow) )
	{
		return EKeyWasConsumed;
	}
	return EKeyWasNotConsumed;
}



CCoeControl* CPresenceDetailContainer::ComponentControl(TInt aIndex) const
{

	switch (aIndex)
	{
		//case 0:  return title;
		case 0:  return prev_loc_title;
		case 1:  return prev_loc;
		case 2:  return curr_loc_title;
		case 3:  return curr_loc;
		case 4:  return curr_profile_title;
		case 5:  return curr_profile_name;
		case 6:  return curr_profile_speaker;
		case 7:  return curr_profile_speaker_volume;
		case 8:  return curr_profile_vib;
		case 9:  return user_active;
		case 10: return bt_nb_title;
		case 11: return bt_nb_buddies;
		case 12: return bt_nb_others;
		case 13: return icon_speaker;
		case 14: return icon_vibra;
		case 15: return icon_buddies;
		case 16: return icon_others;
		case 17: return icon_user_activity;

		default: return 0;
	}
}

void CPresenceDetailContainer::Draw(const TRect& aRect) const
{
	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	TRgb dark_gray = TRgb(210,210,210);
	gc.SetBrushColor(dark_gray);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

CPresenceDetailViewImpl::CPresenceDetailViewImpl()
{
}

void CPresenceDetailViewImpl::ConstructL()
{
#ifndef __WINS__
	TFileName resfile=_L("c:\\System\\data\\contextcommon.rsc");
#else
	TFileName resfile=_L("z:\\System\\data\\contextcommon.rsc");
#endif
	BaflUtils::NearestLanguageFile(iEikonEnv->FsSession(), resfile); //for localization
	TRAPD(err, iResource=iEikonEnv->AddResourceFileL(resfile));
	User::LeaveIfError(err);

	BaseConstructL( R_PRESENCEDETAIL_VIEW );
}

TUid CPresenceDetailViewImpl::Id() const
{
	return KPresenceDetailView;
}

void CPresenceDetailViewImpl::HandleCommandL(TInt /*aCommand*/)
{
	ActivateViewL(iPrevView);
}

void CPresenceDetailViewImpl::DoActivateL(const TVwsViewId& aPrevViewId,
	TUid /*aCustomMessageId*/,
	const TDesC8& /*aCustomMessage*/)
{
	iPrevView=aPrevViewId;
	if (!iContainer) {
		iContainer=new (ELeave) CPresenceDetailContainer(iName, iPresence);
		iContainer->ConstructL(ClientRect());
		iContainer->SetMopParent(this);
		iContainer->CreateScrollBars();
	
		AppUi()->AddToStackL( *this, iContainer );
        } 
}

void CPresenceDetailViewImpl::DoDeactivate()
{
	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
	iContainer = 0;
}

CPresenceDetailViewImpl::~CPresenceDetailViewImpl()
{
	if (iResource) iEikonEnv->DeleteResourceFile(iResource);
	delete iContainer;
	
}


void CPresenceDetailViewImpl::SetData(const TDesC& Name, const MPresenceData* PresenceData)
{
	iName=Name;
	iPresence=PresenceData;
}

