/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "store.h"

CReclaimManager::CReclaimManager()
{
}

void CReclaimManager::ConstructL()
{
	iList=CList<MReclaimable*>::NewL();
}

CReclaimManager* CReclaimManager::NewL()
{
	auto_ptr<CReclaimManager> ret(new (ELeave) CReclaimManager);
	ret->ConstructL();
	return ret.release();
}

void CReclaimManager::AddManagedL(MReclaimable* Managed)
{
	iList->AppendL(Managed);
	Managed->SetCurrentStamp(iCurrentStamp);
}

CReclaimManager::~CReclaimManager()
{
	delete iList;
}

void CReclaimManager::SetTimeStamp(uint16 Stamp)
{
	iCurrentStamp=Stamp;
	CList<MReclaimable*>::Node* i=iList->iFirst;
	while (i) {
		i->Item->SetCurrentStamp(Stamp);
		i=i->Next;
	}
}

void CReclaimManager::TriggerReclaimL(uint16 Upto)
{
	CList<MReclaimable*>::Node* i=iList->iFirst;
	while (i) {
		i->Item->ReclaimL(Upto);
		i=i->Next;
	}
}
