/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "xmlbuf.h"
#include "symbian_auto_ptr.h"

EXPORT_C CXmlBuf16* CXmlBuf16::NewL(TInt initial_size)
{
	auto_ptr<CXmlBuf16> ret(new (ELeave) CXmlBuf16);
	ret->ConstructL(initial_size);
	return ret.release();
}

EXPORT_C void CXmlBuf16::BeginElement(const TDesC& name, const MDesCArray* const attributes)
{
	AppendL(_L("<"));
	AppendL(name);
	if (attributes) {
		for (int i=0; i<attributes->MdcaCount(); i++) {
			AppendL(_L(" "));
			AppendL(attributes->MdcaPoint(i++));
			AppendL(_L("=\""));
			Characters(attributes->MdcaPoint(i), true);
			AppendL(_L("\""));
		}
	}
	AppendL(_L(">"));
}

EXPORT_C void CXmlBuf16::EndElement(const TDesC& name)
{
	AppendL(_L("</"));
	AppendL(name);
	AppendL(_L(">"));
}

EXPORT_C void CXmlBuf16::Characters(const TDesC& buf, bool escape_quote)
{
	for (int i=0; i<buf.Length(); i++) {
		if (buf[i]=='<') {
			AppendL(_L("&lt;"));
		} else if (buf[i]=='&') {
			AppendL(_L("&amp;"));
		} else if (buf[i]=='"' && escape_quote) {
			AppendL(_L("&quot;"));
		} else {
			AppendL( TPtrC( &(buf[i]), 1) );
		}
	}
}

EXPORT_C void CXmlBuf16::Leaf(const TDesC& name, const TDesC& buf, const MDesCArray* const attributes)
{
	BeginElement(name, attributes);
	Characters(buf);
	EndElement(name);
}

CXmlBuf16::CXmlBuf16() 
{
}

void CXmlBuf16::ConstructL(TInt initial_size)
{
	iBuf=HBufC::NewL(initial_size);
}

void CXmlBuf16::AppendL(const TDesC& buf)
{
	while (iBuf->Des().Length()+buf.Length() > iBuf->Des().MaxLength()) {
		iBuf=iBuf->ReAllocL(iBuf->Des().MaxLength()*2);
	}
	iBuf->Des().Append(buf);
}

EXPORT_C const TDesC& CXmlBuf16::Buf() const
{
	return *iBuf;
}

EXPORT_C void CXmlBuf16::Zero()
{
	iBuf->Des().Zero();
}

EXPORT_C CXmlBuf16::~CXmlBuf16()
{
	delete iBuf;
}

EXPORT_C CXmlBuf8* CXmlBuf8::NewL(TInt initial_size)
{
	auto_ptr<CXmlBuf8> ret(new (ELeave) CXmlBuf8);
	ret->ConstructL(initial_size);
	return ret.release();
}

EXPORT_C void CXmlBuf8::BeginElement(const TDesC8& name, const MDesC8Array* const attributes)
{
	AppendL(_L8("<"));
	AppendL(name);
	if (attributes) {
		for (int i=0; i<attributes->MdcaCount(); i++) {
			AppendL(_L8(" "));
			AppendL(attributes->MdcaPoint(i++));
			AppendL(_L8("=\""));
			Characters(attributes->MdcaPoint(i), true);
			AppendL(_L8("\""));
		}
	}
	AppendL(_L8(">"));
}


EXPORT_C void CXmlBuf8::EndElement(const TDesC8& name)
{
	AppendL(_L8("</"));
	AppendL(name);
	AppendL(_L8(">"));
}

EXPORT_C void CXmlBuf8::Characters(const TDesC8& buf, bool escape_quote)
{
	for (int i=0; i<buf.Length(); i++) {
		if (buf[i]=='<') {
			AppendL(_L8("&lt;"));
		} else if (buf[i]=='&') {
			AppendL(_L8("&amp;"));
		} else if (buf[i]=='"' && escape_quote) {
			AppendL(_L8("&quot;"));
		} else {
			AppendL( TPtrC8( &(buf[i]), 1) );
		}
	}
}

EXPORT_C void CXmlBuf8::Characters(const TDesC16& buf, bool escape_quote)
{
	for (int i=0; i<buf.Length(); i++) {
		if (buf[i]=='<') {
			AppendL(_L8("&lt;"));
		} else if (buf[i]=='&') {
			AppendL(_L8("&amp;"));
		} else if (buf[i]=='"' && escape_quote) {
			AppendL(_L8("&quot;"));
		} else {
			AppendL( buf.Mid(i, 1));
		}
	}
}

EXPORT_C void CXmlBuf8::Leaf(const TDesC8& name, const TDesC16& buf, const MDesC8Array* const attributes)
{
	BeginElement(name, attributes);
	Characters(buf);
	EndElement(name);
}

EXPORT_C void CXmlBuf8::Leaf(const TDesC8& name, const TDesC8& buf, const MDesC8Array* const attributes)
{
	BeginElement(name, attributes);
	Characters(buf);
	EndElement(name);
}

CXmlBuf8::CXmlBuf8() 
{
}

void CXmlBuf8::ConstructL(TInt initial_size)
{
	iBuf=HBufC8::NewL(initial_size);
}

void CXmlBuf8::AppendL(const TDesC8& buf)
{
	while (iBuf->Des().Length()+buf.Length() > iBuf->Des().MaxLength()) {
		iBuf=iBuf->ReAllocL(iBuf->Des().MaxLength()*2);
	}
	iBuf->Des().Append(buf);
}

void CXmlBuf8::AppendL(const TDesC16& buf)
{
	while (iBuf->Des().Length()+buf.Length() > iBuf->Des().MaxLength()) {
		iBuf=iBuf->ReAllocL(iBuf->Des().MaxLength()*2);
	}
	iBuf->Des().Append(buf);
}

EXPORT_C const TDesC8& CXmlBuf8::Buf() const
{
	return *iBuf;
}

EXPORT_C void CXmlBuf8::Zero()
{
	iBuf->Des().Zero();
}

EXPORT_C CXmlBuf8::~CXmlBuf8()
{
	delete iBuf;
}