#ifndef CONTEXTCONTACTSDETAILCONTAINER_H
#define CONTEXTCONTACTSDETAILCONTAINER_H

#include <coecntrl.h>
#include <cpbkcontactitem.h> 
#include <cpbkcontactengine.h> 
#include <eikfrlbd.h> 
#include <sendui.h>
#include <eikmenub.h>
#include <akniconarray.h>
#include <aknview.h>
 
class CContextContactsDetailContainer : public CCoeControl, MCoeControlObserver, public MEikListBoxObserver
    {
    public: 
	void ConstructL(const TRect& aRect, CPbkContactItem * item, CAknIconArray * aIconlist, CAknView * view );
        ~CContextContactsDetailContainer();

    public:
	    TInt  get_current_idx();
	    TInt  get_current_item_idx();
	    TBool IsCurrentPhoneNumber();
	    TBool IsCurrentMMS();
	    TBool IsCurrentWebAddress();
	    TInt  ItemCount();

    public: 
	    TBool HasPhoneNumber();
	    TBool HasMmsAddress();
	    TBuf<255> GetWebAddress();
	    TBool HasEmailAddress();

    public:
	    void refresh(CPbkContactItem * item);
	    void populate_listbox();

    private: 
        void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
	void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
	TKeyResponse OfferKeyEventL(const TKeyEvent &, TEventCode);
        
    private:        
	CPbkContactItem * aItem;
	CDesC16ArrayFlat * iItemArray;
	CArrayFixFlat<TPbkFieldId> * iIdxArray;
	CEikFormattedCellListBox* iListbox;
	CAknIconArray * iIconlist;
	CAknView * aView;
};
#endif

