/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#ifndef CB_PHONEHELPER_H_INCLUDED
#define CB_PHONEHELPER_H_INCLUDED 1

#include "etel.h"
#include "checkedactive.h"
#include <sendui.h>
#include <badesca.h>
#include <cpbkcontactengine.h> 
#include "app_context.h"
#include "phonebook.h"
#include "file_output_base.h"
#include <cpbkfieldinfo.h>

class phonehelper : public CCheckedActive, MContextBase {
public:
	phonehelper(phonebook_i& book, Cfile_output_base * log) : CCheckedActive(EPriorityIdle, _L("phonehelper")), aBook(book), aLog(log) {}
	void ConstructL();
	phonehelper();
	~phonehelper();
	RCall::TStatus line_status();
	TInt make_call(const TDesC& number);

public:
	TBool mailbox_defined();
	void send_sms(CDesCArrayFlat* recip, CDesCArrayFlat* alias);
	void send_mms(CDesCArrayFlat* recip, CDesCArrayFlat* alias);
	void send_email(CDesCArrayFlat* recip, CDesCArrayFlat* alias);
	void send_as(TUid mtmUid, CArrayFixFlat<TInt> * c);

public:
	void show_editor(TInt contact_id, bool duplicate, TInt focus_field_index = -1, CPbkFieldInfo * fieldInfo = 0, const TDesC& no = KNullDesC);

private:
	virtual void DoCancel();
	virtual void CheckedRunL(); 

private:
	RLine line;
	RPhone phone;
	RTelServer server;
	RCall call;
	CSendAppUi * iSendAppUi;
	phonebook_i& aBook;
	Cfile_output_base * aLog;
};

#endif
