/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#ifndef SETTINGSVIEW_H
#define SETTINGSVIEW_H

// INCLUDES
#include <aknview.h>
#include "phonebook.h"

#ifndef NULL
#define NULL 0
#endif

#include <aknsettingitemlist.h>
#include "app_context.h"

const TUid KSettingsViewId = {1002};

/* Quickly hacked class. Only one setting. can be extended with a cl_settings.h-like file to extend setting list as well as modularity!*/

class CCCSettingList: public CAknSettingItemList 
    {
    public:
        CAknSettingItem* CreateSettingItemL( TInt identifier );
	void SetListData();
	void UpdateSettings();
	TAny*		iData[1];
	~CCCSettingList();
    private:
	CAknSettingItem	*iItems[1];
    };

class CSettingsView : public CAknView, public MContextBase
    {
    public: 
	static CSettingsView* NewL(MApp_context& Context, phonebook& book);
        ~CSettingsView();
    public: 
        TUid Id() const;
        void HandleCommandL(TInt aCommand);
        void HandleClientRectChange();

    private:
	CSettingsView(MApp_context& Context, phonebook& book);
        void ConstructL();
        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId,
            const TDesC8& aCustomMessage);
        void DoDeactivate();

    private: 
        CCCSettingList* iListBox;
	TVwsViewId iPrevViewId;
	phonebook& aBook;
    };
#endif

