#include "ContextContactsAppUi.h"
#include "ContextContactsView.h"
#include "ContextContactsContainer.h"
#include "ContextContactsView2.h"
#include <ContextContacts.rsg>
#include "contextcontacts.hrh"

#include <avkon.hrh>
#include "icons.h"

#include "db.h"
#include <RPbkViewResourceFile.h>
#include <CPbkContactEditorDlg.h>
#include <CPbkContactEngine.h>
#include <CPbkSelectFieldDlg.h>
#include <CPbkContactItem.h>
#include <apgcli.h>
#include <eikmenup.h>
#include <CPbkViewState.h>
#include <bautils.h>
#include <aknmessagequerydialog.h> 
#include <flogger.h>
#include <EikDll.h>
#include "contextcontactsapp.h"

//#define COUNTING 1

const TInt KUidToBackgroundValue=0x2004;
const TUid KUidToBackground={KUidToBackgroundValue};


void CContextContactsAppUi::ConstructL()
{	
	CALLSTACKITEM(_L("CContextContactsAppUi::ConstructL"));

	iWait=CTimeOut::NewL(*this);
	iWaitingOps=CList<TCallBack>::NewL();

	BaseConstructL();

#ifdef COUNTING
	TBuf<50> buf;
	TUint count = User::TickCount();
#endif

	// LOGGING ON or OFF
	TBool logging=ETrue;
	Settings().GetSettingL(18, logging);
	iLog=Cfile_output_base::NewL(AppContext(), _L("book_log"), logging, false);
	if (!logging && iLog) iLog->paused=true;

	if (iLog) 
	{
		iLog->write_time();
		iLog->write_to_output(_L("Starting Contacts"));
		iLog->write_nl();
	}
#ifdef COUNTING
	count = User::TickCount();
#endif

#ifndef __WINS__
	// works only for context_log on the emulator
	{ TRAPD(errs, StartStarterL(_L("contacts"), KUidContextContacts, true)); }
#endif

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("Start starter:%d"), User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iJabberDb=CDb::NewL(AppContext(), _L("JABBER"), EFileWrite|EFileShareAny);
	iJabberData=CJabberData::NewL(AppContext(), *iJabberDb);

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("Create jabber Db/Data:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iPresenceHolder=CPresenceHolder::NewL(*iJabberData);

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("PresenceHolder:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iBook=new (ELeave) phonebook(AppContext(), *iJabberData, *iPresenceHolder);
	iBook->ConstructL();

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("book:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iPhoneHelper = new (ELeave) phonehelper(*iBook, iLog);
	iPhoneHelper->ConstructL();

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("iPhoneHelper:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	if (iPresenceHolder) iPresenceHolder->AddListener(iBook);
	if (iPresenceHolder) iPresenceHolder->AddListener(this);

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("presenceHolder addList:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iPresenceUpdater = new (ELeave) CPresenceUpdater(*iBook);
	iPresenceUpdater->ConstructL();

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("presenceUpdater:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	// for phonebook dialogs
	iResource_files=new (ELeave) CArrayFixFlat<TInt>(5);
	TFileName resfile=_L("z:\\System\\data\\PBKVIEW.RSC");
	BaflUtils::NearestLanguageFile(iEikonEnv->FsSession(), resfile); //for localization
	iResource_files->AppendL(iEikonEnv->AddResourceFileL(resfile));

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("Read reFile:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	CEikStatusPane* sp = StatusPane();
	iNaviPane = (CAknNavigationControlContainer*)sp->ControlL( 
        TUid::Uid(EEikStatusPaneUidNavi));
	iDecoratedTabGroup = iNaviPane->ResourceDecorator();
	if (iDecoratedTabGroup)
        {
		iTabGroup = (CAknTabGroup*) iDecoratedTabGroup->DecoratedControl();
        }
	iNaviPane->PushL(*iDecoratedTabGroup);

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("navipane:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iIconlist = new (ELeave) CAknIconArray(30);
	TRAPD(icon_err, LoadIcons(iIconlist));
	if (icon_err!=KErrNone) {
		TBuf<30> msg=_L("error ");
		msg.AppendNum(icon_err);
		msg.Append(_L(" "));
		HBufC* stack=AppContext().GetFormattedCallStack(_L("AppUi"));
		if (iLog) {
			iLog->write_time();
			iLog->write_to_output(msg);
			iLog->write_to_output(*stack);
			iLog->write_nl();
		}
		delete stack;
		User::Leave(icon_err);
	}


#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("icons:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iContactsView = new (ELeave) CContextContactsView(*iJabberData, iLog, iBook, iIconlist, *iPhoneHelper);
	CleanupStack::PushL( iContactsView );
	iContactsView->ConstructL();
	AddViewL( iContactsView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();    

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("view contacts:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iGroupsView = new (ELeave) CContextContactsView2;
	CleanupStack::PushL( iGroupsView );
	iGroupsView->ConstructL();
	AddViewL( iGroupsView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();   

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("view groups:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	iContactDetailView = new (ELeave) CContextContactsDetailView(*iPhoneHelper, iIconlist);
	CleanupStack::PushL( iContactDetailView );
	iContactDetailView->ConstructL();
	AddViewL( iContactDetailView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();  

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("view detail:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	auto_ptr<CPresenceDetailView> detailview(CPresenceDetailView::NewL());
	AddViewL(detailview.get());
	iPresenceDetailView=detailview.release();

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("view presence:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	auto_ptr<CSettingsView> iSettingsView(CSettingsView::NewL(AppContext(), *iBook));
	AddViewL(iSettingsView.get());
	iSettingsView.release();

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("view settings:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif

	SetDefaultViewL(*iContactsView);

	iEikonEnv->AddForegroundObserverL(*this);

#ifdef COUNTING
	iLog->write_time();
	buf.Format(_L("set default:%d"),User::TickCount() - count );
	iLog->write_to_output(buf);
	iLog->write_nl();
	count = User::TickCount();
#endif
}

CContextContactsAppUi::~CContextContactsAppUi()
{
	CALLSTACKITEM(_L("CContextContactsAppUi::~CContextContactsAppUi"));

	if (iLog) 
	{
		iLog->write_time();
		iLog->write_to_output(_L("Closing Contacts"));
		iLog->write_nl();
	}
	delete iWaitingOps;
	delete iWait;

	iContactsView->before_exit();

	iEikonEnv->RemoveForegroundObserver(*this);
	for (int i=0; i<iResource_files->Count(); i++) {
		iEikonEnv->DeleteResourceFile((*iResource_files)[i]);
	}
	delete iResource_files;
	delete iPhoneHelper;

     	delete iLog;
	delete iBook;
	delete iPresenceHolder;
	delete iPresenceUpdater;
	delete iJabberData;
	delete iJabberDb;
	delete iDecoratedTabGroup; 
	delete iIconlist;
}

TKeyResponse CContextContactsAppUi::HandleKeyEventL(
    const TKeyEvent& aKeyEvent, TEventCode /*aType*/)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::HandleKeyEventL"));

	if ( iTabGroup == NULL )
        {
		return EKeyWasNotConsumed;
        }
	TInt active = iTabGroup->ActiveTabIndex();
	TInt count = iTabGroup->TabCount();

	switch ( aKeyEvent.iCode )
        {
		case EKeyLeftArrow:
			if ( active > 0 )
			{
				active--;
				iTabGroup->SetActiveTabByIndex( active );
				ActivateLocalViewL(TUid::Uid(iTabGroup->TabIdFromIndex(active)));
			}
			break;
		case EKeyRightArrow:
			if( (active + 1) < count )
			{
				active++;
				iTabGroup->SetActiveTabByIndex( active );
				ActivateLocalViewL(TUid::Uid(iTabGroup->TabIdFromIndex(active)));
			}
			break;
		default:
			return EKeyWasNotConsumed;
			break;
        }
	return EKeyWasConsumed;
}

void CContextContactsAppUi::HandleCommandL(TInt aCommand)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::HandleCommandL"));

	switch ( aCommand )
	{
		case EEikCmdExit:
		{
			iContactsView->before_exit();
			Exit();
			break;
		}
		case EContextContactsCmdCrash:
		{
			TBuf<2> b; b.Append(_L("xxx"));
		}
		case EAknSoftkeyBack:
		{
			hide();
			break;
		}
		case EContextContactsCmdInfoMem:
		{
			TInt err, size, nb_contacts = -1;
			TInt64 free = -1;
                        TEntry entry;
			TVolumeInfo info;
			_LIT(KContactsDb, "c:\\System\\Data\\Contacts.cdb");
			
			nb_contacts = iBook->Count();
			err = Fs().Entry(KContactsDb, entry);
			if (err == KErrNone) size = entry.iSize;
			err = Fs().Volume(info);
			if (err == KErrNone) free = info.iFree;

			TReal x = size/1024;
			TReal y = (free/1024).GetTReal();

			HBufC * header = CEikonEnv::Static()->AllocReadResourceL(R_CONTACTS_INFO_BUF);
			CleanupStack::PushL(header);
			TBuf<200> message;
			TRealFormat realFormat = TRealFormat(30, 0);
			//FIX ME: use resource
			message.AppendFormat(_L("%d contacts\n"), nb_contacts);
			message.AppendNum(x, realFormat);
			message.Append(_L(" kB used\n"));
			message.AppendNum(y, realFormat);
			message.Append(_L(" kB free\n"));
			          			
			CAknMessageQueryDialog * dlg = CAknMessageQueryDialog::NewL(message);
			CleanupStack::PushL(dlg);
			dlg->PrepareLC(R_CONTACTS_INFO);
			dlg->QueryHeading()->SetTextL(*header);
			CleanupStack::Pop(dlg);
			
			dlg->RunLD();
			CleanupStack::PopAndDestroy(1); //header
			break;
		}
		
		case EContextContactsCmdOpen:
		{
			CPbkViewState* pbkViewParam = CPbkViewState::NewLC(); 
			TInt contact_id = iContactsView->GetCurrentContactId(); 
			pbkViewParam->SetFocusedContactId( contact_id ); 
			HBufC8* paramBuf = pbkViewParam->PackLC();
			ActivateLocalViewL(KDetailViewId, CPbkViewState::Uid(), *paramBuf); 
			CleanupStack::PopAndDestroy(2); // paramBuf, pbkViewPara
			break;
		}
		case EContextContactsCmdSimDir:
		{
			TFileName appName=_L("z:\\System\\Apps\\SimDirectory\\SimDirectory.app");
			const TUid KSimDirUid = { 0x101F4CF6 }; 

			// FIXME : this calling of simdirectory doesn't work!
                        // CCoeAppUi::ActivateViewL(TVwsViewId(KSimDirUid, TUid::Uid(1)));
			CApaCommandLine* cmdLine=CApaCommandLine::NewLC();
			cmdLine->SetLibraryNameL(appName);
			//cmdLine->SetDocumentNameL(docName);
			cmdLine->SetCommandL(EApaCommandRunWithoutViews);
			RApaLsSession ls;
			User::LeaveIfError(ls.Connect());
			CleanupClosePushL(ls);
			User::LeaveIfError(ls.StartApp(*cmdLine));
			CleanupStack::PopAndDestroy(2); // ls and cmdLine
			break;
		}

		case EContextContactsCmdSettings:
		{
			//ActivateLocalViewL(KSettingsViewId);
			break;
		}
		default:
			break;      
        }
}

void CContextContactsAppUi::hide()
{
	CALLSTACKITEM(_L("CContextContactsAppUi::hide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	
	TApaTask task(wsSession);
	TInt id = CEikonEnv::Static()->RootWin().Identifier();
	task.SetWgId(id);
		
	if ( wsSession.GetFocusWindowGroup() == id )
	{
		task.SendToBackground();
	}
}

void CContextContactsAppUi::HandleGainingForeground()
{
	CALLSTACKITEM(_L("CContextContactsAppUi::HandleGainingForeground"));

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("To foreground"));
		iLog->write_nl();
	}
	if (iPresenceUpdater) iPresenceUpdater->Start();
}

void CContextContactsAppUi::HandleLosingForeground()
{
	CALLSTACKITEM(_L("CContextContactsAppUi::HandleLosingForeground"));

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("To background\n"));
		iLog->write_nl();
	}
	if (iPresenceUpdater) iPresenceUpdater->Stop();

}

void CContextContactsAppUi::Notify(const TDesC& /*aMessage*/)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::Notify"));

	// no impl	
}

void CContextContactsAppUi::PresenceChangedL(TInt /*ContactId*/, MPresenceData &/*info*/)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::PresenceChangedL"));

	// no implementation
}

void CContextContactsAppUi::DisplayPresenceDetailsL(const TDesC& Name, const MPresenceData* PresenceData)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::DisplayPresenceDetailsL"));


	if (PresenceData == 0) return;
	iPresenceDetailView->SetData(Name, PresenceData);
	ActivateLocalViewL(KPresenceDetailView);
}


void CContextContactsAppUi::QueueOp(TCallBack Op, int AfterSeconds)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::QueueOp"));

	iWaitingOps->AppendL(Op);
	iWait->Wait(AfterSeconds);
}
void CContextContactsAppUi::expired(CBase*)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::expired"));

	TCallBack op=iWaitingOps->Pop();
	((*this).*op)();
	while (iWaitingOps->iFirst && iWaitingOps->Top()==op) iWaitingOps->Pop();
	if (iWaitingOps->iFirst) {
		iWait->Wait(1);
	}
}

void CContextContactsAppUi::ProcessMessageL(TUid aUid, const TDesC8& aParams)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::ProcessMessageL"));

	RFileLogger iLog;
	iLog.Connect();
	iLog.CreateLog(_L("test"),_L("c.txt"),EFileLoggingModeAppend);
	iLog.Write(_L("here"));
	iLog.CloseLog();
	iLog.Close();

	if (aUid==KUidToBackground) {
		QueueOp(&CContextContactsAppUi::hide);
	} else {
		CAknViewAppUi::ProcessMessageL(aUid,aParams);
	}
}

void CContextContactsAppUi::HandleWsEventL(const TWsEvent& aEvent,CCoeControl* aDestination)
{
	CALLSTACKITEM(_L("CContextContactsAppUi::HandleWsEventL"));


	if (aEvent.Type() == 999)
	{
		QueueOp(&CContextContactsAppUi::hide);
	
	}
	else
	{
		CAknViewAppUi::HandleWsEventL(aEvent, aDestination);
	}

}

