
#include "ContextContactsContainer.h"
#include <sendui.h>
#include <smut.h>
#include <SenduiMtmUids.h>
#include <txtrich.h>
#include <bautils.h>
#include <mmsconst.h>
#include <miutset.h>
#include <s32strm.h>
#include <akntitle.h> 
 
#include "doublelinebox.h"
#include "file_output_base.h"
#include <ContextContacts.rsg>
#include "contextcontacts.hrh"

#include "contextcontactsappui.h"

enum KEYCODES {
	JOY_LEFT = 0xF807,
	JOY_RIGHT = 0xF808,
	JOY_UP = 0xF809,
	JOY_DOWN = 0xF80A,
	JOY_CLICK = 0xF845,
	KEY_CALL = 0xF862,
	KEY_CANCEL = 0xF863,
	KEY_C = 0x0008
};

enum SCANCODES {
	CALL_SCAN = 0xC4,
	CANCEL_SCAN = 0xC5
};

void CContextContactsContainer::ConstructL(const TRect& aRect, phonebook* book, Cfile_output_base * log, CAknIconArray * aIconlist, CAknView * view)
{
	CALLSTACKITEM(_L("CContextContactsContainer::ConstructL"));

	{
		CALLSTACKITEM(_L("CContextContactsContainer::ConstructL::1"));
		aLog = log;
		aView = view;

		CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
		CAknTitlePane* tp=(CAknTitlePane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidTitle));
		HBufC* t=CEikonEnv::Static()->AllocReadResourceL(R_CONTACTS_TITLE);
		tp->SetText(t);
	}
	
	{
		CALLSTACKITEM(_L("CContextContactsContainer::ConstructL::2"));
		CreateWindowL();
		iCurrentVisibleSelection = new (ELeave) CArrayFixFlat<TInt>(100);
	}

	{
		CALLSTACKITEM(_L("CContextContactsContainer::ConstructL::3"));
		iIconlist = new (ELeave) CAknIconArray(30);
		for (TInt i = 0; i< aIconlist->Count();i++)
		{
			CGulIcon * ic, *icon_from; 
			icon_from= (*aIconlist)[i];
			ic=CGulIcon::NewL( icon_from->Bitmap(), icon_from->Mask());
			ic->SetBitmapsOwnedExternally(ETrue);
			iIconlist->AppendL( ic );
		}
	}

	{
		CALLSTACKITEM(_L("CContextContactsContainer::ConstructL::4"));
		aBook=book;
		aBook->set_observer(this);

		iListBoxArray=CPresenceArray::NewL(book);
		iNameArray=CNameArray::NewL(book);
	}

	{
		CALLSTACKITEM(_L("CContextContactsContainer::ConstructL::5"));
		iListbox=new (ELeave) doublelinebox(aBook, aLog);
		iListbox->SetContainerWindowL(*this);
		iListbox->ConstructL(iNameArray, iListBoxArray, this, EAknListBoxMarkableList);
		iListbox->SetItemHeightL(38);
		iListbox->View()->SetMatcherCursor(EFalse);
		iListbox->ItemDrawer()->FormattedCellData()->SetIconArray(iIconlist);
		iListbox->SetListBoxObserver(this);
		iListbox->Model()->SetItemTextArray(iNameArray);
		iListbox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);
		//FIX ME:
		iListbox->View()->SetListEmptyTextL(_L("(No match)"));
		iListbox->CreateScrollBarFrameL(ETrue);
		iListbox->ScrollBarFrame()->SetScrollBarVisibilityL( CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);
	}
	
	{
		CALLSTACKITEM(_L("CContextContactsContainer::ConstructL::6"));
		CAknSearchField::TSearchFieldStyle style(CAknSearchField::ESearch );
		iFindBox = CreateFindBoxL( iListbox, iListbox->Model(), style );
		iFindBox->MakeVisible( ETrue );

		SetRect(aRect);
		ActivateL();
	}
}

CContextContactsContainer::~CContextContactsContainer()
{
	CALLSTACKITEM(_L("CContextContactsContainer::~CContextContactsContainer"));

	if (aBook) aBook->set_observer(0);
	delete iFindBox;
	delete iListbox;
	delete iCurrentVisibleSelection;

	delete iNameArray;
	delete iListBoxArray;
}

void CContextContactsContainer::SizeChanged()
{
	CALLSTACKITEM(_L("CContextContactsContainer::SizeChanged"));


	if (iFindBox) {	SizeChangedForFindBox(); }
	TRect lb_rect=Rect();
	if ( iListbox )
        {
		if ( iFindBox )
		{
			lb_rect.Resize(0, -27);
		}
		else
		{
			lb_rect.Resize(0, 0);
			
		}
		lb_rect.Move(0, 0);
                iListbox->SetRect(lb_rect);
        }
	if (iFindBox) 
	{
		TRect edit_rect=Rect();
		edit_rect.SetHeight(10);
		edit_rect.Move(0, lb_rect.Height());
		iFindBox->SetRect(edit_rect);
		iFindBox->MakeVisible(ETrue);
		iFindBox->SetFocus(ETrue);
	}
}

TInt CContextContactsContainer::CountComponentControls() const
{
	CALLSTACKITEM(_L("CContextContactsContainer::CountComponentControls"));

	return 2; 
}

CCoeControl* CContextContactsContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM(_L("CContextContactsContainer::ComponentControl"));

	switch ( aIndex )
        {
		case 0:
			return iListbox;
			break;
		case 1:
			return iFindBox;
			break;
		default:
			return NULL;
        }
}
void CContextContactsContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM(_L("CContextContactsContainer::Draw"));


	CWindowGc& gc = SystemGc();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

void CContextContactsContainer::HandleControlEventL(
    CCoeControl* ,TCoeEvent )
{
	CALLSTACKITEM(_L("CContextContactsContainer::HandleControlEventL"));
}


TKeyResponse CContextContactsContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	CALLSTACKITEM(_L("CContextContactsContainer::OfferKeyEventL"));

	// the search field / listbox combo
	TBool needRefresh( EFalse );
	TBool flagsOfPopup( EFalse );
	if ( aType != EEventKey ) // Is not key event?
        {
		// the find field catches the key presses it needs
		// but doesn't actually do the search. This
		// triggers it
		if (iFilter) iFilter->HandleOfferkeyEventL();

		return EKeyWasNotConsumed;
        }
	if (aKeyEvent.iCode==JOY_LEFT || aKeyEvent.iCode == JOY_RIGHT)
	{
		return EKeyWasNotConsumed;
	} 
	        
	if ( iListbox )
        {
		if (aKeyEvent.iCode==JOY_DOWN || aKeyEvent.iCode == JOY_UP || aKeyEvent.iCode == JOY_CLICK)
		{
			return iListbox->OfferKeyEventL(aKeyEvent, aType);
		} 
		if (aKeyEvent.iCode==KEY_CALL)
		{
			if ( CountVisibleItems() >0 )
			{
				aView->HandleCommandL(EContextContactsCmdCall);
				return EKeyWasConsumed;
			}
			
		}
		if (aKeyEvent.iCode==KEY_C)
		{
			if ( (iFindBox) && (iFindBox->TextLength() == 0) && (CountVisibleItems() >0)  )
			{
				aView->HandleCommandL(EContextContactsCmdDelete);
				return EKeyWasConsumed;
			}
			
		}
		if (iFindBox) {
			TBool needs_refresh;
			return AknFind::HandleFindOfferKeyEventL( aKeyEvent, aType, this, iListbox, iFindBox, EFalse, needs_refresh);
		}
		if (iListbox) return iListbox->OfferKeyEventL(aKeyEvent, aType);
        }
	else
        {
		return EKeyWasNotConsumed;
        }
}

void CContextContactsContainer::before_change()
{
	CALLSTACKITEM(_L("CContextContactsContainer::before_change"));

	
	if (! iListbox ) {
		// still constructing
		return;
	}
	iCurrentIdx = get_current_idx();
	iTopIdx = get_current_top_idx();
}

void CContextContactsContainer::contents_changed()
{
	CALLSTACKITEM(_L("CContextContactsContainer::contents_changed"));


	if (!iListbox ) { return; }
	iListbox->HandleItemRemovalL();
	iFilter->HandleItemArrayChangeL();
	set_current_idx(iCurrentIdx);
	set_current_top_idx(iTopIdx);
}

void CContextContactsContainer::exiting()
{
	CALLSTACKITEM(_L("CContextContactsContainer::exiting"));

	aBook=0;
}

void CContextContactsContainer::HandleListBoxEventL(CEikListBox* aListBox, TListBoxEvent aEventType)
{
	CALLSTACKITEM(_L("CContextContactsContainer::HandleListBoxEventL"));


	if(aListBox == iListbox)
	{
		switch(aEventType)
		{
			case EEventEnterKeyPressed:
				show_presence_details_current();
				break;
			default:
				break;
		}
	}
}

void CContextContactsContainer::show_presence_details_current()
{
	CALLSTACKITEM(_L("CContextContactsContainer::show_presence_details_current"));


	TInt current_index = get_current_idx();
	if (current_index < 0) return;

	contact * c = aBook->GetContact(current_index);
	if (c == NULL || c->presence == NULL) return;

	//FIX ME: check the CPbkCOntact engine status for first name/last name
	TBuf<128> name;

	if (c->last_name) name.Append(*(c->last_name));
	if (c->last_name && c->last_name->Length()>0 && c->first_name && c->first_name->Length()>0) {
		name.Append(_L(" "));
	}
	if (c->first_name) name.Append(*(c->first_name));
	
	if (aLog) 
	{
		aLog->write_time();
		aLog->write_to_output(_L("Showing pres. details of "));
		aLog->write_to_output(name);
		aLog->write_nl();
	}
	((CContextContactsAppUi *)(iEikonEnv->AppUi()))->DisplayPresenceDetailsL(name, (aBook->GetContact(current_index))->presence);
}


CAknSearchField* CContextContactsContainer::CreateFindBoxL(CEikListBox* aListBox, CTextListBoxModel* aModel, CAknSearchField::TSearchFieldStyle aStyle )
{
	CALLSTACKITEM(_L("CContextContactsContainer::CreateFindBoxL"));

	CAknSearchField* findbox = NULL;

	if ( aListBox && aModel )
	{
		CAknFilteredTextListBoxModel* model = STATIC_CAST( CAknFilteredTextListBoxModel*, aModel );
		findbox = CAknSearchField::NewL( *this, aStyle, NULL, 30 );
		CleanupStack::PushL(findbox);
		model->CreateFilterL( aListBox, findbox );
		iFilter = model->Filter();

		iListbox->iPresenceModel->SetFilter(iFilter);
                CleanupStack::Pop(findbox); // findbox
        }
	return findbox;
}

void CContextContactsContainer::SizeChangedForFindBox()
{
	CALLSTACKITEM(_L("CContextContactsContainer::SizeChangedForFindBox"));

	if ( iListbox && iFindBox )
        {
		TInt findWindowResourceId( R_AVKON_FIND_PANE );
		TInt listAreaResourceId( R_AVKON_LIST_GEN_PANE_X );
		TInt findWindowParentId( R_AVKON_MAIN_PANE_PARENT_NONE );
		TBool flagsOfPopup( ETrue ); 
		//AknFind::HandleFindSizeChanged( this, iListbox, iFindBox, flagsOfPopup, findWindowResourceId,
		//listAreaResourceId, R_AVKON_LIST_GEN_PANE_WITH_FIND_POPUP, findWindowParentId );
	}
}

void CContextContactsContainer::MarkCurrentItemL()
{
	CALLSTACKITEM(_L("CContextContactsContainer::MarkCurrentItemL"));

	TInt real_idx = get_current_idx();
	iListbox->View()->ToggleItemL(iListbox->CurrentItemIndex());

	TInt found = -1;
	for (int i=0; (i< iCurrentVisibleSelection->Count()) && (found == -1) ;i++)
	{
		if (iCurrentVisibleSelection->At(i) == real_idx)
		{
			found = i;
		}
	}
	if (found != -1) // found!
	{
		iCurrentVisibleSelection->Delete(found);
	}
	else
	{
		iCurrentVisibleSelection->AppendL(real_idx);
	}
}

void CContextContactsContainer::MarkAllL()
{
	CALLSTACKITEM(_L("CContextContactsContainer::MarkAllL"));

	// matk all the visible items !
	for (TInt j = 0; j< iFilter->FilteredNumberOfItems(); j++)
	{
		iListbox->View()->SelectItemL(j);
		TInt real_idx = iFilter->FilteredItemIndex(j);
		int found = -1;
		for (int i=0; (i< iCurrentVisibleSelection->Count()) && (found == -1);i++)
		{
			if (iCurrentVisibleSelection->At(i) == real_idx)
			{
				found = i;
			}
		}
		if (found == -1) iCurrentVisibleSelection->AppendL(real_idx);
	}
}

void CContextContactsContainer::UnmarkAll()
{
	CALLSTACKITEM(_L("CContextContactsContainer::UnmarkAll"));

	iListbox->View()->ClearSelection();
	// unmark everything
	iCurrentVisibleSelection->Reset();
	iCurrentVisibleSelection->Compress();
}

TInt CContextContactsContainer::CountVisibleItems()
{
	CALLSTACKITEM(_L("CContextContactsContainer::CountVisibleItems"));

	return iFilter->FilteredNumberOfItems();
}

CArrayFix<TInt> * CContextContactsContainer::get_visible_selection()
{
	CALLSTACKITEM(_L("CContextContactsContainer::get_visible_selection"));

	// when an action ha been made on marked items, they return to unmarked state.
	if ( iListbox->View()->SelectionIndexes()->Count() == 0 )
	{
		iCurrentVisibleSelection->Reset();
	}
	return iCurrentVisibleSelection;
}

TInt CContextContactsContainer::get_current_idx()
{
	CALLSTACKITEM(_L("CContextContactsContainer::get_current_idx"));

	if (iFilter->FilteredNumberOfItems() == 0) return -1;
	TInt real_idx = iFilter->FilteredItemIndex(iListbox->CurrentItemIndex());
	return real_idx;
}

TInt CContextContactsContainer::get_current_top_idx()
{
	CALLSTACKITEM(_L("CContextContactsContainer::get_current_top_idx"));

	if (iFilter->FilteredNumberOfItems() == 0) return -1;
	TInt real_idx = iFilter->FilteredItemIndex(iListbox->TopItemIndex());
	return real_idx;
}


void CContextContactsContainer::set_current_idx(TInt real_idx)
{
	CALLSTACKITEM(_L("CContextContactsContainer::set_current_idx"));


	if (real_idx == -1) return;
	if (iFilter->FilteredNumberOfItems() < 1) return;

	TInt idx;
	if (real_idx > iFilter->FilteredNumberOfItems() )
	{
		idx = 0;	
	}
	else if (real_idx == iFilter->FilteredNumberOfItems())
	{
		idx = real_idx-1;
	}
	else
	{
		idx = iFilter->VisibleItemIndex(real_idx);
	}
	
	iListbox->View()->SetCurrentItemIndex(idx);
	iListbox->DrawNow();
}

void CContextContactsContainer::set_current_top_idx(TInt real_idx)
{
	CALLSTACKITEM(_L("CContextContactsContainer::set_current_top_idx"));

	if (real_idx == -1) return;
	if (iFilter->FilteredNumberOfItems() < 1) return;

	TInt idx;
	if (real_idx > iFilter->FilteredNumberOfItems() )
	{
		idx = 0;	
	}
	else if (real_idx == iFilter->FilteredNumberOfItems())
	{
		idx = real_idx-1;
	}
	else
	{
		idx = iFilter->VisibleItemIndex(real_idx);
	}
	iListbox->View()->SetTopItemIndex(idx);
	//iListbox->View()->SetCurrentItemIndex(idx);
	iListbox->DrawNow();
}

TBool CContextContactsContainer::IsCurrentMarked()
{
	CALLSTACKITEM(_L("CContextContactsContainer::IsCurrentMarked"));

	TInt idx = get_current_idx();

	const CListBoxView::CSelectionIndexArray* selectionArray = iListbox->View()->SelectionIndexes();

	TBool found = EFalse;
	for (TInt i = 0; (i < selectionArray->Count()) && (found == EFalse); i++)
	{
		if ((*selectionArray)[i] == idx) 
		{ 
			found = ETrue;
		}
	}
	return found;
}
