#include "ContextContactsDocument.h"
#include "ContextContactsAppUi.h"
#include "settings.h"

CContextContactsDocument::CContextContactsDocument(CEikApplication& aApp)
: CAknDocument(aApp)    
{
}

CContextContactsDocument::~CContextContactsDocument()
{
	delete iContext;
}

void CContextContactsDocument::ConstructL()
{
	iContext=CApp_context::NewL(false, _L("contacts"));
	CALLSTACKITEM(_L("CContextContactsDocument::ConstructL"));
	
#ifndef __WINS__
	TParsePtrC parse(Application()->DllName());
	iContext->SetAppDir(parse.DriveAndPath());
#else
	iContext->SetAppDir(_L("c:\\system\\apps\\contextcontacts\\"));
#endif
	iContext->SetDataDir(_L("c:\\system\\data\\context\\"), EFalse);
	CSettings* s=CSettings::NewL(*iContext, iNoDefaults, _L(""), true); // readonly settings
	iContext->SetSettings(s);
}

CContextContactsDocument* CContextContactsDocument::NewL(
							 CEikApplication& aApp)     // CContextContactsApp reference
{	
	CContextContactsDocument* self = new (ELeave) CContextContactsDocument( aApp );
	CleanupStack::PushL( self );
	self->ConstructL();
	CleanupStack::Pop();
	
	return self;
}


CEikAppUi* CContextContactsDocument::CreateAppUiL()
{
	CALLSTACKITEM(_L("CContextContactsDocument::CreateAppUiL"));
	
	return new (ELeave) CContextContactsAppUi(*iContext);
}

