#include "cc_settings.h"

const TSettingItem TCCSettings::KCCSettings[] = {
	{ 0, EEmpty, 0, -1, EFalse },	// no setting 0
	{ SETTING_NAME_DISPLAY, EBool, 0, 0, EFalse },
};

bool TCCSettings::GetDefaultL(TInt Setting, TDes& Value) const
{
	const TSettingItem i=KCCSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	if (i.iStringDefault) {
		Value=TPtrC((TText*)i.iStringDefault);
	} else {
		Value.Zero();
	}
	return i.iDefaultExists;
}

bool TCCSettings::GetDefaultL(TInt Setting, TDes8& Value) const
{
	const TSettingItem i=KCCSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	if (i.iStringDefault) {
		Value=TPtrC8((TText8*)i.iStringDefault);
	} else {
		Value.Zero();
	}
	return i.iDefaultExists;
}

bool TCCSettings::GetDefaultL(TInt Setting, TInt& Value) const
{
	const TSettingItem i=KCCSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	Value=i.iIntDefault;
	return i.iDefaultExists;
}

bool TCCSettings::GetDefaultL(TInt Setting, TTime& Value) const
{
	const TSettingItem i=KCCSettings[Setting];
	if (i.iSettingNo!=Setting) User::Leave(-1025);

	Value=i.iIntDefault;
	return i.iDefaultExists;
}