/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#include <flogger.h>

#include "doublelinebox.h"
#include <eikfrlbd.h> 
#include <eiklbv.h>

//#define CB_TRANSLATE_LOG 1
 

CPresenceModel* CPresenceModel::NewL(MDesCArray* aNameArray, MDesCArray* aPresenceArray)
{
	CPresenceModel* ret=new (ELeave) CPresenceModel(aNameArray, aPresenceArray);
	CleanupStack::PushL(ret);
	ret->ConstructL();
	CleanupStack::Pop();
	return ret;
}

CPresenceModel::CPresenceModel(MDesCArray* aNameArray, MDesCArray* aPresenceArray) : 
	iNameArray(aNameArray), iPresenceArray(aPresenceArray)
{
}

void CPresenceModel::ConstructL()
{
	CAknFilteredTextListBoxModel::ConstructL(iPresenceArray, ELbmDoesNotOwnItemArray);
}

void CPresenceModel::SetFilter(CAknListBoxFilterItems * aFilter)
{
	iFilter=aFilter;
}

TPtrC CPresenceModel::ItemText(TInt aItemIndex) const
{
	TInt idx=aItemIndex;
	if (iFilter) idx=iFilter->FilteredItemIndex(aItemIndex);

	return iPresenceArray->MdcaPoint(idx);
}

TInt CPresenceModel::NumberOfItems() const
{
	if (iFilter) return iFilter->FilteredNumberOfItems();
	return iPresenceArray->MdcaCount();
}

const MDesCArray* CPresenceModel::MatchableTextArray() const
{
	return iNameArray;
}

void doublelinebox::ConstructL(MDesCArray* aNameArray, MDesCArray* aPresenceArray, 
			       const CCoeControl* aParent,TInt aFlags)
{
	iPresenceModel=CPresenceModel::NewL(aNameArray, aPresenceArray);
	CEikFormattedCellListBox::ConstructL(aParent, aFlags);
}

void doublelinebox::LogItem(const TDesC& anItem)
{
	CALLSTACKITEM(_L("doublelinebox::LogItem"));


#ifdef CB_TRANSLATE_LOG
	TInt length = anItem.Length();
	
	if (iLog) 
		iLog->write_to_output(anItem.Mid(0,length-8 ));
	
	RArray<TInt> icons;

	TLex lex;
	TInt err, tmp;

	lex=anItem.Mid(length-2,2);
	err = lex.Val(tmp);
	if(!err)  icons.Append( tmp );
	
	lex=anItem.Mid(length-5,2);
	err = lex.Val(tmp);
	if(!err)  icons.Append( tmp );
	
	lex=anItem.Mid(length-8,2);
	err = lex.Val(tmp);
	if(!err)  icons.Append( tmp );
		
	TBool grey = EFalse;

	for (int i=0; i<icons.Count();i++)
	{
		switch (icons[i])
		{
		case 0:
			break;

		case 1:
			if (iLog) iLog->write_to_output(_L(" spkrOn"));
			break;

		case 2:
			if (iLog) iLog->write_to_output(_L(" spkrOff"));
			break;

		case 3:
			if (iLog) iLog->write_to_output(_L(" spkrOn"));
			grey= ETrue;
			break;

		case 4:
			if (iLog) iLog->write_to_output(_L(" spkrOff"));
			grey= ETrue;
			break;

		case 5:
			if (iLog) iLog->write_to_output(_L(" usrAct"));
			break;

		case 6:
			if (iLog) iLog->write_to_output(_L(" usrInact"));
			break;

		case 7:
			if (iLog) iLog->write_to_output(_L(" vibOn"));
			break;

		case 8:
			if (iLog) iLog->write_to_output(_L(" vibOff"));
			break;

		case 9:
			if (iLog) iLog->write_to_output(_L(" vibOn"));
			break;

		case 10:
			if (iLog) iLog->write_to_output(_L(" vibOff"));
			break;

		case 11:
			if (iLog) iLog->write_to_output(_L(" usrInact1"));
			break;

		case 12:
			if (iLog) iLog->write_to_output(_L(" usrInact2"));
			break;

		case 13:
			if (iLog) iLog->write_to_output(_L(" usrInact3"));
			break;
		
		default:
			break;
		}

		if (grey)
		{
			if (iLog) iLog->write_to_output(_L("(?)"));
		}
	}
	icons.Close();
#else
	if (iLog) iLog->write_to_output(anItem);
#endif
}

//-------------------------------------------------------------------------------------------

drawer::drawer(MTextListBoxModel *aTextListBoxModel, const CFont *aFont, CFormattedCellListBoxData *aFormattedCellData, phonebook_i* aBook, Cfile_output_base * aLog, doublelinebox *aListBox) :
		CFormattedCellListBoxItemDrawer(aTextListBoxModel, aFont, aFormattedCellData)
		{
			itemd=aFormattedCellData;
			iTextListBoxModel=aTextListBoxModel;
			iBook = aBook;
			iLog = aLog;
			iListBox = aListBox;
		}


void drawer::DrawItemText (TInt aItemIndex, const TRect &aItemTextRect, 
		TBool aItemIsCurrent, TBool aViewIsEmphasized, TBool aItemIsSelected) const 
{	
	CALLSTACKITEM(_L("drawer::DrawItemText"));


	//RDebug::Print(iListBox->Model()->ItemText(aItemIndex));

	TBool out_of_date = EFalse;
	contact * con = 0;
	if (iBook != NULL)
	{
		con = iBook->GetContact(aItemIndex); 
	}
	TInt buddies = 0;
	TInt others = 0;
	
	if ( (con!=0) && (con->presence!=0) )
	{
		buddies = con->presence->NeighbourhoodInfo().iBuddies;
		others = con->presence->NeighbourhoodInfo().iOtherPhones;
	}

	if ( buddies == 0 )
	{
		if (others == 0)
		{
			//let's resize some useful subcells!
			itemd->SetSubCellSizeL(1, TSize(176, 19) );
			itemd->SetSubCellSizeL(5, TSize(0, 19) );  //buddies
			itemd->SetSubCellSizeL(6, TSize(0, 19) );  // other phones
		}
		else
		{
			//let's resize some useful subcells!
			itemd->SetSubCellSizeL(1, TSize(156, 19) );
			itemd->SetSubCellSizeL(5, TSize(0, 19) );  //buddies
			itemd->SetSubCellSizeL(6, TSize(20, 19) );  // other phones
			itemd->SetSubCellPositionL(6, TPoint(156, 19) );
		}
	}
	else
	{	
		if (others == 0)
		{
			//let's resize some useless subcells!
			itemd->SetSubCellSizeL(1, TSize(150, 19) ); // location
			itemd->SetSubCellSizeL(5, TSize(20, 19) );  //buddies
			itemd->SetSubCellPositionL(5, TPoint(154, 19) );
			itemd->SetSubCellSizeL(6, TSize(0, 19) );  // other phones
		}
		else
		{
			//let's resize some useless subcells!
			itemd->SetSubCellSizeL(1, TSize(136, 19) ); // location
			itemd->SetSubCellSizeL(5, TSize(20, 19) );  //buddies
			itemd->SetSubCellPositionL(5, TPoint(134, 19) );
			itemd->SetSubCellSizeL(6, TSize(20, 19) );  // other phones
			itemd->SetSubCellPositionL(6, TPoint(154, 19) );
		}
	}
	if (!aItemIsSelected)
	{
		if ( (con!=0) && (con->presence!=0) )
		{
			itemd->SetSubCellSizeL(0, TSize(132,19));//name of contact
			itemd->SetSubCellPositionL(3, TPoint(142, 0) ); //vib
			itemd->SetSubCellSizeL(3, TSize(16,19));
			itemd->SetSubCellPositionL(4, TPoint(158, 0) ); //speaker
			itemd->SetSubCellSizeL(4, TSize(16,19));
			itemd->SetSubCellSizeL(7, TSize(0, 19) );  // marked 
			itemd->SetSubCellPositionL(7, TPoint(174, 0) );  //marked
		}
		else
		{
			itemd->SetSubCellSizeL(0, TSize(164,19));//name of contact
			itemd->SetSubCellPositionL(3, TPoint(142, 0) ); //vib
			itemd->SetSubCellSizeL(3, TSize(0,19));
			itemd->SetSubCellPositionL(4, TPoint(158, 0) ); //speaker
			itemd->SetSubCellSizeL(4, TSize(0,19));
			itemd->SetSubCellSizeL(7, TSize(0, 19) );  // marked 
			itemd->SetSubCellPositionL(7, TPoint(174, 0) );  //marked	
		}
	}
	else
	{
		if ( (con!=0) && (con->presence!=0) )
		{
			itemd->SetSubCellSizeL(0, TSize(132,19));//name of contact
			itemd->SetSubCellPositionL(3, TPoint(128, 0) ); //vib
			itemd->SetSubCellSizeL(3, TSize(16,19));
			itemd->SetSubCellPositionL(4, TPoint(144, 0) ); //speaker
			itemd->SetSubCellSizeL(4, TSize(16,19));
			itemd->SetSubCellSizeL(7, TSize(14, 19) );  // marked 
			itemd->SetSubCellPositionL(7, TPoint(160, 0) );  //marked
		}
		else
		{
			itemd->SetSubCellSizeL(0, TSize(150,19));//name of contact
			itemd->SetSubCellPositionL(3, TPoint(128, 0) ); //vib
			itemd->SetSubCellSizeL(3, TSize(0,19));
			itemd->SetSubCellPositionL(4, TPoint(144, 0) ); //speaker
			itemd->SetSubCellSizeL(4, TSize(0,19));
			itemd->SetSubCellSizeL(7, TSize(14, 19) );  // marked 
			itemd->SetSubCellPositionL(7, TPoint(160, 0) );  //marked
		}
	}

	if ( (con != NULL) && (con->presence != NULL) )
	{
		TTime stamp = con->presence->SendTimeStamp();
		out_of_date = IsOutOfDate(stamp );	
	}

	if ( out_of_date )
	{
		CFormattedCellListBoxData::TColors c = itemd->SubCellColors(1);
			
		c.iText = TRgb(128,128,128);
		c.iHighlightedText = TRgb(128,128,128);
			
		c.iBack = TRgb(255,255,255);
		c.iHighlightedBack = TRgb(230,230,230); 
	
		itemd->SetSubCellColorsL(1, c);
		itemd->SetSubCellColorsL(2, c);
		itemd->SetSubCellColorsL(3, c);
		itemd->SetSubCellColorsL(4, c);
		itemd->SetSubCellColorsL(5, c);
		itemd->SetSubCellColorsL(6, c);
		itemd->SetSubCellColorsL(7, c);

		CFormattedCellListBoxData::TColors c2 = itemd->SubCellColors(1);
		c2.iText = TRgb(0,0,0);
		c2.iHighlightedText = TRgb(0,0,0);
			
		c2.iBack = TRgb(255,255,255);
		c2.iHighlightedBack = TRgb(230,230,230); // original blue of the list items
		itemd->SetSubCellColorsL(0, c2); // sub cell 0 should always draw text in black
	}
	else
	{
		CFormattedCellListBoxData::TColors c = itemd->SubCellColors(1);
		
		c.iText = TRgb(0,0,0);
		c.iHighlightedText = TRgb(0,0,0);
		c.iBack = TRgb(255,255,255);	
		c.iHighlightedBack = TRgb(170,170,255); // original blue of the list items
		itemd->SetSubCellColorsL(1, c);
		itemd->SetSubCellColorsL(2, c);
		itemd->SetSubCellColorsL(3, c);
		itemd->SetSubCellColorsL(4, c);

		CFormattedCellListBoxData::TColors c2 = itemd->SubCellColors(1);
		c2.iText = TRgb(0,0,0);
		c2.iHighlightedText = TRgb(0,0,0);
		c2.iBack = TRgb(255,255,255);
		c2.iHighlightedBack = TRgb(170,170,255); // original blue of the list items
		itemd->SetSubCellColorsL(0, c2);
	}

	CFormattedCellListBoxItemDrawer::DrawItemText(aItemIndex, aItemTextRect,
			aItemIsCurrent, aViewIsEmphasized, aItemIsSelected);
		
	if ( aItemIsCurrent) { iListBox->LogVisibleItems(aItemIndex); }
}	

doublelinebox::doublelinebox(phonebook_i * aBook, Cfile_output_base * aLog) : CEikFormattedCellListBox(), book(aBook), iLog(aLog), iLastCurrentItemIndex(-1)
{
	CALLSTACKITEM(_L("doublelinebox::doublelinebox"));

}


void doublelinebox::CreateItemDrawerL(void)
{
	CALLSTACKITEM(_L("doublelinebox::CreateItemDrawerL"));

	CFormattedCellListBoxData* itemd=CFormattedCellListBoxData::NewL();

	CleanupStack::PushL(itemd);

	TMargins marg, marg2;
	marg.iBottom=marg.iTop=marg.iLeft=marg.iRight=0;
	marg2.iBottom=marg2.iTop=marg2.iRight=0;
	marg2.iLeft=2;

	//Name of contact
	itemd->SetSubCellMarginsL(0, marg);		
	itemd->SetSubCellSizeL(0, TSize(118, 18) );
	itemd->SetSubCellPositionL(0, TPoint(16, 0) );
	itemd->SetSubCellBaselinePosL(0, 14);
	itemd->SetSubCellFontL(0, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(0, CGraphicsContext::ELeft);
	
	//Textual PresenceInfo
	itemd->SetSubCellMarginsL(1, marg2);
	itemd->SetSubCellSizeL(1, TSize(166, 19) );
	itemd->SetSubCellPositionL(1, TPoint(0, 19) );
	itemd->SetSubCellBaselinePosL(1, 32);
	itemd->SetSubCellFontL(1, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(1, CGraphicsContext::ELeft);

	// Contact Icon (type of number)
	itemd->SetSubCellMarginsL(2, marg);
	itemd->SetSubCellSizeL(2, TSize(16, 19) );
	itemd->SetSubCellPositionL(2, TPoint(0, 0) );
	itemd->SetSubCellBaselinePosL(2, 17);
	itemd->SetSubCellFontL(2, iEikonEnv->DenseFont() );
	itemd->SetGraphicsSubCellL(2,ETrue);
	itemd->SetSubCellAlignmentL(2, CGraphicsContext::ECenter);

	// Ringing volume
	itemd->SetSubCellMarginsL(3, marg);
	itemd->SetSubCellSizeL(3, TSize(16, 19) );
	itemd->SetSubCellPositionL(3, TPoint(128, 0) );
	itemd->SetSubCellBaselinePosL(3, 17);
	itemd->SetSubCellFontL(3, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(3, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(3,ETrue);

	// Vibrator
	itemd->SetSubCellMarginsL(4, marg);
	itemd->SetSubCellSizeL(4, TSize(16, 19) );
	itemd->SetSubCellPositionL(4, TPoint(144, 0) );
	itemd->SetSubCellBaselinePosL(4, 17);
	itemd->SetSubCellFontL(4, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(4, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(4,ETrue);

	// BT buddies
	itemd->SetSubCellMarginsL(5, marg);
	itemd->SetSubCellSizeL(5, TSize(20, 19) );
	itemd->SetSubCellPositionL(5, TPoint(134, 19) );
	itemd->SetSubCellBaselinePosL(5, 32);
	itemd->SetSubCellFontL(5, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(5, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(5,ETrue);

	// other phones
	itemd->SetSubCellMarginsL(6, marg);
	itemd->SetSubCellSizeL(6, TSize(20, 19) );
	itemd->SetSubCellPositionL(6, TPoint(154, 19) );
	itemd->SetSubCellBaselinePosL(6, 32);
	itemd->SetSubCellFontL(6, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(6, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(6,ETrue);

	//Marked or not
	itemd->SetSubCellMarginsL(7, marg);
	itemd->SetSubCellSizeL(7, TSize(14, 19) );
	itemd->SetSubCellPositionL(7, TPoint(160, 0) );
	itemd->SetSubCellBaselinePosL(7, 17);
	itemd->SetSubCellFontL(7, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(7, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(7,ETrue);

	iItemDrawer=new (ELeave) drawer(iPresenceModel, iEikonEnv->NormalFont(), itemd, book, iLog, this);

	CleanupStack::Pop();	
}

doublelinebox::~doublelinebox()
{
	CALLSTACKITEM(_L("doublelinebox::~doublelinebox"));

	delete iPresenceModel;
}

void doublelinebox::LogVisibleItems(TInt currentItemIndex)
{
	CALLSTACKITEM(_L("doublelinebox::LogVisibleItems"));


		TBuf<800> buf;
		if (this->View()->ItemIsVisible(currentItemIndex-2))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex-2));
		}
		if (this->View()->ItemIsVisible(currentItemIndex-1))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex-1));
		}
		if (this->View()->ItemIsVisible(currentItemIndex))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex));
		}
		if (this->View()->ItemIsVisible(currentItemIndex+1))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex+1));
		}
		if (this->View()->ItemIsVisible(currentItemIndex+2))
		{
			buf.Append(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex+2));
		}

		if (currentItemIndex == iLastCurrentItemIndex && buf.Compare(iBuf) == 0)
		{
			return;
		}

//-----------------------------------

		if (iLog) iLog->write_time();
		if (iLog) iLog->write_to_output(_L("Items:"));

		if (this->View()->ItemIsVisible(currentItemIndex-2))
		{
			LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex-2));
			//if (iLog) iLog->write_to_output(this->Model()->ItemTextArray()->MdcaPoint(currentItemIndex-2));
			if (iLog) iLog->write_to_output(_L("/"));
		}

		if (this->View()->ItemIsVisible(currentItemIndex-1))
		{
			LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex-1));
			//if (iLog) iLog->write_to_output(this->Model()->ItemTextArray()->MdcaPoint(currentItemIndex-1));
			if (iLog) iLog->write_to_output(_L("/"));
		}

		if (iLog) iLog->write_to_output(_L("["));
		LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex));
		if (iLog) iLog->write_to_output(_L("]"));

		if (this->View()->ItemIsVisible(currentItemIndex+1))
		{
			if (iLog) iLog->write_to_output(_L("/"));
			LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex+1));
			//if (iLog) iLog->write_to_output(this->Model()->ItemTextArray()->MdcaPoint(currentItemIndex+1));
		}

		if (this->View()->ItemIsVisible(currentItemIndex+2))
		{
			if (iLog) iLog->write_to_output(_L("/"));
			//if (iLog) iLog->write_to_output(this->Model()->ItemTextArray()->MdcaPoint(currentItemIndex+2));
			LogItem(iPresenceModel->ItemTextArray()->MdcaPoint(currentItemIndex+2));
		}
		if (iLog) iLog->write_nl();

		iBuf=buf;
		iLastCurrentItemIndex = currentItemIndex;
}


TKeyResponse doublelinebox::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType)
{
	CALLSTACKITEM(_L("doublelinebox::OfferKeyEventL"));


	TKeyResponse resp = CEikFormattedCellListBox::OfferKeyEventL(aKeyEvent, aType);
	//LogVisibleItems(this->View()->CurrentItemIndex());
	return resp;
}






