/* 
Copyright (C) 2004  Mika Raento - Renaud Petit

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
    
     email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#include "phonebook.h"

#include <cpbkcontactengine.h> 
#include <cpbkcontactiter.h> 
#include <cpbkcontactitem.h> 
#include <cpbkmmsaddressselect.h>
#include <cpbkemailaddressselect.h>

#include <bamatch.h>
#include <contextcommon.mbg>
#include <contextcommon.rsg>
#include <cntdb.h>
#include <CPbkPhoneNumberSelect.h>
#include <cpbksmsaddressselect.h>
#include "presence_data.h"
#include <e32math.h>

#include <eikenv.h>
#include <bcardeng.h>
#include <icons.h>
#include <avkon.mbg>


#pragma warning(disable: 4706)

class CPresenceArrayImpl : public CPresenceArray {
public:
	CPresenceArrayImpl(phonebook_i* aPhoneBook);
	void ConstructL();
	virtual TInt MdcaCount() const;
	virtual TPtrC16 MdcaPoint(TInt aIndex) const;
	~CPresenceArrayImpl();
private:
	TBuf<11> prev; TBuf<30> not_avail;
	bool	last_name_first;
	phonebook_i*	iPhoneBook;
	mutable HBufC*	iBuf;
};

CPresenceArray* CPresenceArray::NewL(phonebook_i* aPhoneBook)
{
	CPresenceArrayImpl* ret=new (ELeave) CPresenceArrayImpl(aPhoneBook);
	CleanupStack::PushL(ret);
	ret->ConstructL();
	CleanupStack::Pop();
	return ret;
}

CPresenceArray::~CPresenceArray()
{
}


CPresenceArrayImpl::CPresenceArrayImpl(phonebook_i* aPhoneBook) : iPhoneBook(aPhoneBook)
{
}

CPresenceArrayImpl::~CPresenceArrayImpl()
{
	delete iBuf;
}

void CPresenceArrayImpl::ConstructL()
{
	iBuf=HBufC::NewL(256);

	CEikonEnv::Static()->ReadResourceAsDes16(prev, R_PREVIOUS_CAPTION);
	CEikonEnv::Static()->ReadResourceAsDes16(not_avail, R_JABBER_NOT_AVAIL);

	last_name_first=true;

#ifdef __S60V2__
	CPbkContactEngine *eng = CPbkContactEngine::Static();
	CPbkContactEngine::TPbkNameOrder order;
	if (!eng) {order = CPbkContactEngine::EPbkNameOrderLastNameFirstName;}
	else {order = eng->NameDisplayOrderL();}
	if (order != CPbkContactEngine::EPbkNameOrderLastNameFirstName) last_name_first=false;
#endif
}

TInt CPresenceArrayImpl::MdcaCount() const
{
	return iPhoneBook->Count();
}

TPtrC16 CPresenceArrayImpl::MdcaPoint(TInt aIndex) const
{
	contact* c=iPhoneBook->GetContact(aIndex);

	if (!c) {
		iBuf->Des().Zero();
		iBuf->Des().AppendFormat(_L("\t \t0\t0\t0\t0\t0\t%02d"), 
			GetIconIndex(EMbmAvkonQgn_indi_marked_add)); 
	} else {
		if (c->has_nick) {
			PresenceToListBoxL(c->presence, iBuf, 
				 c->last_name, c->first_name, prev, not_avail,
				 last_name_first);
		} else {
			c->Name(iBuf, last_name_first);

			iBuf->Des().AppendFormat(_L("\t \t0\t0\t0\t0\t0\t%02d"), 
				GetIconIndex(EMbmAvkonQgn_indi_marked_add)); 
			//type No_icon_to_display = 0 + last one for mark sign
		}
	}

	return iBuf->Des();
}

class CNameArrayImpl : public CNameArray {
public:
	CNameArrayImpl(phonebook_i* aPhoneBook);
	void ConstructL();
	virtual TInt MdcaCount() const;
	virtual TPtrC16 MdcaPoint(TInt aIndex) const;
	~CNameArrayImpl();
private:
	bool	last_name_first;
	phonebook_i*	iPhoneBook;
	mutable HBufC*	iBuf;
};

CNameArray* CNameArray::NewL(phonebook_i* aPhoneBook)
{
	CNameArrayImpl* ret=new (ELeave) CNameArrayImpl(aPhoneBook);
	CleanupStack::PushL(ret);
	ret->ConstructL();
	CleanupStack::Pop();
	return ret;
}

CNameArray::~CNameArray()
{
}


CNameArrayImpl::CNameArrayImpl(phonebook_i* aPhoneBook) : iPhoneBook(aPhoneBook)
{
}

CNameArrayImpl::~CNameArrayImpl()
{
	delete iBuf;
}

void CNameArrayImpl::ConstructL()
{
	iBuf=HBufC::NewL(256);

	last_name_first=true;

#ifdef __S60V2__
	CPbkContactEngine *eng = CPbkContactEngine::Static();
	CPbkContactEngine::TPbkNameOrder order;
	if (!eng) {order = CPbkContactEngine::EPbkNameOrderLastNameFirstName;}
	else {order = eng->NameDisplayOrderL();}
	if (order != CPbkContactEngine::EPbkNameOrderLastNameFirstName) last_name_first=false;
#endif
}

TInt CNameArrayImpl::MdcaCount() const
{
	return iPhoneBook->Count();
}

TPtrC16 CNameArrayImpl::MdcaPoint(TInt aIndex) const
{
	contact* c=iPhoneBook->GetContact(aIndex);

	if (!c) iBuf->Des().Zero();
	else {
		c->Name( iBuf, last_name_first);
	}
	
	return iBuf->Des();
}

contact* contact::NewL(TContactItemId i_id, const TDesC& i_first_name, const TDesC& i_last_name) 
{
	CALLSTACKITEM(_L("contact::NewL"));

	contact* c=new (ELeave) contact;
	CleanupStack::PushL(c);
	c->id=i_id;
	
	c->first_name=HBufC::NewL(i_first_name.Length());
	*(c->first_name)=i_first_name;
	
	c->last_name=HBufC::NewL(i_last_name.Length());
	*(c->last_name)=i_last_name;

	CleanupStack::Pop();
	return c;
}

void contact::Name(HBufC*& Into, bool last_name_first)
{
	contact *c=this;
	TInt len=c->first_name->Length()+c->last_name->Length()+50;
	if (len > Into->Des().MaxLength()) {
		delete Into;
		Into=HBufC::NewL(len);
	}

	if (last_name_first) 
	{
		*(Into)=*(c->last_name);
		if (c->last_name->Length()>0 && c->first_name->Length()>0) 
		{
			Into->Des().Append(_L(" "));
		}
		Into->Des().Append(*(c->first_name));
	} else {
		*(Into)=*(c->first_name);
		if (c->first_name->Length()>0 && c->last_name->Length()>0) 
		{
			Into->Des().Append(_L(" "));
		}
		Into->Des().Append(*(c->last_name));
	}
	if (Into->Des().Length() == 0)
	{
		Into->Des().Append(_L("(Unnamed)"));
	}
}

void contact::set_presence(MPresenceData* data)
{
	CALLSTACKITEM(_L("contact::set_presence"));

	if (presence) presence->Release();
	presence=data;
	if (data) data->AddRef();

}


contact::~contact() {
	if (presence) presence->Release();
	delete first_name;
	delete last_name;
}


class contacts_key : public TKey {
public:
	contacts_key(CArrayFixFlat<contact*> & i_arr, HBufC*& aname1, HBufC*& aname2, bool alast_name_first=true) : arr(i_arr), 
			name1(aname1), name2(aname2), last_name_first(alast_name_first) { }
	TInt Compare(TInt aLeft,TInt aRight) const {
		contact* left=arr[aLeft];
		contact* right=arr[aRight];
		if (left->has_nick && !right->has_nick) return -1;
		if (right->has_nick && !left->has_nick) return 1;
		
		left->Name(name1, last_name_first);
		right->Name(name2, last_name_first);
		return name1->Compare(*name2);
	}
private:
	CArrayFixFlat<contact*>& arr;
	HBufC*& name1; HBufC*& name2;
	bool last_name_first;
};

class contacts_swap : public TSwap {
public:
	contacts_swap(CArrayFixFlat<contact*> & i_arr) : arr(i_arr) { }
	void Swap(TInt aLeft,TInt aRight) const {
		contact* tmp=arr[aLeft];
		arr[aLeft]=arr[aRight];
		arr[aRight]=tmp;
	}
private:
	CArrayFixFlat<contact*>& arr;
};

phonebook::phonebook(MApp_context& Context, CJabberData& JabberData, CPresenceHolder& PresenceHolder) : 
MContextBase(Context), iJabberData(JabberData), iPresenceHolder(PresenceHolder)
{
	CALLSTACKITEM(_L("phonebook::phonebook"));


}

phonebook::~phonebook()
{
	CALLSTACKITEM(_L("phonebook::~phonebook"));

	if (obs) obs->exiting();
	
	delete current_ids;
	
	if (contacts) {
		reset_contacts();
	}
	delete contacts;
	
	delete contactitem;
	delete chnot;
	
	if (owns_engine) {
		delete eng;
	}
	
	delete iContactToIndex;
}

TInt phonebook::Count()
{
	return current_ids->Count();
}

TInt phonebook::GetContactId(TInt Index)
{
	CALLSTACKITEM(_L("phonebook::GetContactId"));


	if (Index<0 || Index >= current_ids->Count()) return KErrNotFound;
	return (*current_ids)[Index];
}

void phonebook::ConstructL()
{
	CALLSTACKITEM(_L("phonebook::ConstructL"));


	iContactToIndex=CGenericIntMap::NewL();
	
	current_ids=new (ELeave) CArrayFixFlat<TContactItemId>(50);
	
	eng=CPbkContactEngine::Static();
	
	if (eng) {
		owns_engine=false;
	} else {
		eng=CPbkContactEngine::NewL();
		owns_engine=true;
	}
	
	read_db();
	
	chnot=eng->CreateContactChangeNotifierL(this);
}

void phonebook::read_db()
{
	CALLSTACKITEM(_L("phonebook::read_db"));


	read_data(eng->CreateContactIteratorLC(ETrue));
	CleanupStack::PopAndDestroy();

	HBufC* name1=HBufC::NewL(200);
	CleanupStack::PushL(name1);
	HBufC* name2=HBufC::NewL(200);
	CleanupStack::PushL(name2);
	User::QuickSort(contacts->Count(), contacts_key(*contacts, name1, name2), contacts_swap(*contacts));
	CleanupStack::PopAndDestroy(2);
	
	filter(previous_filter, true);
}

void phonebook::HandleDatabaseEventL(TContactDbObserverEvent /*aEvent*/)
{
	CALLSTACKITEM(_L("phonebook::HandleDatabaseEventL"));


	read_db();
}

void phonebook::PresenceChangedL(TInt ContactId, MPresenceData& Info)
{
	CALLSTACKITEM(_L("phonebook::PresenceChangedL"));

	if (obs) obs->before_change();
	
	TInt idx=(TInt)iContactToIndex->GetData(ContactId);
	if (!idx) return;
	contact* c=(*contacts)[idx-1];
	c->set_presence(&Info);
	
	if (obs) obs->contents_changed();
}

void phonebook::Notify(const TDesC & /*aMessage*/)
{
	CALLSTACKITEM(_L("phonebook::Notify"));


	// no impl
}

phonebook_observer * phonebook::get_observer()
{
	CALLSTACKITEM(_L("phonebook::get_observer"));


	return obs;
}

TInt phonebook::GetIndex(TInt ContactId)
{
	CALLSTACKITEM(_L("phonebook::GetIndex"));


	TInt idx=(TInt)iContactToIndex->GetData(ContactId);
	if (!idx) return KErrNone;
	contact* c=(*contacts)[idx-1];
	TInt curr_idx=c->current_idx;
	if (!curr_idx) return KErrNone;
	return curr_idx-1;
}

void phonebook::reset_contacts()
{
	CALLSTACKITEM(_L("phonebook::reset_contacts"));


	//iContactToIndex->Reset();
	
	for (int i=0; i<contacts->Count(); i++) {
		delete (*contacts)[i];
	}
	contacts->Reset();
}

void phonebook::read_data(CPbkContactIter * iter)
{
	CALLSTACKITEM(_L("phonebook::read_data"));


	if (contacts) {
		TInt c=contacts->Count();
		reset_contacts();
		contacts->SetReserveL(c+1);
	} else {
		contacts=new (ELeave) CArrayFixFlat<contact*>(50);
	}
	
	CPbkContactItem *item=0;
	TBuf<100> first_name;
	TBuf<100> last_name;
	TBuf<100> jabber_nick;
	
	for (iter->FirstL(); (item=iter->CurrentL()); iter->NextL()) {
		
		TPbkContactItemField* f;
		
		f=item->FindField(EPbkFieldIdLastName);
		if (f) {
			last_name=f->Text();
		} else {
			last_name=_L("");
		}
		f=item->FindField(EPbkFieldIdFirstName);
		if (f) {
			first_name=f->Text();
		} else {
			first_name=_L("");
		}

		if (first_name.Length()==0 && last_name.Length()==0) {
			f=item->FindField(EPbkFieldIdCompanyName);
			if (f) last_name=f->Text();
		}

		contact* c=contact::NewL(item->Id(), first_name, last_name);
		if (iJabberData.GetJabberNickL(item->Id(), jabber_nick) && jabber_nick.Length()>1) {
			c->has_nick=true;
		}
		c->set_presence(iPresenceHolder.GetPresence(item->Id()));
		contacts->AppendL(c);
	}
}

void phonebook::ReRead()
{
	CALLSTACKITEM(_L("phonebook::ReRead"));

	read_db();
}


void phonebook::set_observer(phonebook_observer* i_obs)
{
	CALLSTACKITEM(_L("phonebook::set_observer"));


	obs=i_obs;
}

contact * phonebook::GetContact(TInt index)
{
	CALLSTACKITEM(_L("phonebook::GetContact"));


	TInt contactId = GetContactId(index);
	TInt idx=(TInt)iContactToIndex->GetData(contactId);
	if (!idx) return KErrNone;
	contact* c=(*contacts)[idx-1];
	return c;
}

bool phonebook::filter(const TDesC& /*substr*/, bool /*force*/)
{
	CALLSTACKITEM(_L("phonebook::filter"));

	if (obs) obs->before_change();
	
	current_ids->Reset();
	
	contact* ci;
	TInt idx=0;
	for (int i=0; i<contacts->Count(); i++) 
	{
		ci=(*contacts)[i];

		current_ids->AppendL( ci->id);
		iContactToIndex->AddDataL(ci->id, (void*) (i+1), true);
		ci->current_idx=idx+1;
		idx++;
	}

	if (obs) obs->contents_changed();
	return true;
}

CPbkContactEngine* phonebook::get_engine()
{
	CALLSTACKITEM(_L("phonebook::get_engine"));


	return eng;
}

CArrayFixFlat<contact*>* phonebook::GetContacts()
{
	CALLSTACKITEM(_L("phonebook::GetContacts"));


	return contacts;
}


// -------------------------------------------------------------

const TInt CPresenceUpdater::KTimeOut = 60;

CPresenceUpdater * CPresenceUpdater::NewL(phonebook_i& book)
{
	CALLSTACKITEM(_L("CPresenceUpdater::NewL"));


	auto_ptr<CPresenceUpdater> ret(new (ELeave) CPresenceUpdater(book));
	ret->ConstructL();
	return ret.release();
}

CPresenceUpdater::CPresenceUpdater(phonebook_i& book) : book(book), iWaiting(EFalse)
{
	CALLSTACKITEM(_L("CPresenceUpdater::CPresenceUpdater"));

}

CPresenceUpdater::~CPresenceUpdater()
{
	CALLSTACKITEM(_L("CPresenceUpdater::~CPresenceUpdater"));


	delete iWait;
}

void CPresenceUpdater::ConstructL()
{
	CALLSTACKITEM(_L("CPresenceUpdater::ConstructL"));


	iWait=CTimeOut::NewL(*this);
	Start();
}

void CPresenceUpdater::Start()
{
	CALLSTACKITEM(_L("CPresenceUpdater::Start"));


	Refresh();
	if (!iWaiting)
	{
		iWait->Wait(KTimeOut);
		iWaiting= ETrue;
	}
}

void CPresenceUpdater::Stop()
{
	CALLSTACKITEM(_L("CPresenceUpdater::Stop"));


	iWait->Reset();	
	iWaiting = EFalse;
}

void CPresenceUpdater::expired(CBase*)
{
	CALLSTACKITEM(_L("CPresenceUpdater::expired"));


	RDebug::Print(_L("refreshing..."));
	Refresh();
	if (iWaiting)
	{
		iWaiting = EFalse;
		Start();
	}
}

void CPresenceUpdater::Refresh()
{
	CALLSTACKITEM(_L("CPresenceUpdater::Refresh"));

	/*CArrayFixFlat<contact*> * contacts = book.GetContacts();
	for (int i=0; i< contacts->Count();i++)
	{
		if ( (*contacts)[i]->presence )
		{
			book.PresenceChangedL( (*contacts)[i]->id, *((*contacts)[i]->presence) );
		}
	}*/
}

TBuf<100> phonebook::ExportVCardToFile(TInt ContactId)
{
	CALLSTACKITEM(_L("phonebook::ExportVCardToFile"));

	TBuf<100> filename;

	TInt idx=(TInt)iContactToIndex->GetData(ContactId);
	contact* c=(*contacts)[idx-1];

        if (c == NULL) return (_L(""));
		
	if ( (c->first_name->Length() > 0) || (c->last_name->Length() >0) )
	{
		filename.Append(_L("C:\\"));
		filename.Append(c->first_name->Des());
		filename.Append(c->last_name->Des());
		filename.Append(_L(".vcf"));
	}
	else
	{
		filename.AppendFormat(_L("C:\\unnamed%02d.vcf"), c->id);
	}

	RFile outfile;
	TInt err = outfile.Replace(Fs(), filename, EFileWrite);
	if (err != KErrNone) return _L("");
		
	RFileWriteStream writeStream(outfile);
		
	CBCardEngine* cardEngine = CBCardEngine::NewL(get_engine()); 
	CleanupStack::PushL(cardEngine);

	CPbkContactItem* con = get_engine()->ReadContactLC(ContactId);	
	cardEngine->ExportBusinessCardL(writeStream, *con);
	CleanupStack::PopAndDestroy(con);

	writeStream.CommitL(); 
	writeStream.Close(); 
	outfile.Close(); 

	CleanupStack::PopAndDestroy(cardEngine);

	return filename;
}

	
