/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "phonehelper.h"
#include "app_context.h"
#include <txtrich.h>
#include <SenduiMtmUids.h>
#include <eikenv.h>
#include <rpbkviewresourcefile.h> 
#include <cpbkcontacteditordlg.h> 
#include <MsgBioUids.h>
#include <msvapi.h>
#include <msvids.h>
#include <aknviewappui.h> 
#include <cpbkcontactitem.h> 

class dummyhandler: public MMsvSessionObserver {
public:
	virtual void HandleSessionEventL(TMsvSessionEvent, TAny*, TAny*, TAny*) { }
};

void phonehelper::ConstructL()
{
	CALLSTACKITEM(_L("phonehelper::ConstructL"));

	iSendAppUi = CSendAppUi::NewL(0);

#ifndef __WINS__
	iStatus=KErrNone;
	
	User::LeaveIfError( server.Connect() );

	// load a phone profile
	_LIT(KGsmModuleName, "phonetsy.tsy");
	User::LeaveIfError( server.LoadPhoneModule( KGsmModuleName ) );

	// initialize the phone object
	RTelServer::TPhoneInfo info;
	User::LeaveIfError( server.GetPhoneInfo( 0, info ) );
	User::LeaveIfError( phone.Open( server, info.iName ) );

        RPhone::TLineInfo lineinfo;
        phone.GetLineInfo(0, lineinfo);
        line.Open(phone, lineinfo.iName);

#endif
	CActiveScheduler::Add(this); 
}

void phonehelper::CheckedRunL()
{
	CALLSTACKITEM(_L("phonehelper::CheckedRunL"));

	call.Close();
}

void phonehelper::DoCancel()
{
	CALLSTACKITEM(_L("phonehelper::DoCancel"));

	call.DialCancel();
}

phonehelper::~phonehelper()
{
	CALLSTACKITEM(_L("phonehelper::~phonehelper"));

	Cancel();

#ifndef __WINS__
	call.Close();

	line.Close();
	_LIT(KGsmModuleName, "phonetsy.tsy");
	phone.Close();
	server.UnloadPhoneModule( KGsmModuleName );

	server.Close();
#endif
	delete iSendAppUi;
}

RCall::TStatus phonehelper::line_status()
{
	CALLSTACKITEM(_L("RCall::TStatus"));


	RLine::TLineInfo lineinfo;
	#ifndef __WINS__
		line.GetInfo(lineinfo);
	#else
		lineinfo.iStatus=RCall::EStatusIdle;
	#endif
	return lineinfo.iStatus;
}

TInt phonehelper::make_call(const TDesC& number)
{
	CALLSTACKITEM(_L("phonehelper::make_call"));

	if (aLog) {
		aLog->write_time();
		aLog->write_to_output(_L("make call to "));
		aLog->write_to_output(number);
		aLog->write_nl();
	}

	// The status isn't reliable if no calls
	// have been made yet after startup
	/*
	if (line_status()!=RCall::EStatusIdle) {
		return -1;
	}

	*/

#ifndef __WINS__
	if (IsActive()) return -2;

	TInt ret=call.OpenNewCall(line);
	if (ret==KErrNone) {
		call.Dial(iStatus, number);
		SetActive();
	}
	return ret;
#else
	return KErrNone;
#endif
}

void phonehelper::send_sms(CDesCArrayFlat* recip, CDesCArrayFlat* alias)
{
	CALLSTACKITEM(_L("phonehelper::send_sms"));

	if (aLog) {
		aLog->write_time();
		aLog->write_to_output(_L("write sms to "));
		for (int i=0; i<recip->Count(); i++)
		{
			aLog->write_to_output( (*recip)[i] );
			aLog->write_to_output(_L(" "));
		}
		aLog->write_nl();
	}

	CParaFormatLayer* paraf=CParaFormatLayer::NewL();
	CleanupStack::PushL(paraf);

	CCharFormatLayer* charf=CCharFormatLayer::NewL();
	CleanupStack::PushL(charf);

	CRichText* body;
	body=CRichText::NewL(paraf, charf);
	CleanupStack::PushL(body);
		
	iSendAppUi->CreateAndSendMessageL(KSenduiMtmSmsUid, body, 0, KNullUid, recip, alias);
	CleanupStack::PopAndDestroy(3); // body, paraf, charf
}

void phonehelper::send_mms(CDesCArrayFlat* recip, CDesCArrayFlat* alias)
{
	CALLSTACKITEM(_L("phonehelper::send_mms"));

	if (aLog) {
		aLog->write_time();
		aLog->write_to_output(_L("write mms to "));
		for (int i=0; i<recip->Count(); i++)
		{
			aLog->write_to_output( (*recip)[i] );
			aLog->write_to_output(_L(" "));
		}
		aLog->write_nl();
	}

	CParaFormatLayer* paraf=CParaFormatLayer::NewL();
	CleanupStack::PushL(paraf);

	CCharFormatLayer* charf=CCharFormatLayer::NewL();
	CleanupStack::PushL(charf);

	CRichText* body;
	body=CRichText::NewL(paraf, charf);
	CleanupStack::PushL(body);
		
	iSendAppUi->CreateAndSendMessageL(KSenduiMtmMmsUid, body, 0, KNullUid, recip, alias);
	CleanupStack::PopAndDestroy(3); // body, paraf, charf
}

void phonehelper::send_email(CDesCArrayFlat* recip, CDesCArrayFlat* alias)
{
	CALLSTACKITEM(_L("phonehelper::send_email"));

	if (aLog) {
		aLog->write_time();
		aLog->write_to_output(_L("write email to "));
		for (int i=0; i<recip->Count(); i++)
		{
			aLog->write_to_output( (*recip)[i] );
			aLog->write_to_output(_L(" "));
		}
		aLog->write_nl();
	}

	CParaFormatLayer* paraf=CParaFormatLayer::NewL();
	CleanupStack::PushL(paraf);

	CCharFormatLayer* charf=CCharFormatLayer::NewL();
	CleanupStack::PushL(charf);

	CRichText* body;
	body=CRichText::NewL(paraf, charf);
	CleanupStack::PushL(body);
		
	iSendAppUi->CreateAndSendMessageL(KSenduiMtmSmtpUid, body, 0, KNullUid, recip, alias);
	CleanupStack::PopAndDestroy(3); // body, paraf, charf
}

void phonehelper::show_editor(TInt contact_id,  bool duplicate, TInt focus_field_index, CPbkFieldInfo * fieldInfo, const TDesC& no )
{
	CALLSTACKITEM(_L("phonehelper::show_editor"));

	CCoeEnv *env = CEikonEnv::Static();
	RPbkViewResourceFile pbkRes( *env);
	pbkRes.OpenL();
	CleanupClosePushL(pbkRes);

	CPbkContactItem* aContactItem=0;
	TBool create_new = EFalse;
	CPbkContactEngine * engine = aBook.get_engine();
	
	if (contact_id == -1) 
	{
		aContactItem=engine->CreateEmptyContactL();
		CleanupStack::PushL(aContactItem);
		create_new=ETrue;
	} 
	else 
	{
		aContactItem=engine->OpenContactLCX(contact_id);
		create_new=EFalse;
		if (duplicate) create_new=ETrue;
	}

	if (fieldInfo) 
	{
		TPbkContactItemField * field = aContactItem->AddOrReturnUnusedFieldL(*fieldInfo) ;
		if (field) field->TextStorage()->SetTextL(no);
		if (contact_id != -1)
		{
			focus_field_index = aContactItem->FindFieldIndex(*field);
		}
	}

	CPbkContactEditorDlg *ipPabDlg = CPbkContactEditorDlg::NewL(*engine, *aContactItem, create_new, focus_field_index );
	
	//ipPabDlg->SetMopParent( (CAknViewAppUi *) (CEikonEnv::Static()->AppUi()) );
	
	TInt res = KErrNone;
	TRAPD( err, res = ipPabDlg->ExecuteLD());
	if (contact_id == -1) 
	{
		CleanupStack::PopAndDestroy(2);  //contact_item, pbkRes
	} 
	else 
	{
		CleanupStack::PopAndDestroy(3);  //contact_item, lock, pbkRes
	}
}

void phonehelper::send_as(TUid mtmUid, CArrayFixFlat<TInt> * c)
{
	CALLSTACKITEM(_L("phonehelper::send_as"));

	CDesCArrayFlat* file_list = new CDesCArrayFlat(1);
	CleanupStack::PushL(file_list);
	
	// generate vcard files
	for (int i=0; i< c->Count(); i++)
	{
		TBuf<100> filename = aBook.ExportVCardToFile(c->At(i));
		if (filename.Length() >0 ) file_list->AppendL(filename);
	}

	if (file_list->Count() <= 0) 
	{
		CleanupStack::PopAndDestroy();
		return;
	}
	
	if (mtmUid == KSenduiMtmSmsUid)  // sending as a BIO message
	{
		CParaFormatLayer* paraf=CParaFormatLayer::NewL();
		CleanupStack::PushL(paraf);

		CCharFormatLayer* charf=CCharFormatLayer::NewL();
		CleanupStack::PushL(charf);

		CRichText* body;
		body=CRichText::NewL(paraf, charf);
		CleanupStack::PushL(body);

		TInt last_char_idx = 0;
		
		for (int i=0; i<file_list->Count();i++)
		{
			RFile tempfile;
			TInt err = tempfile.Open(Fs(), (*file_list)[i], EFileRead);
			TInt size;
			err = tempfile.Size(size);
			HBufC8 * temp8 = HBufC8::NewL(size);
			CleanupStack::PushL(temp8);
			TPtr8 des=temp8->Des();
			tempfile.Read(des);
			tempfile.Close();
			// cleaning
			Fs().Delete((*file_list)[i]);
		
			HBufC * temp16 = HBufC::NewL(des.Length()+10);
			CleanupStack::PushL(temp16);
			temp16->Des().Copy(des);
			body->InsertL(last_char_idx, temp16->Des() );
			last_char_idx += temp16->Length();
			CleanupStack::PopAndDestroy(2);  //temp8, temp16
		}
		
		CDesCArrayFlat* a=new CDesCArrayFlat(1);
		CleanupStack::PushL(a);
					
                iSendAppUi->CreateAndSendMessageL(KSenduiMtmSmsUid , body, 0, KMsgBioUidVCard, a);
		CleanupStack::PopAndDestroy(4); //a, body, paraf, charf
	}
	else  // sending as attachment
	{
		CParaFormatLayer* paraf=CParaFormatLayer::NewL();
		CleanupStack::PushL(paraf);

		CCharFormatLayer* charf=CCharFormatLayer::NewL();
		CleanupStack::PushL(charf);

		CRichText* body;
		body=CRichText::NewL(paraf, charf);
		CleanupStack::PushL(body);

		CDesCArrayFlat* a=new CDesCArrayFlat(1);
		CleanupStack::PushL(a);			

		iSendAppUi->CreateAndSendMessageL(mtmUid , body, file_list, KNullUid, a);
                		
		CleanupStack::PopAndDestroy(4); //body, charf, paraf, a

		for (int i=0; i<file_list->Count();i++)
		{
			// cleaning
			Fs().Delete((*file_list)[i]);
		}
	}
	CleanupStack::PopAndDestroy(file_list);
}

TBool phonehelper::mailbox_defined()
{
	CALLSTACKITEM(_L("phonehelper::mailbox_defined"));

	TBool mailbox_defined = EFalse;

	dummyhandler * dummy=new (ELeave) dummyhandler;
	CleanupStack::PushL(dummy);
	CMsvSession * session = CMsvSession::OpenSyncL(*dummy);
	CleanupStack::PushL(session);
	CMsvEntry* entry = CMsvEntry::NewL(*session, KMsvRootIndexEntryId ,TMsvSelectionOrdering());
	CleanupStack::PushL(entry);
	CMsvEntrySelection* imap = entry->ChildrenWithMtmL(KSenduiMtmImap4Uid);
	CleanupStack::PushL(imap);
	CMsvEntrySelection* pop = entry->ChildrenWithMtmL(KSenduiMtmPop3Uid);
	CleanupStack::PushL(pop);
	if ((imap->Count() >0) || (pop->Count()>0)) mailbox_defined = ETrue;
	CleanupStack::PopAndDestroy(5); //dummy, session, entry
	return mailbox_defined;
}