/*
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CContextNotifySession.h
#ifndef __CCONTEXTNOTIFYSESSION__
#define __CCONTEXTNOTIFYSESSION__

#include <e32base.h>
#include "ContextNotify.h"
#include "list.h"

class CContextNotifySession : public CSession
{

public: 
	static CContextNotifySession* NewL(RThread& aClient, CContextNotify& aServer);
	static CContextNotifySession* NewLC(RThread& aClient, CContextNotify& aServer);
	~CContextNotifySession();
	
	void ServiceL(const RMessage& aMessage);

private:
	CContextNotifySession(RThread& aClient, CContextNotify& aServer);
	void ConstructL() ;
	void PanicClient(TInt aPanic) const;

	void TerminateContextNotify(const RMessage& aMessage);

	void CompleteMessage(TInt Code);

	void AddIcon();
	void RemoveIcon();
	void ChangeIcon();
public: 
	void NotifyEvent(CContextNotify::TEvent aEvent);
	void ReportError(TContextNotifyRqstComplete aErrorType, TDesC & aErrorCode, TDesC & aErrorValue);
private: 
	
	RMessage            iMessage; TInt iMessageThreadId;
	void SetMessage(const RMessage& aMsg);
	CContextNotify&     iServer;
	CList<TInt>		*iIds;
};

#endif
