#include <e32base.h>
#include <flogger.h>
#include <e32svr.h>

void LogL(const TDesC& msg)
{
	RFileLogger iLog;
	User::LeaveIfError(iLog.Connect());
	CleanupClosePushL(iLog);
	iLog.CreateLog(_L("Context"),_L("Notify"),EFileLoggingModeAppend);
	RDebug::Print(msg.Left(128));
	
	iLog.CloseLog();
	CleanupStack::PopAndDestroy();
}

void Log(const TDesC& msg)
{
	TRAPD(err, LogL(msg));
	// ignore error, not much else we can do
	// and not critical
}
void LogL(const TDesC8& msg)
{
	RFileLogger iLog;
	User::LeaveIfError(iLog.Connect());
	CleanupClosePushL(iLog);
	iLog.CreateLog(_L("Context"),_L("Notify"),EFileLoggingModeAppend);
	iLog.Write(msg);
	//RDebug::Print(msg);
	
	// Close the log file and the connection to the server.
	iLog.CloseLog();
	CleanupStack::PopAndDestroy();
}

void Log(const TDesC8& msg)
{
	TRAPD(err, LogL(msg));
	// ignore error, not much else we can do
	// and not critical
}

void LogL(const TDesC& msg, TInt i)
{
	RFileLogger iLog;
	User::LeaveIfError(iLog.Connect());
	CleanupClosePushL(iLog);
	iLog.CreateLog(_L("Context"),_L("Notify"),EFileLoggingModeAppend);
	iLog.Write(msg);
	RDebug::Print(msg.Left(128));
	TBuf<10> iBuf;
	iBuf.Format(_L("%d"),i);
	iLog.Write(iBuf);
	RDebug::Print(iBuf);
	// Close the log file and the connection to the server.
	iLog.CloseLog();
	CleanupStack::PopAndDestroy();
}

void Log(const TDesC& msg, TInt /*i*/)
{
	TRAPD(err, LogL(msg));
	// ignore error, not much else we can do
	// and not critical
}

