/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CContextNotifyClientSession.cpp

#include "NotifyCommon.h"
#include "ContextNotifyClientSession.h"
#include <e32math.h>

static const TUint KDefaultMessageSlots = 2;
static const TUid KServerUid3 = {0x10204BAA}; // matches UID in server/group/ContextNotifyer.mbm file

_LIT(KContextNotifyFilename, "ContextNotify");

#ifdef __WINS__
static const TUint KServerMinHeapSize =  0x1000;  //  4K
static const TUint KServerMaxHeapSize = 0x10000;  // 64K
#endif

static TInt StartServer();
static TInt CreateServerProcess();


EXPORT_C RContextNotifyClientSession::RContextNotifyClientSession() : RSessionBase(), iIdPckg(0)
{
	
}

EXPORT_C TInt RContextNotifyClientSession::Connect()
{
	TInt result;
	
	result = ::StartServer();
	if (result == KErrNone)
	{
		result = CreateSession(KContextNotifyName,
			Version(),
			KDefaultMessageSlots);	
	}
	return result;
}

EXPORT_C void RContextNotifyClientSession::Close()
{
	RSessionBase::Close();
	delete iIdPckg; iIdPckg=0;
}

EXPORT_C TVersion RContextNotifyClientSession::Version() const
{
	return(TVersion(KContextNotifyMajorVersionNumber,
		KContextNotifyMinorVersionNumber,
		KContextNotifyBuildVersionNumber));
}

//----------------------------------------------------------------------------------------

EXPORT_C void RContextNotifyClientSession::Cancel() const
{
	SendReceive(ECancel, NULL);
}

EXPORT_C void RContextNotifyClientSession::TerminateContextNotify(TRequestStatus& aStatus)
{
	SendReceive(ETerminateContextNotify, NULL, aStatus);
}

EXPORT_C void RContextNotifyClientSession::AddIcon(CFbsBitmap* aIcon, CFbsBitmap* aMask, TInt& aId, TRequestStatus& aStatus)
{
	delete iIdPckg; iIdPckg=0; iIdPckg=new (ELeave) TPckg<TInt>(aId);

	TAny* messageParameters[KMaxMessageArguments];
	messageParameters[0] = (void*)aIcon->Handle();
	messageParameters[1] = (void*)aMask->Handle();
	messageParameters[2] = (void*)iIdPckg;

	SendReceive(EAddIcon, &messageParameters[0], aStatus);
}

EXPORT_C void RContextNotifyClientSession::RemoveIcon(TInt aId, TRequestStatus& aStatus)
{
	TAny* messageParameters[KMaxMessageArguments];
	messageParameters[0] = (void*)aId;
	SendReceive(ERemoveIcon, &messageParameters[0], aStatus);
}

EXPORT_C void RContextNotifyClientSession::ChangeIcon(CFbsBitmap* aIcon, CFbsBitmap* aMask, TInt aId, TRequestStatus& aStatus)
{
	TAny* messageParameters[KMaxMessageArguments];
	messageParameters[0] = (void*)aIcon->Handle();
	messageParameters[1] = (void*)aMask->Handle();
	messageParameters[2] = (void*)aId;

	SendReceive(EChangeIcon, &messageParameters[0], aStatus);
}

static TInt StartServer()
{
	TInt result;
	
	TFindServer findContextNotify(KContextNotifyName);
	TFullName name;
	
	result = findContextNotify.Next(name);
	if (result == KErrNone)
        {
		// Server already running
		return KErrNone;
        }
	
	RSemaphore semaphore;        
	result = semaphore.CreateGlobal(KContextNotifySemaphoreName, 0);
	if (result != KErrNone)
        {
		result=semaphore.OpenGlobal(KContextNotifySemaphoreName);
        }
	if (result != KErrNone)
        {
		return  result;
	}

	result = CreateServerProcess();
	if (result != KErrNone)
        {
		return  result;
        }
	
	semaphore.Wait();
	semaphore.Close();       
	
	return  KErrNone;
}

static TInt CreateServerProcess()
{
	TInt result;
	
	const TUidType serverUid(KNullUid, KNullUid, KServerUid3);
	
#ifdef __WINS__
	
	RLibrary lib;
	result = lib.Load(KContextNotifyFilename, _L("z:\\system\\programs"), serverUid);
	if (result != KErrNone)
        {
		return  result;
        }
	
	//  Get the WinsMain function
	TLibraryFunction functionWinsMain = lib.Lookup(1);
	
	//  Call it and cast the result to a thread function
	TThreadFunction serverThreadFunction = reinterpret_cast<TThreadFunction>(functionWinsMain());
	
	TName threadName(KContextNotifyName);
	
	// Append a random number to make it unique
	threadName.AppendNum(Math::Random(), EHex);
	
	RThread server;
	
	result = server.Create(threadName,   // create new server thread
		serverThreadFunction, // thread's main function
		KDefaultStackSize,
		NULL,
		&lib,
		NULL,
		KServerMinHeapSize,
		KServerMaxHeapSize,
		EOwnerProcess);
	
	lib.Close();    // if successful, server thread has handle to library now
	
	if (result != KErrNone)
        {
		return  result;
        }
	
	server.SetPriority(EPriorityMore);
	
	
#else
	
	RProcess server;
	
	result = server.Create(KContextNotifyFilename, _L(""), serverUid);
	if (result != KErrNone)
        {
		return  result;
        }
	
#endif
	
	server.Resume();
	server.Close();
	
	return KErrNone;
}
