/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/* Copyright (c) 2001, Nokia. All rights reserved */
#ifndef __ENGINENOTIFIER_H__
#define __ENGINENOTIFIER_H__

#include <ContextCommon.h>


/*! 
  @class MEngineNotifier
  
  @discussion This class specifies the error notification interface
  */
class MEngineNotifier  
    {
public:
/*!
  @enum TErrorType

  @discussion Error types encountered when reading/writing to a sockets
  @value EDisconnected A disconnected error has been encountered
  @value ETimeOutOnWrite A write operation has failed to complete within a predetermined period
  @value EGeneralReadError A general error has been encountered during a read
  @value EGeneralWriteError A general error has been encountered during a write
  */
    enum TErrorType
        {
        EDisconnected,
        ETimeOutOnWrite,
        EGeneralReadError,
        EGeneralWriteError,
		EIdentificationFailed,
		EIdentificationTimeOut,
		EStreamError,
		EXmlParseError,
		ETimeOutOnRead,
		ENetworkConnectError,
		EUnknownError,
		ESocketEngineTimeOut,
		EDNSLookupFailed
        };

/*!
  @function ReportError

  @discussion Report a communication error
  @param aErrorType error type
  @param aErrorCode associated error code
  */
	virtual void ReportError(TErrorType aErrorType, TInt aErrorCode) = 0;

/*!
  @function ResponseReceived

  @discussion Data has been received on the socket and read into a buffer
  @param aBuffer the data buffer
  */
	virtual void ResponseReceived(const TDesC8& aBuffer) = 0;

    };

class MContextServerNotifier
{
public:
	virtual void NotifyConnected() = 0;
	virtual void NotifyNewPresenceInfo(const TDesC & from, const TDesC & info, 
		const TTime& stamp)=0;
	virtual void ReportError(TContextServRqstComplete aErrorType , TDesC & aErrorCode, TDesC & aErrorValue) = 0;
	virtual void NotifyNewMessage(const TDesC & from, const TDesC& subject, const TDesC & message) = 0;
};


#endif // __ENGINENOTIFIER_H__
